/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.operations;

import oracle.eclipse.tools.common.operations.AbstractBasicOperation;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class RefreshProjectOperation
extends AbstractBasicOperation {
    private final IProject project;

    public RefreshProjectOperation(IProject project) {
        super(NLS.bind((String)Strings.refreshProjectOperation, (Object)project.getName()));
        this.project = project;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ProgressMonitorUtil.beginTask(monitor, 1);
        try {
            try {
                IPath projectLocation = this.project.getLocation();
                IContainer projectResource = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(projectLocation);
                projectResource.refreshLocal(2, ProgressMonitorUtil.submon(monitor, 1));
            }
            catch (CoreException e) {
                String errorMessage = "Could not refresh project " + this.project.getFullPath() + ". " + e.getLocalizedMessage();
                LoggingService.logError("oracle.eclipse.tools.common", errorMessage);
                Status status = new Status(4, "oracle.eclipse.tools.common", errorMessage);
                ProgressMonitorUtil.done(monitor);
                return status;
            }
        }
        finally {
            ProgressMonitorUtil.done(monitor);
        }
        return Status.OK_STATUS;
    }

    private static final class Strings
    extends NLS {
        public static String refreshProjectOperation;

        static {
            Strings.initializeMessages((String)RefreshProjectOperation.class.getName(), Strings.class);
        }

        private Strings() {
        }
    }
}

