/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.operations;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.operations.Predicate;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.osgi.framework.Bundle;

public class OperationUtil {
    public static final String DISABLE_FACET_DIALOGS_PROPERTY = "oracle.eclipse.tools.common.dialogs.disable";

    public static <T> List<T> filter(List<T> unfilteredList, Predicate<T> predicate) {
        ArrayList<T> filteredList = new ArrayList<T>();
        for (T listItem : unfilteredList) {
            if (!predicate.applies(listItem)) continue;
            filteredList.add(listItem);
        }
        return Collections.unmodifiableList(filteredList);
    }

    public static boolean areDialogsDisabled() {
        return Boolean.valueOf(System.getProperty(DISABLE_FACET_DIALOGS_PROPERTY, "false"));
    }

    public static boolean areDialogsEnabled() {
        return !OperationUtil.areDialogsDisabled();
    }

    public static File getFileFromBundle(Plugin plugin, String relativePathForFile) throws IOException, URISyntaxException {
        File file;
        Bundle bundle = plugin.getBundle();
        URL bundleUrl = bundle.getEntry(relativePathForFile);
        URL fileUrl = FileLocator.toFileURL((URL)bundleUrl);
        try {
            file = new File(fileUrl.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(fileUrl.getPath());
        }
        return file;
    }

    public static String getContentFolderName(IProject project) throws CoreException {
        return OperationUtil.getWebContentFolderName(project);
    }

    public static IContainer getContentFolderResource(IProject project) throws CoreException {
        return OperationUtil.getWebContentFolderIResource(project);
    }

    public static String getWebContentFolderName(IProject project) throws CoreException {
        return OperationUtil.getWebContentFolderIResource(project).getName();
    }

    public static String getSrcFolderName(IProject project) throws CoreException {
        IResource srcFolderResource = OperationUtil.getSrcFolderResource(project);
        if (srcFolderResource != null) {
            return srcFolderResource.getName();
        }
        throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.common", "Cannot find any source path roots in project " + project.getName()));
    }

    public static IResource getSrcFolderResource(IProject project) throws CoreException {
        IPackageFragmentRoot[] roots;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getAllPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.getKind() == 1) {
                return root.getResource();
            }
            ++n2;
        }
        throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.common", "Cannot find any source path roots in project " + project.getName()));
    }

    public static IContainer getWebContentFolderIResource(IProject project) throws CoreException {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            throw OperationUtil.cannotResolveProjectPathException();
        }
        IVirtualFolder rootFolder = component.getRootFolder();
        if (rootFolder == null) {
            throw OperationUtil.cannotResolveProjectPathException();
        }
        IContainer underlyingFolder = rootFolder.getUnderlyingFolder();
        if (underlyingFolder == null) {
            throw OperationUtil.cannotResolveProjectPathException();
        }
        return underlyingFolder;
    }

    private static CoreException cannotResolveProjectPathException() {
        return new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.common", "Cannot resolve project config path"));
    }
}

