/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.operations;

import oracle.eclipse.tools.common.CommonToolsPlugin;
import oracle.eclipse.tools.common.operations.CompoundOperation;
import oracle.eclipse.tools.common.operations.ICompoundOperation;
import oracle.eclipse.tools.common.operations.ICompoundOperationConfigurator;
import oracle.eclipse.tools.common.operations.IOperation;
import oracle.eclipse.tools.common.operations.OperationConfiguratorLoader;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public final class CompoundOperationExecutor {
    private static final String CONFIGURATOR_EXTENSION_ID = "oracle.eclipse.tools.common.ui.oracle.eclipse.tools.common.configurator";

    public static IStatus executeWithPrompt(IProgressMonitor monitor, String task, IOperation ... operations) throws CoreException {
        CompoundOperation compound = new CompoundOperation(task);
        IOperation[] iOperationArray = operations;
        int n = operations.length;
        int n2 = 0;
        while (n2 < n) {
            IOperation op = iOperationArray[n2];
            compound.add(op);
            ++n2;
        }
        return CompoundOperationExecutor.executeWithPrompt(monitor, compound);
    }

    public static IStatus executeWithPrompt(IProgressMonitor monitor, ICompoundOperation operation) throws CoreException {
        return CompoundOperationExecutor.execute(monitor, operation, true);
    }

    public static IStatus execute(IProgressMonitor monitor, ICompoundOperation operation, boolean prompt) throws CoreException {
        try {
            ICompoundOperationConfigurator configurator = new OperationConfiguratorLoader(CONFIGURATOR_EXTENSION_ID).getConfiguratorObject();
            ICompoundOperation configuredCompoundOperation = configurator.configure(operation);
            IStatus st = configuredCompoundOperation.execute(monitor, null);
            if (!st.isOK()) {
                CommonToolsPlugin.log(st);
            }
            return st;
        }
        catch (ExecutionException e) {
            throw new CoreException(CommonToolsPlugin.createErrorStatus((Exception)((Object)e)));
        }
    }
}

