/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.operations;

import oracle.eclipse.tools.common.operations.AbstractBasicOperation;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.wtp.webxml.WebXmlUpdater;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class AddFilterOperation
extends AbstractBasicOperation {
    private final IProject project;
    private final String filterName;
    private final String filterClass;

    public AddFilterOperation(IProject project, String filterName, String filterClass) {
        super(NLS.bind((String)Strings.operationLabel, (Object)filterName));
        this.project = project;
        this.filterName = filterName;
        this.filterClass = filterClass;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ProgressMonitorUtil.beginTask(monitor, 1);
        try {
            WebXmlUpdater updater = new WebXmlUpdater(this.project, ProgressMonitorUtil.submon(monitor, 1));
            updater.addFilter(this.filterName, this.filterClass);
        }
        finally {
            ProgressMonitorUtil.done(monitor);
        }
        return Status.OK_STATUS;
    }

    private static final class Strings
    extends NLS {
        public static String operationLabel;

        static {
            Strings.initializeMessages((String)AddFilterOperation.class.getName(), Strings.class);
        }

        private Strings() {
        }
    }
}

