/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.operations;

import oracle.eclipse.tools.common.operations.AbstractBasicOperation;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.DefaultRenderKitIdType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.osgi.util.NLS;

public class AddDefaultRenderKitOperation
extends AbstractBasicOperation {
    private final String defaultRenderKitId;
    private IProject project;
    private String facesConfigurationFilePath;

    public AddDefaultRenderKitOperation(String defaultRenderKitId, IProject project, String facesConfigurationFilePath) {
        super(NLS.bind((String)Strings.operationLabel, (Object)defaultRenderKitId));
        this.defaultRenderKitId = defaultRenderKitId;
        this.project = project;
        this.facesConfigurationFilePath = facesConfigurationFilePath;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ProgressMonitorUtil.beginTask(monitor, 1);
        FacesConfigArtifactEdit facesConfigArtifactEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)this.project, (String)this.facesConfigurationFilePath);
        if (facesConfigArtifactEdit.getFacesConfig() == null) {
            throw new IllegalArgumentException("FacesConfigArtifactEdit is expected to be non-null");
        }
        FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
        FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
        try {
            DefaultRenderKitIdType renderKitTag = facesConfigFactory.createDefaultRenderKitIdType();
            renderKitTag.setTextContent(this.defaultRenderKitId);
            EList applicationList = facesConfigArtifactEdit.getFacesConfig().getApplication();
            if (applicationList.size() == 0) {
                ApplicationType application = facesConfigFactory.createApplicationType();
                application.getDefaultRenderKitId().add((Object)renderKitTag);
                facesConfigArtifactEdit.getFacesConfig().getApplication().add((Object)application);
            } else if (!this.existsRenderKitId(renderKitTag.getTextContent(), applicationList)) {
                ApplicationType application = (ApplicationType)applicationList.get(0);
                application.getDefaultRenderKitId().add((Object)renderKitTag);
            }
            facesConfigArtifactEdit.save(ProgressMonitorUtil.submon(monitor, 1));
        }
        finally {
            ProgressMonitorUtil.done(monitor);
            if (facesConfigArtifactEdit != null) {
                facesConfigArtifactEdit.dispose();
                assert (facesConfigArtifactEdit.isDisposed());
            }
        }
        return Status.OK_STATUS;
    }

    private boolean existsRenderKitId(String renderKitId, EList<?> applicationList) {
        for (Object application : applicationList) {
            for (Object defaultRenderKit : ((ApplicationType)application).getDefaultRenderKitId()) {
                if (!((DefaultRenderKitIdType)defaultRenderKit).getTextContent().equals(renderKitId)) continue;
                return true;
            }
        }
        return false;
    }

    private static final class Strings
    extends NLS {
        public static String operationLabel;

        static {
            Strings.initializeMessages((String)AddDefaultRenderKitOperation.class.getName(), Strings.class);
        }

        private Strings() {
        }
    }
}

