/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.operations.AbstractBasicOperation;
import oracle.eclipse.tools.common.operations.ICompoundOperation;
import oracle.eclipse.tools.common.operations.IOperation;
import oracle.eclipse.tools.common.operations.OperationUtil;
import oracle.eclipse.tools.common.operations.Predicate;

public abstract class AbstractCompoundOperation
extends AbstractBasicOperation
implements ICompoundOperation {
    protected final List<IOperation> operationList = new ArrayList<IOperation>();

    public AbstractCompoundOperation(String label) {
        super(label);
    }

    public AbstractCompoundOperation(String label, List<IOperation> operationList) {
        this(label);
        for (IOperation operation : operationList) {
            this.add(operation);
        }
    }

    @Override
    public void add(IOperation operation) {
        this.operationList.add(operation);
    }

    @Override
    public void remove(IOperation operation) {
        this.operationList.remove(operation);
        operation.dispose();
    }

    @Override
    public List<IOperation> getOperationList() {
        return Collections.unmodifiableList(this.operationList);
    }

    @Override
    public List<IOperation> getSelectedOperationList() {
        return OperationUtil.filter(this.operationList, new Predicate<IOperation>(){

            @Override
            public boolean applies(IOperation operation) {
                return operation.isSelected();
            }
        });
    }
}

