/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.builder;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import oracle.eclipse.tools.common.builder.BuilderPlugin;
import oracle.eclipse.tools.common.util.ValidateEditUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;

public final class BuilderUtils {
    private static final String CLASSPATH_ENTRY = "CLASSPATH_ENTRY";
    private static final String INCLUDES_PATTERN = "INCLUDES_PATTERN";
    private static final String EXCLUDES_PATTERN = "EXCLUDES_PATTERN";
    private static final String OUTPUT_DIR = "OUPUT_DIR";

    public static IPath getStateFolder(IProject project) {
        return new ProjectScope(project).getLocation();
    }

    public static boolean modifyEntry(List<IClasspathEntry> classpath, BuildPathInfo pathInfo) {
        boolean modified = false;
        ListIterator<IClasspathEntry> iterator = classpath.listIterator();
        boolean newPathAlreadyExists = false;
        if (pathInfo._oldPath != null && pathInfo._oldPath.equals((Object)pathInfo._newPath)) {
            pathInfo._oldPath = null;
        }
        pathInfo._newPath = BuilderUtils.changeDeviceToUpperCase(pathInfo._newPath);
        pathInfo._oldPath = BuilderUtils.changeDeviceToUpperCase(pathInfo._oldPath);
        while (iterator.hasNext()) {
            IClasspathEntry entry = iterator.next();
            IPath entryPath = entry.getPath();
            if (entry.getEntryKind() != pathInfo._kind) continue;
            if (pathInfo._newPath != null && entryPath.equals((Object)pathInfo._newPath)) {
                newPathAlreadyExists = true;
            }
            if (pathInfo._oldPath == null || !entryPath.equals((Object)pathInfo._oldPath)) continue;
            iterator.remove();
            modified = true;
        }
        if (pathInfo._newPath != null && !newPathAlreadyExists) {
            IClasspathEntry newEntry = null;
            if (pathInfo._kind == 1) {
                newEntry = JavaCore.newLibraryEntry((IPath)pathInfo._newPath, null, null, (boolean)pathInfo._exported);
            } else if (pathInfo._kind == 3) {
                newEntry = JavaCore.newSourceEntry((IPath)pathInfo._newPath, (IPath[])new IPath[0], (IPath)pathInfo._outputPath);
            } else if (pathInfo._kind == 5) {
                newEntry = JavaCore.newContainerEntry((IPath)pathInfo._newPath, (boolean)pathInfo._exported);
            }
            classpath.add(newEntry);
            modified = true;
        }
        return modified;
    }

    private static IPath changeDeviceToUpperCase(IPath path) {
        if (path != null && path.getDevice() != null) {
            return path.setDevice(path.getDevice().toUpperCase());
        }
        return path;
    }

    public static void writeClasspaths(final List<IClasspathEntry> classpaths, final IFile file, final IProject project) throws IOException, CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IStatus status;
                if (!file.exists()) {
                    BuilderUtils.createParents(file.getParent());
                    file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
                } else if (file.isReadOnly() && !(status = ValidateEditUtil.validateEdit(file)).isOK()) {
                    throw new CoreException(status);
                }
                Writer writer = null;
                try {
                    try {
                        writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file.getRawLocation().toFile()), StandardCharsets.UTF_8);
                        int i = 0;
                        for (IClasspathEntry entry : classpaths) {
                            IPath pattern;
                            BuilderUtils.writePath(writer, entry.getPath(), BuilderUtils.CLASSPATH_ENTRY + i + "=", project);
                            IPath[] patterns = entry.getInclusionPatterns();
                            int j = 0;
                            IPath[] iPathArray = patterns;
                            int n = patterns.length;
                            int n2 = 0;
                            while (n2 < n) {
                                pattern = iPathArray[n2];
                                BuilderUtils.writePath(writer, pattern, BuilderUtils.INCLUDES_PATTERN + i + j++ + "=", project);
                                ++n2;
                            }
                            patterns = entry.getExclusionPatterns();
                            j = 0;
                            iPathArray = patterns;
                            n = patterns.length;
                            n2 = 0;
                            while (n2 < n) {
                                pattern = iPathArray[n2];
                                BuilderUtils.writePath(writer, pattern, BuilderUtils.EXCLUDES_PATTERN + i + j++ + "=", project);
                                ++n2;
                            }
                            if (entry.getOutputLocation() != null) {
                                BuilderUtils.writePath(writer, entry.getOutputLocation(), BuilderUtils.OUTPUT_DIR + i + "=", project);
                            }
                            ++i;
                        }
                        writer.flush();
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                }
                catch (IOException ioe) {
                    throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.common.builder", 0, ioe.getLocalizedMessage(), (Throwable)ioe));
                }
            }
        };
        try {
            IWorkspace workspace = project.getWorkspace();
            IResourceRuleFactory factory = workspace.getRuleFactory();
            if (((Workspace)workspace).getWorkManager().isLockAlreadyAcquired()) {
                runnable.run(null);
            } else {
                ISchedulingRule rule = MultiRule.combine((ISchedulingRule)factory.createRule((IResource)file.getParent()), (ISchedulingRule)factory.modifyRule((IResource)file));
                workspace.run(runnable, rule, 0, null);
            }
        }
        catch (OperationCanceledException e) {
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.common.builder", 0, e.getLocalizedMessage(), (Throwable)e));
        }
    }

    private static void createParents(IContainer parent) throws CoreException {
        if (!parent.exists()) {
            if (parent instanceof IFolder) {
                ((IFolder)parent).create(true, true, null);
                BuilderUtils.createParents(parent.getParent());
            } else {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.common.builder", 0, BuilderPlugin.getResourceString("not-a-folder"), null));
            }
        }
    }

    private static void writePath(Writer writer, IPath path, String prefix, IProject project) throws IOException {
        writer.write(prefix);
        if (project.getFullPath().isPrefixOf(path)) {
            writer.write(path.removeFirstSegments(1).toPortableString());
        } else {
            writer.write(path.toPortableString());
        }
        writer.write("\n");
    }

    public static List<IClasspathEntry> readClasspaths(IFile file, IProject project) throws IOException {
        ArrayList<IClasspathEntry> classpaths = new ArrayList<IClasspathEntry>();
        if (!file.exists()) {
            return classpaths;
        }
        BufferedReader reader = null;
        try {
            file.deleteMarkers("oracle.eclipse.tools.common.builder.problem", true, 0);
        }
        catch (CoreException coreException) {}
        try {
            String line;
            try {
                file.refreshLocal(0, null);
                reader = new LineNumberReader(new InputStreamReader(file.getContents(), StandardCharsets.UTF_8));
            }
            catch (CoreException ce) {
                LoggingService.logException((Plugin)BuilderPlugin.getDefault(), ce);
                ArrayList<IClasspathEntry> arrayList = classpaths;
                if (reader != null) {
                    reader.close();
                }
                return arrayList;
            }
            ArrayList<String> includes = new ArrayList<String>();
            ArrayList<String> excludes = new ArrayList<String>();
            String outputDirPath = null;
            String classpath = null;
            while ((line = ((LineNumberReader)reader).readLine()) != null) {
                if (line.startsWith(CLASSPATH_ENTRY)) {
                    BuilderUtils.createIClasspathEntry(classpaths, classpath, includes, excludes, outputDirPath, project);
                    classpath = null;
                    includes.clear();
                    excludes.clear();
                    outputDirPath = null;
                    classpath = line.substring(line.indexOf(61) + 1);
                    continue;
                }
                if (line.startsWith(INCLUDES_PATTERN)) {
                    includes.add(line.substring(line.indexOf(61) + 1));
                    continue;
                }
                if (line.startsWith(EXCLUDES_PATTERN)) {
                    excludes.add(line.substring(line.indexOf(61) + 1));
                    continue;
                }
                if (line.startsWith(OUTPUT_DIR)) {
                    outputDirPath = line.substring(line.indexOf(61) + 1);
                    continue;
                }
                try {
                    IMarker marker = file.createMarker("oracle.eclipse.tools.common.builder.problem");
                    marker.setAttribute("severity", 1);
                    marker.setAttribute("message", (Object)BuilderPlugin.getString("invalid-entry-in-src-paths-file", line, file.getFullPath()));
                }
                catch (CoreException coreException) {}
            }
            BuilderUtils.createIClasspathEntry(classpaths, classpath, includes, excludes, outputDirPath, project);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return classpaths;
    }

    private static void createIClasspathEntry(List<IClasspathEntry> classpaths, String classpath, List<String> includesPatterns, List<String> excludesPatterns, String outputDir, IProject project) {
        if (classpath == null) {
            return;
        }
        IPath outputPath = null;
        if (outputDir != null) {
            outputPath = BuilderUtils.parsePath(outputDir, project);
        }
        classpaths.add(JavaCore.newSourceEntry((IPath)BuilderUtils.parsePath(classpath, project), (IPath[])BuilderUtils.getPaths(includesPatterns), (IPath[])BuilderUtils.getPaths(excludesPatterns), (IPath)outputPath));
    }

    private static IPath parsePath(String pathStr, IProject project) {
        IPath path = Path.fromOSString((String)pathStr);
        if (!path.isAbsolute()) {
            return project.getFullPath().append(path);
        }
        return path;
    }

    private static IPath[] getPaths(List<String> pathStrs) {
        IPath[] paths = new IPath[pathStrs.size()];
        int i = 0;
        while (i < pathStrs.size()) {
            paths[i] = Path.fromOSString((String)pathStrs.get(i));
            ++i;
        }
        return paths;
    }

    public static boolean hasBuilder(IProject project, String builderId) throws CoreException {
        ICommand[] commands;
        if (project == null) {
            return false;
        }
        IProjectDescription desc = project.getDescription();
        ICommand[] iCommandArray = commands = desc.getBuildSpec();
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (command.getBuilderName().equals(builderId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean augmentBuildSpec(IProject project, String builderToAdd, String postBuilder, String preBuilder) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        boolean hasPostBuilder = false;
        boolean hasPreBuilder = false;
        boolean addedBuilder = false;
        ICommand[] iCommandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (command.getBuilderName().equals(builderToAdd)) {
                return false;
            }
            if (postBuilder != null && command.getBuilderName().equals(postBuilder)) {
                hasPostBuilder = true;
                hasPreBuilder = false;
            } else if (preBuilder != null && command.getBuilderName().equals(preBuilder)) {
                hasPreBuilder = true;
                hasPostBuilder = false;
            }
            ++n2;
        }
        ICommand builderCmd = desc.newCommand();
        builderCmd.setBuilderName(builderToAdd);
        ICommand[] newCommands = new ICommand[commands.length + 1];
        if (!hasPostBuilder && !hasPreBuilder) {
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = builderCmd;
        } else {
            int i = 0;
            ICommand[] iCommandArray2 = commands;
            int n3 = commands.length;
            int n4 = 0;
            while (n4 < n3) {
                ICommand command = iCommandArray2[n4];
                if (hasPostBuilder) {
                    if (command.getBuilderName().equals(postBuilder)) {
                        newCommands[i++] = builderCmd;
                        addedBuilder = true;
                    }
                    newCommands[i++] = command;
                } else {
                    newCommands[i++] = command;
                    if (command.getBuilderName().equals(preBuilder)) {
                        newCommands[i++] = builderCmd;
                        addedBuilder = true;
                    }
                }
                ++n4;
            }
        }
        desc.setBuildSpec(newCommands);
        project.setDescription(desc, null);
        return addedBuilder;
    }

    public static void removeFromBuildSpec(IProject project, String builderId) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        boolean hasBuilder = false;
        ICommand[] iCommandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (command.getBuilderName().equals(builderId)) {
                hasBuilder = true;
                break;
            }
            ++n2;
        }
        if (hasBuilder) {
            ICommand[] newCommands = new ICommand[commands.length - 1];
            int i = 0;
            ICommand[] iCommandArray2 = commands;
            int n3 = commands.length;
            int n4 = 0;
            while (n4 < n3) {
                ICommand command = iCommandArray2[n4];
                if (!command.getBuilderName().equals(builderId)) {
                    newCommands[i++] = command;
                }
                ++n4;
            }
            desc.setBuildSpec(newCommands);
            project.setDescription(desc, null);
        }
    }

    public static void replaceBuilder(IProject project, String oldBuilderId, String newBuilderId) throws CoreException {
        IProjectDescription pdesc = project.getDescription();
        ICommand[] oldBuildSpec = pdesc.getBuildSpec();
        ArrayList<ICommand> newBuildSpec = new ArrayList<ICommand>();
        int oldBuilderIndex = -1;
        boolean hasNewBuilder = false;
        int i = 0;
        while (i < oldBuildSpec.length) {
            ICommand command = oldBuildSpec[i];
            if (command.getBuilderName().equals(oldBuilderId)) {
                oldBuilderIndex = i;
            } else {
                if (command.getBuilderName().equals(newBuilderId)) {
                    hasNewBuilder = true;
                }
                newBuildSpec.add(command);
            }
            ++i;
        }
        if (oldBuilderIndex >= 0) {
            if (!hasNewBuilder) {
                ICommand builderCmd = pdesc.newCommand();
                builderCmd.setBuilderName(newBuilderId);
                newBuildSpec.add(oldBuilderIndex, builderCmd);
            }
            pdesc.setBuildSpec(newBuildSpec.toArray(new ICommand[newBuildSpec.size()]));
            project.setDescription(pdesc, null);
        }
    }

    public static class BuildPathInfo {
        IPath _newPath;
        IPath _oldPath;
        final IPath _outputPath;
        final boolean _exported;
        final int _kind;

        public BuildPathInfo(IPath newPath, IPath oldPath, int kind) {
            this(newPath, oldPath, kind, false);
        }

        public BuildPathInfo(IPath newPath, IPath oldPath, int kind, boolean exported) {
            this(newPath, oldPath, kind, null, exported);
        }

        public BuildPathInfo(IPath newPath, IPath oldPath, int kind, IPath outputPath) {
            this(newPath, oldPath, kind, outputPath, false);
        }

        private BuildPathInfo(IPath newPath, IPath oldPath, int kind, IPath outputPath, boolean exported) {
            this._newPath = newPath;
            this._oldPath = oldPath;
            this._kind = kind;
            this._exported = exported;
            this._outputPath = outputPath;
        }
    }
}

