/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.builder;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.builder.BuilderEnabler;
import oracle.eclipse.tools.common.builder.BuilderPathPrefs;
import oracle.eclipse.tools.common.builder.BuilderUtils;
import oracle.eclipse.tools.common.builder.IBuilderPrefs;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public abstract class BuilderPathEnabler
extends BuilderEnabler {
    public static final BuilderUtils.BuildPathInfo[] EMPTY_BUILD_PATHS = new BuilderUtils.BuildPathInfo[0];

    protected abstract boolean beforeJavaBuilder();

    protected abstract BuilderUtils.BuildPathInfo[] getLibraryPaths(IProject var1, BuilderPathPrefs var2, BuilderPathPrefs var3);

    protected abstract BuilderUtils.BuildPathInfo[] getContainerPaths(IProject var1, BuilderPathPrefs var2, BuilderPathPrefs var3);

    protected abstract BuilderUtils.BuildPathInfo[] getSourcePaths(IProject var1, BuilderPathPrefs var2, BuilderPathPrefs var3);

    @Override
    public void updateBuilder(IProject project, IBuilderPrefs oldPrefs, IBuilderPrefs newPrefs, IProgressMonitor monitor) throws CoreException {
        super.updateBuilder(project, oldPrefs, newPrefs, monitor);
        if (oldPrefs == null) {
            oldPrefs = newPrefs;
        }
        this.augmentClasspath(project, (BuilderPathPrefs)oldPrefs, (BuilderPathPrefs)newPrefs, true);
    }

    @Override
    protected void addToBuildSpec(IProject project, IBuilderPrefs newPrefs) throws CoreException {
        boolean addedBuilder = false;
        addedBuilder = this.beforeJavaBuilder() ? BuilderUtils.augmentBuildSpec(project, this.getBuilderID(), "org.eclipse.jdt.core.javabuilder", null) : BuilderUtils.augmentBuildSpec(project, this.getBuilderID(), null, "org.eclipse.jdt.core.javabuilder");
        if (addedBuilder) {
            this.builderAdded(project, newPrefs);
        }
    }

    @Override
    protected void builderRemoved(IProject project, IBuilderPrefs prefs) throws CoreException {
        this.augmentClasspath(project, null, (BuilderPathPrefs)prefs, false);
    }

    protected void augmentClasspath(IProject project, BuilderPathPrefs oldPrefs, BuilderPathPrefs newPrefs, boolean addPaths) throws CoreException {
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            return;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return;
        }
        ArrayList<IClasspathEntry> classpath = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            classpath.add(entry);
            ++n2;
        }
        boolean modifiedClasspath = this.modifyClasspath(this.getLibraryPaths(project, newPrefs, oldPrefs), classpath, addPaths);
        modifiedClasspath |= this.modifyClasspath(this.getContainerPaths(project, newPrefs, oldPrefs), classpath, addPaths);
        if (modifiedClasspath |= this.modifyClasspath(this.getSourcePaths(project, newPrefs, oldPrefs), classpath, addPaths)) {
            javaProject.setRawClasspath(classpath.toArray(new IClasspathEntry[classpath.size()]), null);
        }
    }

    private boolean modifyClasspath(BuilderUtils.BuildPathInfo[] buildPaths, List<IClasspathEntry> classpath, boolean add) {
        boolean modifiedClasspath = false;
        BuilderUtils.BuildPathInfo[] buildPathInfoArray = buildPaths;
        int n = buildPaths.length;
        int n2 = 0;
        while (n2 < n) {
            BuilderUtils.BuildPathInfo path = buildPathInfoArray[n2];
            if (!add) {
                path._oldPath = path._newPath;
                path._newPath = null;
            }
            modifiedClasspath |= BuilderUtils.modifyEntry(classpath, path);
            ++n2;
        }
        return modifiedClasspath;
    }
}

