/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.builder;

import java.io.IOException;
import oracle.eclipse.tools.common.builder.BuilderPlugin;
import oracle.eclipse.tools.common.builder.IBuilderPrefs;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

public abstract class BuilderNodePrefs
implements IBuilderPrefs {
    protected final String fStorageId;
    protected final IScopeContext fScopeContext;
    protected final ScopedPreferenceStore fPrefsStore;
    protected IEclipsePreferences fPrefsNode;

    public BuilderNodePrefs(String storageId, IScopeContext scopeContext) {
        this.fStorageId = storageId;
        this.fScopeContext = scopeContext;
        this.fPrefsStore = new ScopedPreferenceStore(this.fScopeContext, this.fStorageId);
        this.fPrefsNode = scopeContext.getNode(storageId);
    }

    public BuilderNodePrefs(IProject project, String storageId) {
        this(storageId, (IScopeContext)new ProjectScope(project));
    }

    @Override
    public boolean save() {
        try {
            this.fPrefsStore.save();
        }
        catch (IOException ioe) {
            LoggingService.logException((Plugin)BuilderPlugin.getDefault(), (Throwable)ioe);
            return false;
        }
        return true;
    }

    public IEclipsePreferences getPrefsNode() {
        return this.fPrefsNode;
    }

    public IPreferenceStore getPrefsStore() {
        return this.fPrefsStore;
    }

    public void ensurePrefsNode() {
        try {
            if (!this.fPrefsNode.nodeExists("")) {
                this.fPrefsNode = this.fScopeContext.getNode(this.fStorageId);
            }
        }
        catch (BackingStoreException bse) {
            LoggingService.logException((Plugin)BuilderPlugin.getDefault(), (Throwable)bse);
        }
        catch (IllegalStateException ise) {
            LoggingService.logException((Plugin)BuilderPlugin.getDefault(), (Throwable)ise);
        }
    }
}

