/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.builder;

import oracle.eclipse.tools.common.builder.BuilderUtils;
import oracle.eclipse.tools.common.builder.IBuilderPrefs;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class BuilderEnabler {
    protected abstract String getBuilderID();

    protected abstract boolean createDirs(IProject var1, IBuilderPrefs var2) throws CoreException;

    protected abstract void builderRemoved(IProject var1, IBuilderPrefs var2) throws CoreException;

    protected abstract void builderAdded(IProject var1, IBuilderPrefs var2) throws CoreException;

    public abstract void cleanOldData(IBuilderPrefs var1, IProgressMonitor var2) throws CoreException;

    public void addBuilder(IProject project, IBuilderPrefs newPrefs, IProgressMonitor monitor) throws CoreException {
        this.updateBuilder(project, null, newPrefs, monitor);
    }

    public void updateBuilder(IProject project, IBuilderPrefs oldPrefs, IBuilderPrefs newPrefs, IProgressMonitor monitor) throws CoreException {
        this.createDirs(project, newPrefs);
        this.addToBuildSpec(project, newPrefs);
        if (monitor != null) {
            monitor.worked(1);
        }
    }

    protected void addToBuildSpec(IProject project, IBuilderPrefs newPrefs) throws CoreException {
        boolean addedBuilder = false;
        addedBuilder = BuilderUtils.augmentBuildSpec(project, this.getBuilderID(), null, null);
        if (addedBuilder) {
            this.builderAdded(project, newPrefs);
        }
    }

    public void removeBuilder(IProject project, IBuilderPrefs prefs, IProgressMonitor monitor) throws CoreException {
        project.build(15, this.getBuilderID(), null, monitor);
        BuilderUtils.removeFromBuildSpec(project, this.getBuilderID());
        this.builderRemoved(project, prefs);
    }
}

