/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.builder;

import java.util.Map;
import oracle.eclipse.tools.common.builder.IBuilderPrefs;
import oracle.eclipse.tools.common.builder.IBuilderState;
import oracle.eclipse.tools.common.builder.ICleaner;
import oracle.eclipse.tools.common.builder.IFullBuilder;
import oracle.eclipse.tools.common.builder.IIncrementalBuilder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_PROBLEM = "oracle.eclipse.tools.common.builder.problem";
    private IBuilderPrefs prefs;
    private IBuilderState state;
    private ICleaner cleaner;
    private IFullBuilder fullBuilder;
    private IIncrementalBuilder incrementalBuilder;

    protected abstract IBuilderPrefs createBuilderPrefs() throws BuilderInitException;

    protected abstract IBuilderState createBuilderState() throws BuilderInitException;

    protected abstract ICleaner createCleaner() throws BuilderInitException;

    protected abstract IIncrementalBuilder createIncrementalBuilder() throws BuilderInitException;

    protected abstract IFullBuilder createFullBuilder() throws BuilderInitException;

    protected boolean isAccessible(IProject project) {
        if (!this.checkHelpers()) {
            return false;
        }
        return project != null && project.isAccessible();
    }

    protected boolean checkHelpers() {
        return this.getFullBuilder() != null && this.getIncrementalBuilder() != null && this.getCleaner() != null && this.getState() != null && this.getPrefs() != null;
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
        this.getPrefs();
        this.getState();
        this.getFullBuilder();
        this.getIncrementalBuilder();
        this.getCleaner();
    }

    public void clearHelpers() {
        this.prefs = null;
        this.state = null;
        this.fullBuilder = null;
        this.incrementalBuilder = null;
        this.cleaner = null;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (!this.isAccessible(this.getProject())) {
            return this.getDependentProjects();
        }
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return this.getDependentProjects();
    }

    protected IProject[] getDependentProjects() {
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        ICleaner c = this.getCleaner();
        if (c != null && this.isAccessible(this.getProject())) {
            monitor.beginTask(c.getBeginResource(), c.getProgressSize());
            c.clean(monitor);
            monitor.done();
        }
    }

    public void fullBuild(IProgressMonitor monitor) throws CoreException {
        IFullBuilder fb = this.getFullBuilder();
        if (monitor != null) {
            monitor.beginTask(fb.getBeginResource(), fb.getProgressSize());
        }
        try {
            fb.preTraversal(monitor);
            this.getProject().accept((IResourceVisitor)fb);
            fb.postTraversal();
        }
        catch (CoreException ce) {
            this.forgetLastBuiltState();
            throw ce;
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    public void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        IIncrementalBuilder ib = this.getIncrementalBuilder();
        if (monitor != null) {
            monitor.beginTask(ib.getBeginResource(), ib.getProgressSize());
        }
        ib.preTraversal(monitor);
        delta.accept((IResourceDeltaVisitor)ib);
        ib.postTraversal();
        if (monitor != null) {
            monitor.done();
        }
    }

    public IBuilderState getState() {
        if (this.state == null) {
            this.state = this.createBuilderState();
        }
        return this.state;
    }

    public IBuilderPrefs getPrefs() {
        if (this.prefs == null) {
            this.prefs = this.createBuilderPrefs();
        }
        return this.prefs;
    }

    protected IFullBuilder getFullBuilder() {
        if (this.fullBuilder == null) {
            this.fullBuilder = this.createFullBuilder();
        }
        return this.fullBuilder;
    }

    protected IIncrementalBuilder getIncrementalBuilder() {
        if (this.incrementalBuilder == null) {
            this.incrementalBuilder = this.createIncrementalBuilder();
        }
        return this.incrementalBuilder;
    }

    protected ICleaner getCleaner() {
        if (this.cleaner == null) {
            this.cleaner = this.createCleaner();
        }
        return this.cleaner;
    }

    public static final class BuilderInitException
    extends RuntimeException {
        public static final long serialVersionUID = 1L;

        public BuilderInitException() {
        }

        public BuilderInitException(String msg) {
            super(msg);
        }

        public BuilderInitException(String msg, Throwable cause) {
            super(msg, cause);
        }

        public BuilderInitException(Throwable cause) {
            super(cause);
        }
    }
}

