/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.utils;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oracle.eclipse.tools.glassfish.GlassfishGenericServer;
import oracle.eclipse.tools.glassfish.GlassfishToolsPlugin;
import oracle.eclipse.tools.glassfish.LastTaskEventListener;
import oracle.eclipse.tools.glassfish.ServerStatus;
import org.glassfish.tools.ide.admin.Command;
import org.glassfish.tools.ide.admin.CommandLocation;
import org.glassfish.tools.ide.admin.ResultMap;
import org.glassfish.tools.ide.admin.ServerAdmin;
import org.glassfish.tools.ide.admin.TaskEvent;
import org.glassfish.tools.ide.admin.TaskStateListener;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.utils.ServerUtils;

public class ServerStatusHelper {
    /*
     * Loose catch block
     */
    public static ServerStatus checkServerStatus(GlassfishGenericServer server) {
        Future locationTask;
        ResultMap result;
        LastTaskEventListener listener;
        block28: {
            block30: {
                try {
                    Thread.sleep(Math.round(Math.random() * 1000.0));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return ServerStatus.NOT_DEFINED;
                }
                if (!ServerUtils.isDASRunning((GlassFishServer)server)) {
                    return ServerStatus.STOPPED_NOT_LISTENING;
                }
                CommandLocation command = new CommandLocation();
                listener = new LastTaskEventListener();
                result = null;
                locationTask = null;
                try {
                    locationTask = ServerAdmin.exec((GlassFishServer)server, (Command)command, null, (TaskStateListener[])new TaskStateListener[]{listener});
                    result = (ResultMap)locationTask.get(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location interrupted");
                    if (result == null) {
                        if (locationTask != null) {
                            locationTask.cancel(true);
                        }
                        return ServerStatus.NOT_DEFINED;
                    }
                    break block28;
                }
                catch (ExecutionException e) {
                    GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location throws exception");
                    e.printStackTrace();
                }
                catch (TimeoutException timeoutException) {
                    block29: {
                        GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location timed out");
                        if (result != null) break block28;
                        if (locationTask == null) break block29;
                        locationTask.cancel(true);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    return ServerStatus.NOT_DEFINED;
                }
                {
                    finally {
                        if (result == null) {
                            if (locationTask != null) {
                                locationTask.cancel(true);
                            }
                            return ServerStatus.NOT_DEFINED;
                        }
                        break block28;
                    }
                }
                if (result != null) break block28;
                if (locationTask == null) break block30;
                locationTask.cancel(true);
            }
            return ServerStatus.NOT_DEFINED;
        }
        Enum s = null;
        switch (result.getState()) {
            case COMPLETED: {
                try {
                    if (ServerStatusHelper.domainMatching(server, result.getValue())) {
                        s = ServerStatus.RUNNING_DOMAIN_MATCHING;
                        break;
                    }
                    s = ServerStatus.STOPPED_DOMAIN_NOT_MATCHING;
                }
                catch (IOException iOException) {}
                break;
            }
            case FAILED: {
                if (ServerStatusHelper.isAuthException(listener.getLastEvent(), (ResultMap<String, String>)result)) {
                    s = ServerStatus.RUNNING_CREDENTIAL_PROBLEM;
                    break;
                }
                if (ServerStatusHelper.isRemoteAdminException((ResultMap<String, String>)result)) {
                    s = ServerStatus.RUNNING_REMOTE_NOT_SECURE;
                    break;
                }
                if (listener.getLastEvent().equals((Object)TaskEvent.BAD_GATEWAY)) {
                    s = ServerStatus.RUNNING_PROXY_ERROR;
                    break;
                }
                s = ServerStatus.RUNNING_CONNECTION_ERROR;
                break;
            }
            case RUNNING: {
                GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location takes long time...");
                locationTask.cancel(true);
                s = ServerStatus.NOT_DEFINED;
                break;
            }
            default: {
                GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location in ready state");
                s = ServerStatus.NOT_DEFINED;
            }
        }
        if (!s.equals((Object)ServerStatus.RUNNING_DOMAIN_MATCHING)) {
            ServerStatusHelper.logLocationResult((ResultMap<String, String>)result);
        }
        return s;
    }

    private static boolean domainMatching(GlassfishGenericServer server, Map<String, String> locationResult) throws IOException {
        if (server.isRemote()) {
            return true;
        }
        String expectedDomainRoot = String.valueOf(server.getDomainsFolder()) + File.separator + server.getDomainName();
        String actualDomainRoot = locationResult.get("Domain-Root_value");
        if (expectedDomainRoot != null && actualDomainRoot != null) {
            File expected = new File(expectedDomainRoot);
            File actual = new File(actualDomainRoot);
            if (expected.getCanonicalPath().equals(actual.getCanonicalPath())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isAuthException(TaskEvent event, ResultMap<String, String> result) {
        return event.equals((Object)TaskEvent.LOCAL_AUTH_FAILED) || event.equals((Object)TaskEvent.REMOTE_AUTH_FAILED) || result.getValue() != null && result.getValue().get("message") != null && ((String)result.getValue().get("message")).contains("javax.security.auth.login.LoginException");
    }

    private static boolean isRemoteAdminException(ResultMap<String, String> result) {
        return result.getValue() != null && result.getValue().get("message") != null && ((String)result.getValue().get("message")).contains("org.glassfish.internal.api.RemoteAdminAccessException");
    }

    private static void logLocationResult(ResultMap<String, String> res) {
        GlassfishToolsPlugin.logMessage("Location command result state: " + res.getState());
        if (res.getValue() != null) {
            for (String key : res.getValue().keySet()) {
                GlassfishToolsPlugin.logMessage(String.valueOf(key) + ": " + (String)res.getValue().get(key));
            }
        }
    }
}

