/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.log;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class V3LogFilter {
    private final Locale logLocale = this.getLogLocale();
    private final String logBundleName = this.getLogBundle();
    private final Map<String, String> localizedLevels = this.getLevelMap();

    private Locale getLogLocale() {
        String language = System.getProperty("user.language");
        if (language != null) {
            return new Locale(language, System.getProperty("user.country", ""), System.getProperty("user.variant", ""));
        }
        return Locale.getDefault();
    }

    private String getLogBundle() {
        return Level.INFO.getResourceBundleName();
    }

    private String getLocalized(String text) {
        ResourceBundle bundle = ResourceBundle.getBundle(this.logBundleName, this.logLocale);
        String localized = bundle.getString(text);
        return localized != null ? localized : text;
    }

    public Map<String, String> getLevelMap() {
        HashMap<String, String> levelMap = new HashMap<String, String>();
        Level[] levelArray = new Level[]{Level.ALL, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.INFO, Level.SEVERE, Level.WARNING};
        int n = levelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Level l = levelArray[n2];
            String name = l.getName();
            levelMap.put(name, this.getLocalized(name));
            ++n2;
        }
        return levelMap;
    }

    public String getLocalizedLevel(String level) {
        String localizedLevel = this.localizedLevels.get(level);
        return localizedLevel != null ? localizedLevel : level;
    }

    public static interface Filter {
        public String process(char var1);
    }

    public static final class LogFileFilter
    implements Filter {
        protected String message;
        protected int state = 0;
        protected StringBuilder msg = new StringBuilder(128);
        private String time;
        private String type;
        private String version;
        private String classinfo;
        private String threadinfo;
        private boolean multiline;
        private final Map<String, String> typeMap;

        public LogFileFilter(Map<String, String> typeMap) {
            this.typeMap = typeMap;
            this.reset();
        }

        protected void reset() {
            this.message = "";
            this.time = "";
            this.type = "";
            this.version = "";
            this.classinfo = "";
            this.threadinfo = "";
            this.multiline = false;
        }

        private String getLocalizedType(String type) {
            String localizedType = this.typeMap.get(type);
            return localizedType != null ? localizedType : type;
        }

        @Override
        public String process(char c) {
            String result = null;
            switch (this.state) {
                case 0: {
                    if (c == '[') {
                        this.state = 1;
                        break;
                    }
                    if (c == '\n') {
                        if (this.msg.length() <= 0) break;
                        this.msg.append(c);
                        result = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\r') break;
                    this.msg.append(c);
                    break;
                }
                case 1: {
                    if (c == '#') {
                        this.state = 2;
                        break;
                    }
                    this.state = 0;
                    if (c == '\n') {
                        if (this.msg.length() <= 0) break;
                        this.msg.append(c);
                        result = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\r') break;
                    this.msg.append('[');
                    this.msg.append(c);
                    break;
                }
                case 2: {
                    if (c == '|') {
                        this.state = 3;
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\n') {
                        if (this.msg.length() <= 0) break;
                        this.msg.append(c);
                        result = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\r') break;
                    this.state = 0;
                    this.msg.append('[');
                    this.msg.append('#');
                    this.msg.append(c);
                    break;
                }
                case 3: {
                    if (c == '|') {
                        this.state = 4;
                        this.time = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 4: {
                    if (c == '|') {
                        this.state = 5;
                        this.type = this.getLocalizedType(this.msg.toString());
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 5: {
                    if (c == '|') {
                        this.state = 6;
                        this.version = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 6: {
                    if (c == '|') {
                        this.state = 7;
                        this.classinfo = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 7: {
                    if (c == '|') {
                        this.state = 8;
                        this.threadinfo = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 8: {
                    if (c == '|') {
                        this.state = 9;
                        this.message = this.msg.toString();
                        break;
                    }
                    if (c == '\n') {
                        if (this.msg.length() <= 0) break;
                        this.msg.append('\n');
                        result = !this.multiline ? String.valueOf(this.type) + ": " + this.msg.toString() : this.msg.toString();
                        this.multiline = true;
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\r') break;
                    this.msg.append(c);
                    break;
                }
                case 9: {
                    if (c == '#') {
                        this.state = 10;
                        break;
                    }
                    this.state = 8;
                    this.msg.append('|');
                    this.msg.append(c);
                    break;
                }
                case 10: {
                    if (c == ']') {
                        this.state = 0;
                        this.msg.setLength(0);
                        result = String.valueOf(this.multiline ? this.message : String.valueOf(this.type) + ": " + this.message) + '\n';
                        this.reset();
                        break;
                    }
                    this.state = 8;
                    this.msg.append('|');
                    this.msg.append('#');
                    this.msg.append(c);
                }
            }
            return result;
        }
    }
}

