/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.log;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.glassfish.GlassfishToolsPlugin;
import oracle.eclipse.tools.glassfish.log.AbstractLogFilter;

public class PatternLogFilterV4
extends AbstractLogFilter {
    private static final Pattern logPattern = Pattern.compile("^\\[([^\\]]*)\\]\\s+\\[([^\\]]*)\\]\\s+\\[([^\\]]*)\\]\\s+\\[([^\\]]*)\\]\\s+\\[([^\\]]*)\\]\\s+\\[([^\\]]*)\\]\\s+\\[([^\\]]*)\\]\\s+\\[([^\\]]*)\\]\\s+\\[{2}\\s*(.+)\\]{2}\\s$", 32);
    private static final Pattern endOfMessagePattern = Pattern.compile("^//s*[^//]]{2}\\s$");

    PatternLogFilterV4() {
    }

    @Override
    public String process(String line) {
        String result = null;
        if (line.equals(this.logRecordDelimeter)) {
            Matcher m = logPattern.matcher(this.buffer);
            if (m.matches()) {
                this.record.setTime(m.group(1));
                this.record.setLevel(this.levelResolver.resolve(m.group(3)));
                this.record.setVersion(m.group(2));
                this.record.setClassInfo(m.group(5));
                this.record.setThreadInfo(m.group(6));
                this.record.setMessage(m.group(9));
                result = this.formatter.formatLogRecord(this.record);
                this.reset();
            } else if (!this.isReadingUserMessage()) {
                GlassfishToolsPlugin.logMessage("Log record that does not match expected format detected!");
                GlassfishToolsPlugin.logMessage(this.buffer.toString());
            }
        } else {
            this.buffer.append(line);
            this.buffer.append('\n');
        }
        return result;
    }

    @Override
    protected boolean isReadingUserMessage() {
        return !endOfMessagePattern.matcher(this.buffer).matches();
    }
}

