/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.log;

import oracle.eclipse.tools.glassfish.log.ILogFilter;
import oracle.eclipse.tools.glassfish.log.LevelResolver;
import oracle.eclipse.tools.glassfish.log.LogFormatterSimple;
import oracle.eclipse.tools.glassfish.log.LogRecord;
import oracle.eclipse.tools.glassfish.log.PatternLogFilterV4;
import oracle.eclipse.tools.glassfish.log.StateLogFilterV3;
import org.glassfish.tools.ide.data.GlassFishServer;

public abstract class AbstractLogFilter
implements ILogFilter {
    private static final String DEFAULT_DELIMETER = "";
    protected StringBuilder buffer = new StringBuilder(1024);
    protected String logRecordDelimeter = "";
    protected ILevelResolver levelResolver;
    protected LogRecord record = new LogRecord();
    protected ILogFormatter formatter;

    protected AbstractLogFilter() {
        this(new LogFormatterSimple(), new LevelResolver(), DEFAULT_DELIMETER);
    }

    protected AbstractLogFilter(ILogFormatter formatter, ILevelResolver resolver) {
        this(formatter, resolver, DEFAULT_DELIMETER);
    }

    protected AbstractLogFilter(ILogFormatter formatter, ILevelResolver resolver, String logRecordDelimeter) {
        this.formatter = formatter;
        this.levelResolver = resolver;
        this.logRecordDelimeter = logRecordDelimeter;
    }

    @Override
    public void reset() {
        this.record.reset();
        this.buffer.setLength(0);
    }

    protected abstract boolean isReadingUserMessage();

    @Override
    public abstract String process(String var1);

    public static AbstractLogFilter createFilter(GlassFishServer server) {
        switch (server.getVersion()) {
            case GF_3: 
            case GF_3_1: 
            case GF_3_1_1: 
            case GF_3_1_2: 
            case GF_3_1_2_2: {
                return new StateLogFilterV3();
            }
            case GF_4: {
                return new PatternLogFilterV4();
            }
        }
        throw new IllegalArgumentException();
    }

    public static enum GlassfishLogFields {
        DATETIME,
        LEVEL,
        VERSION,
        CLASSINFO,
        THREADINFO,
        MESSAGE;

    }

    public static interface ILevelResolver {
        public String resolve(String var1);
    }

    public static interface ILogFormatter {
        public String formatLogRecord(LogRecord var1);
    }
}

