/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import oracle.eclipse.tools.glassfish.internal.Library;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

@XmlRootElement(name="system-libraries")
public class SystemLibrariesSetting {
    static final String SETTING_XML = "/.settings/oracle.eclipse.tools.glassfish.syslib.xml";
    private ArrayList<Library> libraryList = new ArrayList();

    @XmlElement(name="library")
    public void setLibraryList(ArrayList<Library> libList) {
        this.libraryList = libList;
    }

    public ArrayList<Library> getLibraryList() {
        return this.libraryList;
    }

    public static SystemLibrariesSetting load(IProject proj) {
        SystemLibrariesSetting settings;
        JAXBContext context;
        IFile file;
        block10: {
            try {
                file = proj.getFile(SETTING_XML);
                context = JAXBContext.newInstance((Class[])new Class[]{SystemLibrariesSetting.class});
                settings = null;
                if (file.exists()) break block10;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        InputStream stream = file.getContents();
        try {
            settings = (SystemLibrariesSetting)context.createUnmarshaller().unmarshal(stream);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        ArrayList<Library> libsList = settings.getLibraryList();
        if (libsList == null) {
            libsList = new ArrayList();
            settings.setLibraryList(libsList);
        }
        return settings;
    }

    public static void save(IProject proj, SystemLibrariesSetting settings) {
        try {
            IFile file = proj.getFile(SETTING_XML);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SystemLibrariesSetting.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)settings, (OutputStream)System.out);
            m.marshal((Object)settings, file.getLocation().toFile());
            file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public File getSourcePath(File jar) {
        for (Library lib : this.libraryList) {
            if (!jar.equals(new File(lib.getPath()))) continue;
            File f = new File(lib.getSource());
            if (f.exists()) {
                return f;
            }
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(lib.getSource()));
            return file.getLocation().toFile();
        }
        return null;
    }
}

