/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.internal;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import oracle.eclipse.tools.glassfish.GlassfishGenericServer;
import oracle.eclipse.tools.glassfish.GlassfishGenericServerBehaviour;
import oracle.eclipse.tools.glassfish.ServerStatus;
import oracle.eclipse.tools.glassfish.internal.ServerStateListener;
import oracle.eclipse.tools.glassfish.utils.ServerStatusHelper;
import org.eclipse.wst.server.core.IServer;

public class ServerStatusMonitor
implements Runnable {
    private static final int DEFAULT_DELAY_IN_SEC = 5;
    private ScheduledExecutorService scheduler;
    private GlassfishGenericServer server;
    private int delay;
    private ScheduledFuture<?> scheduledTask;
    private ServerStatus status = ServerStatus.NOT_DEFINED;
    private CopyOnWriteArrayList<ServerStateListener> listeners = null;

    private ServerStatusMonitor(GlassfishGenericServer server) {
        this(server, 5, new ServerStateListener[0]);
    }

    private ServerStatusMonitor(GlassfishGenericServer server, ServerStateListener ... listeners) {
        this(server, 5, listeners);
    }

    private ServerStatusMonitor(GlassfishGenericServer server, int checkInterval, ServerStateListener ... listeners) {
        this.server = server;
        this.delay = checkInterval;
        this.listeners = new CopyOnWriteArrayList<ServerStateListener>(listeners);
    }

    public static ServerStatusMonitor getInstance(GlassfishGenericServer server) {
        return new ServerStatusMonitor(server);
    }

    public static ServerStatusMonitor getInstance(GlassfishGenericServer server, ServerStateListener ... listeners) {
        return new ServerStatusMonitor(server, listeners);
    }

    public static ServerStatusMonitor getInstance(GlassfishGenericServer server, int checkInterval) {
        return new ServerStatusMonitor(server, checkInterval, new ServerStateListener[0]);
    }

    public void start() {
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduledTask = this.scheduler.scheduleWithFixedDelay(this, 0L, this.delay, TimeUnit.SECONDS);
    }

    public void stop() {
        this.scheduledTask.cancel(true);
        this.scheduler.shutdown();
    }

    @Override
    public void run() {
        IServer server1 = this.server.getServer();
        if (this.server.isRemote()) {
            String remoteServerVersion = GlassfishGenericServerBehaviour.getVersion(this.server);
            String thisServerVersion = server1.getRuntime().getRuntimeType().getVersion();
            int n = thisServerVersion.indexOf(".X");
            if (n > 0) {
                thisServerVersion = thisServerVersion.substring(0, n + 1);
            }
            if (remoteServerVersion != null && remoteServerVersion.indexOf(thisServerVersion) < 0) {
                this.status = ServerStatus.STOPPED_DOMAIN_NOT_MATCHING;
                this.notifyListeners(this.status);
                return;
            }
        }
        this.status = ServerStatusHelper.checkServerStatus(this.server);
        this.notifyListeners(this.status);
    }

    public ServerStatus getServerStatus(boolean forceUpdate) {
        if (forceUpdate) {
            Future<?> f = this.scheduler.submit(this);
            try {
                f.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {}
        }
        return this.status;
    }

    public ServerStatus getServerStatus() {
        return this.getServerStatus(false);
    }

    private void notifyListeners(ServerStatus newStatus) {
        for (ServerStateListener listener : this.listeners) {
            listener.serverStatusChanged(newStatus);
        }
    }

    public void registerServerStatusListener(ServerStateListener listener) {
        this.listeners.add(listener);
    }
}

