/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.installation;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.glassfish.GlassfishGenericServer;
import oracle.eclipse.tools.glassfish.GlassfishToolsPlugin;
import oracle.eclipse.tools.glassfish.installation.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public class V3Configurator {
    private String serverID;
    private String serverRootDirName;
    private File serverLocation;

    public V3Configurator(File serverLocation, String serverID, String serverRootDirName) {
        this.serverID = serverID;
        this.serverLocation = serverLocation;
        this.serverRootDirName = serverRootDirName;
    }

    public String configure() throws CoreException {
        IServer[] servers;
        String glassfishLocation = this.getGlassfishLocation();
        String domainXml = null;
        IServerType st = ServerCore.findServerType((String)this.serverID);
        IRuntime runtime = this.createRuntime(glassfishLocation);
        IServer[] iServerArray = servers = ServerCore.getServers();
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (server.getRuntime() == null) {
                server.delete();
            }
            if (runtime != null && server != null && runtime.equals(server.getRuntime())) {
                GlassfishToolsPlugin.logMessage("found an existing server at " + runtime.getLocation().toOSString());
                return null;
            }
            ++n2;
        }
        IServerWorkingCopy wc = st.createServer(null, null, runtime, null);
        wc.setName(MessageFormat.format(Messages.Bundled, runtime.getName()));
        GlassfishGenericServer sunAppServer = (GlassfishGenericServer)((Object)wc.getAdapter(GlassfishGenericServer.class));
        domainXml = String.valueOf(this.serverLocation.getAbsolutePath()) + "/glassfish/domains/domain1/config/domain.xml";
        GlassfishToolsPlugin.logMessage("domain.xml location is = " + domainXml);
        Map<String, String> configuration = sunAppServer.getProps();
        configuration.put("sunappserver.domainpath", String.valueOf(this.serverLocation.getAbsolutePath()) + "/glassfish/domains/domain1");
        sunAppServer.setServerInstanceProperties(configuration);
        wc.save(true, null);
        return domainXml;
    }

    private String getGlassfishLocation() {
        String glassfishLocation = null;
        try {
            glassfishLocation = String.valueOf(new Path(Platform.getInstallLocation().getURL().getFile()).toPortableString()) + this.serverRootDirName + "/glassfish";
            return glassfishLocation;
        }
        catch (Exception exception) {
            return glassfishLocation;
        }
    }

    private IRuntime createRuntime(String glassfishLocation) {
        try {
            IRuntime[] runtimes;
            IServerType st = ServerCore.findServerType((String)this.serverID);
            IRuntime[] iRuntimeArray = runtimes = ServerCore.getRuntimes();
            int n = runtimes.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntime runtime = iRuntimeArray[n2];
                if (runtime != null && runtime.getRuntimeType().equals(st.getRuntimeType())) {
                    return runtime;
                }
                ++n2;
            }
            IRuntimeWorkingCopy wc = st.getRuntimeType().createRuntime(null, null);
            GenericServerRuntime gRun = (GenericServerRuntime)wc.loadAdapter(GenericServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("sunappserver.rootdirectory", glassfishLocation);
            gRun.setServerDefinitionId(gRun.getRuntime().getRuntimeType().getId());
            gRun.setServerInstanceProperties(map);
            wc.setLocation((IPath)new Path(glassfishLocation));
            return wc.save(true, null);
        }
        catch (CoreException coreException) {
            return null;
        }
    }
}

