/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.handlers;

import java.io.File;
import oracle.eclipse.tools.glassfish.GlassfishGenericServer;
import oracle.eclipse.tools.glassfish.handlers.AbstractGlassfishSelectionHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.server.core.IServer;

public class UpdateCenterHandler
extends AbstractGlassfishSelectionHandler {
    @Override
    public void processSelection(IStructuredSelection selection) {
        File tool;
        IServer server = (IServer)selection.getFirstElement();
        GlassfishGenericServer serverAdapter = (GlassfishGenericServer)((Object)server.loadAdapter(GlassfishGenericServer.class, null));
        File installRoot = new File(serverAdapter.getServerInstallationDirectory()).getParentFile();
        if (!this.isUCInstalled(installRoot)) {
            this.showMessageDialog("GlassFish Update Tool is not yet installed. Please read the Eclipse console output and there, type 'y' to start the installation...");
        }
        if ((tool = this.getV3UpdateCenterLauncher(installRoot)) == null) {
            this.showMessageDialog("Selected Glassfish server installation does not contain update center launcher.");
            return;
        }
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType programType = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
            ILaunchConfigurationWorkingCopy cfg = programType.newInstance(null, "updatecentertool");
            ILaunchConfigurationWorkingCopy wc = cfg.getWorkingCopy();
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", tool.getAbsolutePath());
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", installRoot.getAbsolutePath());
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", "");
            cfg = wc.doSave();
            DebugUITools.launch((ILaunchConfiguration)cfg, (String)"run");
            cfg.delete();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private boolean isUCInstalled(File installRoot) {
        return new File(installRoot, "updatetool/bin").exists();
    }

    private File getV3UpdateCenterLauncher(File installRoot) {
        File updateCenterBin;
        File result = null;
        if (installRoot != null && installRoot.exists() && (updateCenterBin = new File(installRoot, "bin")).exists()) {
            if (File.separator.equals("\\")) {
                File launcherPath = new File(updateCenterBin, "updatetool.exe");
                result = launcherPath.exists() ? launcherPath : ((launcherPath = new File(updateCenterBin, "updatetool.bat")).exists() ? launcherPath : null);
            } else {
                File launcherPath = new File(updateCenterBin, "updatetool");
                File file = result = launcherPath.exists() ? launcherPath : null;
                if (result != null) {
                    result.setExecutable(true);
                }
            }
        }
        return result;
    }
}

