/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.derby;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import oracle.eclipse.tools.glassfish.GlassfishToolsPlugin;
import oracle.eclipse.tools.glassfish.derby.Messages;
import org.apache.tools.ant.listener.TimestampedLogger;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DerbyConfigurator {
    private static final String DERBY_PROVIDER_ID = "org.eclipse.datatools.connectivity.db.derby.embedded.connectionProfile";
    private static final String DERBY_TEMPLATE_ID = "org.eclipse.datatools.connectivity.db.derby102.clientDriver";
    private static final String DERBY_FOR_SAMPLE_DB = "GlassFishSampleDB";
    public static final String DERBY_SAMPLE_INSTALL = "derby_sample_dir";
    public static final String DERBY_SAMPLE_ID = "glassfish.javadb";

    public static void configure(IProgressMonitor progressMonitor, File serverDirectory, String domainXml) throws CoreException {
        DriverManager dm = DriverManager.getInstance();
        DriverInstance sample = dm.getDriverInstanceByName(DERBY_FOR_SAMPLE_DB);
        if (sample == null) {
            Properties properties = new Properties();
            DerbyConfigurator.readProperties(serverDirectory, domainXml, properties);
            String profileName = Messages.SAMPLE_JAVADB_DATABASE;
            String description = Messages.SAMPLE_JAVADB_DATABASE_DESCRIPTION;
            DriverInstance di = dm.createNewDriverInstance(DERBY_TEMPLATE_ID, DERBY_FOR_SAMPLE_DB, DerbyConfigurator.getDerbyClientJarLocation(serverDirectory));
            properties.setProperty("org.eclipse.datatools.connectivity.driverDefinitionID", di.getId());
            try {
                ProfileManager.getInstance().createProfile(profileName, description, DERBY_PROVIDER_ID, properties);
            }
            catch (ConnectionProfileException e) {
                GlassfishToolsPlugin.logMessage("Error Creating Database Profile", (Exception)((Object)e));
            }
        }
        DerbyConfigurator.configureSample(progressMonitor);
    }

    private static void readProperties(File serverDirectory, String domainXml, Properties properties) {
        String db = "";
        String pass = "";
        String user = "";
        int port = -1;
        String server = "";
        String conAttrib = "";
        try {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(true);
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document doc = builder.parse(new File(domainXml));
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expr = xpath.compile("//jdbc-connection-pool[@datasource-classname='org.apache.derby.jdbc.ClientDataSource']/property");
            NodeList nl = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            int i = 0;
            while (i < nl.getLength()) {
                Node node = nl.item(i);
                if (node.getAttributes().getNamedItem("name").getNodeValue().equals("PortNumber")) {
                    port = Integer.parseInt(node.getAttributes().getNamedItem("value").getNodeValue());
                } else if (node.getAttributes().getNamedItem("name").getNodeValue().equals("Password")) {
                    pass = node.getAttributes().getNamedItem("value").getNodeValue();
                } else if (node.getAttributes().getNamedItem("name").getNodeValue().equals("User")) {
                    user = node.getAttributes().getNamedItem("value").getNodeValue();
                } else if (node.getAttributes().getNamedItem("name").getNodeValue().equals("serverName")) {
                    server = node.getAttributes().getNamedItem("value").getNodeValue();
                } else if (node.getAttributes().getNamedItem("name").getNodeValue().equals("DatabaseName")) {
                    db = node.getAttributes().getNamedItem("value").getNodeValue();
                } else if (node.getAttributes().getNamedItem("name").getNodeValue().equals("connectionAttributes")) {
                    conAttrib = node.getAttributes().getNamedItem("value").getNodeValue();
                }
                ++i;
            }
        }
        catch (Exception e) {
            GlassfishToolsPlugin.logMessage("Error Reading DB data", e);
        }
        properties.setProperty("org.eclipse.datatools.connectivity.db.connectionProperties", "");
        properties.setProperty("org.eclipse.datatools.connectivity.db.savePWD", "true");
        properties.setProperty("org.eclipse.datatools.connectivity.drivers.defnType", DERBY_TEMPLATE_ID);
        properties.setProperty("jarList", DerbyConfigurator.getDerbyClientJarLocation(serverDirectory));
        properties.setProperty("org.eclipse.datatools.connectivity.db.username", user);
        properties.setProperty("org.eclipse.datatools.connectivity.db.driverClass", "org.apache.derby.jdbc.ClientDriver");
        properties.setProperty("org.eclipse.datatools.connectivity.driverDefinitionID", "DriverDefn.org.eclipse.datatools.connectivity.db.derby102.clientDriver.Derby Client JDBC Driver");
        properties.setProperty("org.eclipse.datatools.connectivity.db.databaseName", db);
        properties.setProperty("org.eclipse.datatools.connectivity.db.password", pass);
        properties.setProperty("org.eclipse.datatools.connectivity.db.URL", "jdbc:derby://" + server + ":" + port + "/" + db + conAttrib);
        properties.setProperty("org.eclipse.datatools.connectivity.db.version", "10.2");
        properties.setProperty("org.eclipse.datatools.connectivity.db.vendor", "Derby");
    }

    private static String getDerbyClientJarLocation(File glassfishLocation) {
        String derbyLocation = String.valueOf(new File(glassfishLocation.getAbsolutePath()).getParentFile().getAbsolutePath()) + "/javadb/lib/derbyclient.jar";
        return derbyLocation;
    }

    public static String getSampleDBLocation() {
        return Platform.getLocation().append(".metadata").append(".plugins").append(DERBY_SAMPLE_ID).toOSString();
    }

    public static String configureSample(IProgressMonitor progressMonitor) throws CoreException {
        String databaseLocation = DerbyConfigurator.getSampleDBLocation();
        File dbDirectory = new File(databaseLocation);
        if (new File(dbDirectory, "sun-appserv-samples").exists()) {
            return databaseLocation;
        }
        AntRunner ant = new AntRunner();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DERBY_SAMPLE_INSTALL, databaseLocation);
        try {
            Bundle bundle = Platform.getBundle((String)"oracle.eclipse.tools.glassfish");
            URL xml = bundle.getResource("derbysetup/unzipSampleDB.xml");
            String antFile = FileLocator.toFileURL((URL)xml).getFile();
            URL dbURL = bundle.getResource("derbysetup/derbysampledb.zip");
            FileLocator.toFileURL((URL)dbURL).getFile();
            ant.setBuildFileLocation(antFile);
            ant.addUserProperties(map);
            ant.setArguments("-Dmessage=Building -verbose");
            ant.addBuildLogger(TimestampedLogger.class.getName());
            ant.run();
            return databaseLocation;
        }
        catch (Exception e) {
            GlassfishToolsPlugin.logMessage("error creating java DB database", e);
            return null;
        }
    }
}

