/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.glassfish.GlassfishGenericServer;
import oracle.eclipse.tools.glassfish.GlassfishToolsPlugin;
import oracle.eclipse.tools.glassfish.Messages;
import oracle.eclipse.tools.glassfish.exceptions.UniqueNameNotFound;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public class RuntimeConfigurator {
    private String serverID;
    private String runtimeName;
    private File serverLocation;
    private String domainName;

    public RuntimeConfigurator(File serverLocation, String serverID, String runtimeName, String domainName) {
        this.serverID = serverID;
        this.serverLocation = serverLocation;
        this.runtimeName = runtimeName;
        this.domainName = domainName;
    }

    public void configure() throws CoreException {
        IServer[] servers;
        IRuntime runtime;
        File glassfishLocation = new File(this.serverLocation, "glassfish");
        IRuntime alreadyThere = this.getRuntimeByLocation(glassfishLocation);
        if (alreadyThere != null) {
            GlassfishToolsPlugin.logMessage("Already Registered: " + glassfishLocation, null);
            return;
        }
        GlassfishToolsPlugin.logMessage("Not  Registered yet : " + glassfishLocation.getAbsolutePath(), null);
        IServerType st = ServerCore.findServerType((String)this.serverID);
        try {
            runtime = this.createRuntime(this.runtimeName, glassfishLocation.getAbsolutePath());
        }
        catch (UniqueNameNotFound e) {
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.glassfish", NLS.bind((String)Messages.uniqueNameNotFound, (Object)"Runtime"), (Throwable)e));
        }
        IServer[] iServerArray = servers = ServerCore.getServers();
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (server.getRuntime() == null) {
                server.delete();
            }
            if (runtime != null) {
                runtime.equals(server.getRuntime());
            }
            ++n2;
        }
        IServerWorkingCopy wc = st.createServer(null, null, runtime, null);
        try {
            wc.setName(this.createUniqueServerName(runtime.getName()));
        }
        catch (UniqueNameNotFound e) {
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.glassfish", NLS.bind((String)Messages.uniqueNameNotFound, (Object)"Server"), (Throwable)e));
        }
        GlassfishGenericServer sunAppServer = (GlassfishGenericServer)((Object)wc.getAdapter(GlassfishGenericServer.class));
        String expectedDomainLocation = this.getDomainLocation();
        File dom = new File(expectedDomainLocation);
        if (!dom.exists()) {
            this.copyDirectory(new File(this.serverLocation, "/glassfish/domains/domain1"), new File(expectedDomainLocation));
        } else {
            RuntimeConfigurator.deleteOSGICacheDirectory(new File(dom, "osgi-cache"));
        }
        Map<String, String> configuration = sunAppServer.getProps();
        configuration.put("sunappserver.domainpath", expectedDomainLocation);
        configuration.put("sunappserver.useAnonymousConnection", "true");
        sunAppServer.setServerInstanceProperties(configuration);
        sunAppServer.setDefaultPublishState();
        wc.save(true, null);
    }

    private String getDomainLocation() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IPath location = root.getLocation();
        return location + File.separator + this.domainName;
    }

    private IRuntime getRuntimeByLocation(File glassfishLocation) {
        IServerType st = ServerCore.findServerType((String)this.serverID);
        IRuntime[] runtimes = ServerCore.getRuntimes();
        ServerCore.getRuntimeTypes();
        ServerCore.getServers();
        IRuntime[] iRuntimeArray = runtimes;
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            File currentlocation;
            IRuntime runtime = iRuntimeArray[n2];
            if (runtime != null && runtime.getRuntimeType().equals(st.getRuntimeType()) && (currentlocation = new File("" + runtime.getLocation())).equals(glassfishLocation)) {
                return runtime;
            }
            ++n2;
        }
        return null;
    }

    private static boolean deleteOSGICacheDirectory(File osgicache) {
        if (osgicache.exists()) {
            File[] files = osgicache.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    RuntimeConfigurator.deleteOSGICacheDirectory(files[i]);
                } else if (!files[i].delete()) {
                    return false;
                }
                ++i;
            }
        }
        return osgicache.delete();
    }

    private IRuntime createRuntime(String runtimeName, String glassfishLocation) throws UniqueNameNotFound {
        try {
            IServerType st = ServerCore.findServerType((String)this.serverID);
            GlassfishToolsPlugin.logMessage("before Creating working copy : ", null);
            IRuntimeWorkingCopy wc = st.getRuntimeType().createRuntime(null, null);
            wc.setName(this.createUniqueRuntimeName(runtimeName));
            GlassfishToolsPlugin.logMessage("Creating working copy : " + wc, null);
            GenericServerRuntime gRun = (GenericServerRuntime)wc.loadAdapter(GenericServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
            GlassfishToolsPlugin.logMessage("grun : " + gRun, null);
            HashMap<String, String> map = new HashMap<String, String>();
            GlassfishToolsPlugin.logMessage("Creating NEW : " + glassfishLocation, null);
            map.put("sunappserver.rootdirectory", glassfishLocation);
            gRun.setServerDefinitionId(gRun.getRuntime().getRuntimeType().getId());
            gRun.setServerInstanceProperties(map);
            wc.setLocation((IPath)new Path(glassfishLocation));
            GlassfishToolsPlugin.logMessage("pre saving new runtime : " + glassfishLocation, null);
            return wc.save(true, null);
        }
        catch (CoreException e) {
            GlassfishToolsPlugin.logMessage("core exception : " + glassfishLocation, (Exception)((Object)e));
            return null;
        }
    }

    private String createUniqueRuntimeName(String runtimeName) throws UniqueNameNotFound {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        HashSet<String> takenNames = new HashSet<String>(runtimes.length);
        IRuntime[] iRuntimeArray = runtimes;
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            takenNames.add(runtime.getName());
            ++n2;
        }
        return this.createUniqueName(runtimeName, takenNames);
    }

    private String createUniqueServerName(String serverName) throws UniqueNameNotFound {
        IServer[] servers = ServerCore.getServers();
        HashSet<String> takenNames = new HashSet<String>(servers.length);
        IServer[] iServerArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            takenNames.add(server.getName());
            ++n2;
        }
        return this.createUniqueName(serverName, takenNames);
    }

    private String createUniqueName(String candidadeName, Set<String> takenNames) throws UniqueNameNotFound {
        if (!takenNames.contains(candidadeName)) {
            return candidadeName;
        }
        int i = 2;
        while (i < Integer.MAX_VALUE) {
            String candidadeNameWithSuffix = String.valueOf(candidadeName) + " (" + i + ")";
            if (!takenNames.contains(candidadeNameWithSuffix)) {
                return candidadeNameWithSuffix;
            }
            ++i;
        }
        throw new UniqueNameNotFound();
    }

    private void copyDirectory(File sourceLocation, File targetLocation) {
        block28: {
            if (sourceLocation.isDirectory()) {
                boolean isCreated;
                if (!targetLocation.exists() && !(isCreated = targetLocation.mkdir())) {
                    GlassfishToolsPlugin.logMessage("Failed to create : " + targetLocation.getAbsolutePath());
                }
                String[] children = sourceLocation.list();
                int i = 0;
                while (i < children.length) {
                    this.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
                    ++i;
                }
            } else {
                FileInputStream in = null;
                OutputStream out = null;
                try {
                    try {
                        int len;
                        in = new FileInputStream(sourceLocation);
                        out = new FileOutputStream(targetLocation);
                        byte[] buf = new byte[10240];
                        while ((len = ((InputStream)in).read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            if (in != null) {
                                ((InputStream)in).close();
                            }
                        }
                        catch (IOException iOException2) {}
                        try {
                            if (out != null) {
                                out.close();
                            }
                            break block28;
                        }
                        catch (IOException iOException3) {}
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }
}

