/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ReadDomainInfo {
    String adminPort = "1";
    String serverPort = "2";
    private String domainScriptFilePath;

    public ReadDomainInfo(String domainDir, String domainName) {
        this.domainScriptFilePath = String.valueOf(domainDir) + File.separator + domainName + "/config/domain.xml";
        Document domainScriptDocument = this.loadDomainScriptFile();
        if (domainScriptDocument == null) {
            return;
        }
    }

    public String getAdminPort() {
        return this.adminPort;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    private Document loadDomainScriptFile() {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setValidating(false);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            dBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    StringReader reader = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    InputSource source = new InputSource(reader);
                    source.setPublicId(publicId);
                    source.setSystemId(systemId);
                    return source;
                }
            });
            return dBuilder.parse(new File(this.domainScriptFilePath));
        }
        catch (Exception exception) {
            System.err.println("DomainInfo: unable to parse domain config file " + this.domainScriptFilePath);
            return null;
        }
    }

    private boolean saveDomainScriptFile(Document domainScriptDocument) {
        boolean result;
        block19: {
            result = false;
            Writer domainScriptFileWriter = null;
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("method", "xml");
                DocumentType dt = domainScriptDocument.getDoctype();
                if (dt != null) {
                    transformer.setOutputProperty("doctype-public", dt.getPublicId());
                    transformer.setOutputProperty("doctype-system", dt.getSystemId());
                }
                transformer.setOutputProperty("omit-xml-declaration", "no");
                DOMSource domSource = new DOMSource(domainScriptDocument);
                domainScriptFileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.domainScriptFilePath), StandardCharsets.UTF_8);
                StreamResult streamResult = new StreamResult(domainScriptFileWriter);
                transformer.transform(domSource, streamResult);
                result = true;
            }
            catch (IOException iOException) {
                System.err.println("DomainInfo: cannot create output stream for domain config file " + this.domainScriptFilePath);
                result = false;
                try {
                    if (domainScriptFileWriter != null) {
                        domainScriptFileWriter.close();
                    }
                    break block19;
                }
                catch (IOException iOException2) {
                    System.err.println("DomainInfo: cannot close output stream for " + this.domainScriptFilePath);
                }
                break block19;
            }
            catch (Exception exception) {
                try {
                    System.err.println("DomainInfo: Unable to save domain config file " + this.domainScriptFilePath);
                    result = false;
                }
                catch (Throwable throwable) {
                    try {
                        if (domainScriptFileWriter != null) {
                            domainScriptFileWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        System.err.println("DomainInfo: cannot close output stream for " + this.domainScriptFilePath);
                    }
                    throw throwable;
                }
                try {
                    if (domainScriptFileWriter != null) {
                        domainScriptFileWriter.close();
                    }
                    break block19;
                }
                catch (IOException iOException) {
                    System.err.println("DomainInfo: cannot close output stream for " + this.domainScriptFilePath);
                }
                break block19;
            }
            try {
                if (domainScriptFileWriter != null) {
                    domainScriptFileWriter.close();
                }
            }
            catch (IOException iOException) {
                System.err.println("DomainInfo: cannot close output stream for " + this.domainScriptFilePath);
            }
        }
        return result;
    }

    public static boolean isUnix() {
        return File.separatorChar == '/';
    }

    public boolean addProfilerElements(String nativeLibraryPath, String[] jvmOptions) {
        Document domainDoc = this.loadDomainScriptFile();
        this.removeProfiler(domainDoc);
        if (nativeLibraryPath != null || jvmOptions != null) {
            NodeList javaConfigNodeList;
            Element profilerElement = domainDoc.createElement("profiler");
            profilerElement.setAttribute("enabled", "true");
            profilerElement.setAttribute("name", "TPTP");
            if (nativeLibraryPath != null) {
                profilerElement.setAttribute("native-library-path", nativeLibraryPath);
            }
            if (jvmOptions != null) {
                int i = 0;
                while (i < jvmOptions.length) {
                    Element jvmOptionsElement = domainDoc.createElement("jvm-options");
                    Text tt = domainDoc.createTextNode(this.formatJvmOption(jvmOptions[i]));
                    jvmOptionsElement.appendChild(tt);
                    profilerElement.appendChild(jvmOptionsElement);
                    ++i;
                }
            }
            if ((javaConfigNodeList = domainDoc.getElementsByTagName("java-config")) == null || javaConfigNodeList.getLength() == 0) {
                System.err.println("DomainInfo: cannot find 'java-config' section in domain config file " + this.domainScriptFilePath);
                return false;
            }
            Node javaConfigNode = javaConfigNodeList.item(0);
            if (javaConfigNode.getFirstChild() != null) {
                javaConfigNode.insertBefore(profilerElement, javaConfigNode.getFirstChild());
            } else {
                javaConfigNode.appendChild(profilerElement);
            }
        }
        return this.saveDomainScriptFile(domainDoc);
    }

    public boolean removeProfilerElements() {
        Document domainDoc = this.loadDomainScriptFile();
        boolean eleRemoved = this.removeProfiler(domainDoc);
        if (eleRemoved) {
            return this.saveDomainScriptFile(domainDoc);
        }
        return true;
    }

    private boolean removeProfiler(Document domainDoc) {
        NodeList profilerElementNodeList;
        if (domainDoc != null && (profilerElementNodeList = domainDoc.getElementsByTagName("profiler")) != null && profilerElementNodeList.getLength() > 0) {
            Vector<Node> nodes = new Vector<Node>();
            int i = 0;
            while (i < profilerElementNodeList.getLength()) {
                Node n = profilerElementNodeList.item(i);
                Node a = n.getAttributes().getNamedItem("name");
                if (a != null && a.getNodeValue().equals("TPTP")) {
                    nodes.add(n);
                }
                ++i;
            }
            i = 0;
            while (i < nodes.size()) {
                Node nd = (Node)nodes.get(i);
                nd.getParentNode().removeChild(nd);
                ++i;
            }
            return true;
        }
        return false;
    }

    private String formatJvmOption(String jvmOption) {
        if (jvmOption.indexOf("\"") != -1) {
            if (jvmOption.indexOf("\\\"") != -1 && jvmOption.indexOf("-agentpath") != -1) {
                String modifiedOption = jvmOption.replaceAll("\\\\\"", "#");
                modifiedOption = modifiedOption.replaceAll("\\\"", "");
                modifiedOption = modifiedOption.replaceAll("#", "\"");
                modifiedOption = "\"" + modifiedOption.replaceAll("\\\"", "\\\\\"") + "\"";
                return modifiedOption;
            }
            return jvmOption.replace('\"', ' ');
        }
        return jvmOption;
    }
}

