/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish;

import java.io.File;
import oracle.eclipse.tools.glassfish.GlassFishInstall;
import oracle.eclipse.tools.glassfish.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jst.server.generic.core.internal.GenericServerCoreMessages;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;

public class GlassfishServerRuntimeV3
extends GenericServerRuntime {
    public static final boolean IS_MACOSX = "macosx".equals(Platform.getOS());

    public IStatus validate() {
        AbstractVMInstall vm = (AbstractVMInstall)this.getVMInstall();
        if (vm == null) {
            return new Status(4, "org.eclipse.jst.server.generic.core", 0, GenericServerCoreMessages.errorJRE, null);
        }
        File jreDir = vm.getInstallLocation();
        if (!IS_MACOSX && !new File(jreDir, "lib/tools.jar").exists()) {
            return new Status(4, "org.eclipse.jst.server.generic.core", 0, Messages.requiresJDK, null);
        }
        String location = (String)this.getServerInstanceProperties().get("sunappserver.rootdirectory");
        GlassFishInstall gfInstall = GlassFishInstall.find(new File(location));
        if (gfInstall == null) {
            return new Status(4, "oracle.eclipse.tools.glassfish", Messages.runtimeNotValid);
        }
        if (!gfInstall.version().matches("[3.1-4)")) {
            return new Status(4, "oracle.eclipse.tools.glassfish", Messages.version31);
        }
        return new Status(0, "oracle.eclipse.tools.glassfish", "");
    }
}

