/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import oracle.eclipse.tools.glassfish.GlassfishGenericServer;
import oracle.eclipse.tools.glassfish.GlassfishGenericServerBehaviour;
import oracle.eclipse.tools.glassfish.GlassfishToolsPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.generic.core.internal.publishers.ModulePackager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.util.ProjectModule;
import org.eclipse.wst.server.core.util.PublishHelper;

public class AssembleModules {
    protected IModule[] modulePath;
    protected IModule module;
    protected IPath assembleRoot;
    protected PublishHelper publishHelper;
    protected GlassfishGenericServer server;
    protected boolean childNeedsARedeployment = false;

    protected AssembleModules(IModule[] modulePath, IPath assembleRoot, GlassfishGenericServer server, PublishHelper helper) {
        this.modulePath = modulePath;
        this.module = modulePath[modulePath.length - 1];
        this.assembleRoot = assembleRoot;
        this.server = server;
        this.publishHelper = helper;
        GlassfishToolsPlugin.logMessage("AssembleModules assembleRoot=" + assembleRoot);
    }

    public IPath assembleWebModule(IProgressMonitor monitor) throws CoreException {
        boolean shouldCopy;
        IPath parent = this.assembleRoot;
        boolean bl = shouldCopy = 1 != this.server.getServer().getModulePublishState(this.modulePath);
        if (shouldCopy) {
            this.copyModule(this.module, monitor);
        }
        IWebModule webModule = (IWebModule)this.module.loadAdapter(IWebModule.class, monitor);
        IModule[] childModules = webModule.getModules();
        int i = 0;
        while (i < childModules.length) {
            IModule childModule = childModules[i];
            String uri = webModule.getURI(childModule);
            if (uri == null) {
                Status status = new Status(4, "org.eclipse.jst.server.generic.core", 0, "unable to assemble module null uri", null);
                throw new CoreException((IStatus)status);
            }
            IJ2EEModule jeeModule = (IJ2EEModule)childModule.loadAdapter(IJ2EEModule.class, monitor);
            if (jeeModule != null && jeeModule.isBinary()) {
                ProjectModule pm = (ProjectModule)childModule.loadAdapter(ProjectModule.class, null);
                IModuleResource[] resources = pm.members();
                this.publishHelper.publishToPath(resources, parent.append(uri), monitor);
            } else {
                String version = GlassfishGenericServerBehaviour.getVersion(this.server);
                if (version.indexOf(" 3.1") == -1) {
                    this.packModule(childModule, uri, parent);
                } else if (this.shouldRepack(childModule)) {
                    IModule[] childModulePath = new IModule[this.modulePath.length + 1];
                    System.arraycopy(this.modulePath, 0, childModulePath, 0, this.modulePath.length);
                    childModulePath[childModulePath.length - 1] = childModule;
                    AssembleModules assembler = new AssembleModules(childModulePath, this.assembleRoot.append(uri), this.server, this.publishHelper);
                    this.childNeedsARedeployment = this.childNeedsARedeployment || assembler.needsARedeployment();
                    assembler.copyModule(childModule, monitor);
                }
            }
            ++i;
        }
        return parent;
    }

    public static boolean isModuleType(IModule module, String moduleTypeId) {
        return module.getModuleType() != null && moduleTypeId.equals(module.getModuleType().getId());
    }

    protected void packModule(IModule module, String deploymentUnitName, IPath destination) throws CoreException {
        String dest = destination.append(deploymentUnitName).toString();
        GlassfishToolsPlugin.logMessage("AssembleModules dest=" + dest);
        ModulePackager packager = null;
        try {
            try {
                packager = new ModulePackager(dest, false);
                ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, null);
                IModuleResource[] resources = pm.members();
                int i = 0;
                while (i < resources.length) {
                    GlassfishToolsPlugin.logMessage("AssembleModules resources=" + resources[i]);
                    this.doPackModule(resources[i], packager);
                    ++i;
                }
            }
            catch (IOException e) {
                Status status = new Status(4, "oracle.eclipse.tools.glassfish", 0, "unable to assemble module", (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            try {
                packager.finished();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            packager.finished();
        }
        catch (Exception exception) {}
    }

    private void doPackModule(IModuleResource resource, ModulePackager packager) throws CoreException, IOException {
        if (resource instanceof IModuleFolder) {
            IModuleFolder mFolder = (IModuleFolder)resource;
            IModuleResource[] resources = mFolder.members();
            GlassfishToolsPlugin.logMessage("AssembleModules  doPackModule IModuleFolder=" + mFolder);
            GlassfishToolsPlugin.logMessage("AssembleModules  doPackModule resource.getModuleRelativePath()=" + resource.getModuleRelativePath());
            GlassfishToolsPlugin.logMessage("AssembleModules  resource.getModuleRelativePath().append(resource.getName()).toPortableString()=" + resource.getModuleRelativePath().append(resource.getName()).toPortableString());
            packager.writeFolder(resource.getModuleRelativePath().append(resource.getName()).toPortableString());
            int i = 0;
            while (resources != null && i < resources.length) {
                GlassfishToolsPlugin.logMessage("AssembleModules resources[i]=" + resources[i]);
                this.doPackModule(resources[i], packager);
                ++i;
            }
        } else {
            String destination = resource.getModuleRelativePath().append(resource.getName()).toPortableString();
            IFile file = (IFile)resource.getAdapter(IFile.class);
            if (file != null) {
                packager.write(file, destination);
            } else {
                File file2 = (File)resource.getAdapter(File.class);
                packager.write(file2, destination);
            }
        }
    }

    protected IPath copyModule(IModule module, IProgressMonitor monitor) throws CoreException {
        IStatus[] status;
        IWebModule webModule;
        IModule[] childModules;
        ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, monitor);
        IPath[] jarPaths = null;
        if (module.getModuleType().getId().equals("jst.web") && (childModules = (webModule = (IWebModule)module.loadAdapter(IWebModule.class, monitor)).getModules()) != null && childModules.length > 0) {
            jarPaths = new IPath[childModules.length];
            int i = 0;
            while (i < childModules.length) {
                IJ2EEModule childModule;
                jarPaths[i] = webModule != null ? new Path(webModule.getURI(childModules[i])) : ((childModule = (IJ2EEModule)childModules[i].loadAdapter(IJ2EEModule.class, monitor)) != null && childModule.isBinary() ? new Path("WEB-INF/lib").append(childModules[i].getName()) : new Path("WEB-INF/lib").append(String.valueOf(childModules[i].getName()) + ".jar"));
                ++i;
            }
        }
        if ((status = this.publishHelper.publishSmart(pm.members(), this.assembleRoot, jarPaths, monitor)) != null && status.length > 0) {
            int i = 0;
            while (i < status.length) {
                GlassfishToolsPlugin.logMessage("warning copying module: " + status[i].getMessage());
                ++i;
            }
        }
        return this.assembleRoot;
    }

    protected IPath copyEarModule(IModule module, IProgressMonitor monitor) throws CoreException {
        ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, monitor);
        IEnterpriseApplication earModule = (IEnterpriseApplication)module.loadAdapter(IEnterpriseApplication.class, monitor);
        IModule[] childModules = earModule.getModules();
        GlassfishToolsPlugin.logMessage("copyEarModule childModules.length=" + childModules.length);
        ArrayList<Path> ignorePaths = new ArrayList<Path>(childModules.length);
        int i = 0;
        while (i < childModules.length) {
            IModule childModule = childModules[i];
            String uri = earModule.getURI(childModule);
            if (uri == null) {
                Status status = new Status(4, "org.eclipse.jst.server.generic.core", 0, "unable to assemble module null uri", null);
                throw new CoreException((IStatus)status);
            }
            if (!childModule.getModuleType().getId().equals("jst.utility")) {
                if (uri.endsWith(".war")) {
                    uri = String.valueOf(uri.substring(0, uri.length() - 4)) + "_war";
                } else if (uri.endsWith(".jar")) {
                    uri = String.valueOf(uri.substring(0, uri.length() - 4)) + "_jar";
                } else if (uri.endsWith(".rar")) {
                    uri = String.valueOf(uri.substring(0, uri.length() - 4)) + "_rar";
                }
            }
            ignorePaths.add(new Path(uri));
            ++i;
        }
        IPath[] pathArr = new IPath[ignorePaths.size()];
        pathArr = ignorePaths.toArray(pathArr);
        IStatus[] status = this.publishHelper.publishSmart(pm.members(), this.assembleRoot, pathArr, monitor);
        if (status != null && status.length > 0) {
            int i2 = 0;
            while (i2 < status.length) {
                GlassfishToolsPlugin.logMessage("warning copying module: " + status[i2].getMessage());
                ++i2;
            }
        }
        return this.assembleRoot;
    }

    public IPath assembleNonWebOrNonEARModule(IProgressMonitor monitor) throws CoreException {
        return this.copyModule(this.module, monitor);
    }

    public IPath assembleEARModule(IProgressMonitor monitor) throws CoreException {
        boolean shouldCopy;
        IPath parent = this.assembleRoot;
        boolean bl = shouldCopy = 1 != this.server.getServer().getModulePublishState(this.modulePath);
        if (shouldCopy) {
            this.copyModule(this.module, monitor);
        }
        IEnterpriseApplication earModule = (IEnterpriseApplication)this.module.loadAdapter(IEnterpriseApplication.class, monitor);
        IModule[] childModules = earModule.getModules();
        int i = 0;
        while (i < childModules.length) {
            IModule module = childModules[i];
            String uri = earModule.getURI(module);
            if (uri == null) {
                Status status = new Status(4, "org.eclipse.jst.server.generic.core", 0, "unable to assemble module null uri", null);
                throw new CoreException((IStatus)status);
            }
            IJ2EEModule jeeModule = (IJ2EEModule)module.loadAdapter(IJ2EEModule.class, monitor);
            if (jeeModule != null && jeeModule.isBinary()) {
                ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, null);
                IModuleResource[] resources = pm.members();
                this.publishHelper.publishToPath(resources, parent.append(uri), monitor);
            } else if (this.shouldRepack(module)) {
                this.packModuleEARModule(module, uri, parent);
            }
            ++i;
        }
        return parent;
    }

    private boolean shouldRepack(IModule lmodule) {
        IModule[] childModulePath = new IModule[this.modulePath.length + 1];
        System.arraycopy(this.modulePath, 0, childModulePath, 0, this.modulePath.length);
        childModulePath[childModulePath.length - 1] = lmodule;
        boolean repack = 1 != this.server.getServer().getModulePublishState(childModulePath);
        return repack |= 1 != this.server.getServer().getModulePublishState(this.modulePath);
    }

    public boolean needsARedeployment() {
        Server _server = (Server)this.server.getServer();
        IModuleResourceDelta[] deltas = _server.getPublishedResourceDelta(this.modulePath);
        return this.childNeedsARedeployment || this.criticalResourceChangeThatNeedsARedeploy(deltas);
    }

    private boolean criticalResourceChangeThatNeedsARedeploy(IModuleResourceDelta[] deltas) {
        if (deltas == null) {
            return false;
        }
        int i = 0;
        while (i < deltas.length) {
            if (deltas[i].getModuleResource().getName().endsWith(".class")) {
                GlassfishToolsPlugin.logMessage("Class Changed in AssembleModules criticalResourceChangeThatNeedsARedeploy DELTA IS=" + deltas[i].getKind() + deltas[i].getModuleResource().getName());
                return true;
            }
            if (deltas[i].getModuleResource().getName().endsWith(".properties")) {
                return true;
            }
            if (deltas[i].getModuleResource().getName().endsWith(".xml")) {
                GlassfishToolsPlugin.logMessage("XML Changed in AssembleModules criticalResourceChangeThatNeedsARedeploy DELTA IS=" + deltas[i].getKind() + deltas[i].getModuleResource().getName());
                return true;
            }
            if (deltas[i].getModuleResource().getName().equalsIgnoreCase("manifest.mf")) {
                GlassfishToolsPlugin.logMessage("MANIFEST FIle  Changed in AssembleModules criticalResourceChangeThatNeedsARedeploy DELTA IS=" + deltas[i].getKind() + deltas[i].getModuleResource().getName());
                return true;
            }
            GlassfishToolsPlugin.logMessage("AssembleModules neither class manifest or xml file");
            IModuleResourceDelta[] childrenDeltas = deltas[i].getAffectedChildren();
            if (this.criticalResourceChangeThatNeedsARedeploy(childrenDeltas)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void packModuleEARModule(IModule module, String deploymentUnitName, IPath destination) throws CoreException {
        GlassfishToolsPlugin.logMessage("AssembleModules packModuleEARModule=" + module.getId() + " " + module.getName());
        GlassfishToolsPlugin.logMessage("AssembleModules deploymentUnitName=" + deploymentUnitName);
        GlassfishToolsPlugin.logMessage("AssembleModules destination=" + destination);
        if (module.getModuleType().getId().equals("jst.web")) {
            AssembleModules assembler = new AssembleModules(this.modulePath, this.assembleRoot, this.server, this.publishHelper);
            IPath webAppPath = assembler.assembleWebModule((IProgressMonitor)new NullProgressMonitor());
            String realDestination = destination.append(deploymentUnitName).toString();
            GlassfishToolsPlugin.logMessage("AssembleModules realDestination=" + realDestination);
            ModulePackager packager = null;
            try {
                try {
                    packager = new ModulePackager(realDestination, false);
                    packager.pack(webAppPath.toFile(), webAppPath.toOSString());
                }
                catch (IOException e) {
                    Status status = new Status(4, "org.eclipse.jst.server.generic.core", 0, "unable to assemble module", (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
            catch (Throwable throwable) {
                if (packager != null) {
                    try {
                        packager.finished();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (packager != null) {
                try {
                    packager.finished();
                }
                catch (IOException iOException) {}
            }
        } else {
            this.packModule(module, deploymentUnitName, destination);
        }
    }

    public IPath assembleDirDeployedEARModule(IProgressMonitor monitor) throws CoreException {
        boolean shouldCopy;
        IPath parent = this.assembleRoot;
        boolean bl = shouldCopy = 1 != this.server.getServer().getModulePublishState(this.modulePath);
        if (shouldCopy) {
            this.copyEarModule(this.module, monitor);
        }
        IEnterpriseApplication earModule = (IEnterpriseApplication)this.module.loadAdapter(IEnterpriseApplication.class, monitor);
        IModule[] childModules = earModule.getModules();
        GlassfishToolsPlugin.logMessage("assembleDirDeployedEARModule childModules.length=" + childModules.length);
        int i = 0;
        while (i < childModules.length) {
            IModule childModule = childModules[i];
            String uri = earModule.getURI(childModule);
            if (uri == null) {
                Status status = new Status(4, "org.eclipse.jst.server.generic.core", 0, "unable to assemble module null uri", null);
                throw new CoreException((IStatus)status);
            }
            IJ2EEModule jeeModule = (IJ2EEModule)childModule.loadAdapter(IJ2EEModule.class, monitor);
            if (jeeModule != null && jeeModule.isBinary()) {
                ProjectModule pm = (ProjectModule)childModule.loadAdapter(ProjectModule.class, null);
                IModuleResource[] resources = pm.members();
                this.publishHelper.publishToPath(resources, parent.append(uri), monitor);
            } else {
                if (!childModule.getModuleType().getId().equals("jst.utility")) {
                    if (uri.endsWith(".war")) {
                        uri = String.valueOf(uri.substring(0, uri.length() - 4)) + "_war";
                    } else if (uri.endsWith(".jar")) {
                        uri = String.valueOf(uri.substring(0, uri.length() - 4)) + "_jar";
                    } else if (uri.endsWith(".rar")) {
                        uri = String.valueOf(uri.substring(0, uri.length() - 4)) + "_rar";
                    }
                }
                if (this.shouldRepack(childModule)) {
                    AssembleModules assembler;
                    IModule[] childModulePath = new IModule[this.modulePath.length + 1];
                    System.arraycopy(this.modulePath, 0, childModulePath, 0, this.modulePath.length);
                    childModulePath[childModulePath.length - 1] = childModule;
                    if (childModule.getModuleType().getId().equals("jst.web")) {
                        assembler = new AssembleModules(childModulePath, this.assembleRoot.append(uri), this.server, this.publishHelper);
                        this.childNeedsARedeployment = this.childNeedsARedeployment || assembler.needsARedeployment();
                        assembler.assembleWebModule((IProgressMonitor)new NullProgressMonitor());
                    } else {
                        assembler = new AssembleModules(childModulePath, this.assembleRoot.append(uri), this.server, this.publishHelper);
                        this.childNeedsARedeployment = this.childNeedsARedeployment || assembler.needsARedeployment();
                        assembler.copyModule(childModule, monitor);
                    }
                }
            }
            ++i;
        }
        return parent;
    }
}

