/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.ui.service;

import oracle.eclipse.tools.adf.controller.TaskFlowFactory;
import oracle.eclipse.tools.adf.controller.model.IADFView;
import oracle.eclipse.tools.adf.controller.model.IStaticTaskFlowReference;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.ITaskFlowCall;
import oracle.eclipse.tools.adf.controller.model.TaskFlowType;
import oracle.eclipse.tools.adf.controller.util.ProjectUtil;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.DragAndDropService;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;

public class TaskFlowDropService
extends DragAndDropService {
    private static final String JSP_EXT = "jsp";
    private static final String JSPX_EXT = "jspx";
    private static final String JSF_EXT = "jsf";
    private static final String JSFF_EXT = "jsff";

    public boolean droppable(DragAndDropService.DropContext context) {
        Object obj = context.object();
        if (obj instanceof IFile) {
            IFile file = (IFile)obj;
            String ext = file.getFileExtension();
            SapphireDiagramEditorPagePart diagramPart = (SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class);
            if (file.getProject().equals(diagramPart.getLocalModelElement().adapt(IProject.class))) {
                if (this.isViewFile(file)) {
                    return true;
                }
                if (ext != null && ext.equalsIgnoreCase("xml") && TaskFlowUtil.getTaskFlowType((IFile)file) == TaskFlowType.Bounded) {
                    return true;
                }
            }
        }
        return false;
    }

    public void drop(DragAndDropService.DropContext context) {
        Object obj = context.object();
        if (obj instanceof IFile) {
            IFile file = (IFile)obj;
            String ext = file.getFileExtension();
            DiagramNodePart newActivityPart = null;
            SapphireDiagramEditorPagePart diagramPart = (SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class);
            if (this.isViewFile(file)) {
                newActivityPart = this.newViewFromFile(diagramPart, file);
            } else if (ext != null && ext.equalsIgnoreCase("xml")) {
                newActivityPart = this.newTFCallFromFile(diagramPart, file);
            }
            if (newActivityPart != null) {
                Point currentMousePos = context.position();
                newActivityPart.setNodeBounds(currentMousePos.getX(), currentMousePos.getY());
            }
        }
    }

    private boolean isViewFile(IFile file) {
        String ext = file.getFileExtension();
        return ext != null && (ext.equalsIgnoreCase(JSP_EXT) || ext.equalsIgnoreCase(JSPX_EXT) || ext.equalsIgnoreCase(JSF_EXT) || ext.equalsIgnoreCase(JSFF_EXT));
    }

    private DiagramNodePart newViewFromFile(SapphireDiagramEditorPagePart diagramPart, IFile file) {
        DiagramNodePart newViewPart = null;
        String fname = file.getName();
        String viewId = fname.substring(0, fname.lastIndexOf(46));
        ITaskFlow taskFlow = (ITaskFlow)diagramPart.getLocalModelElement().nearest(ITaskFlow.class);
        IPath relativePath = this.convertToRelative(file);
        if (taskFlow != null) {
            IADFView newView = (IADFView)taskFlow.getActivities().insert(IADFView.TYPE);
            String newId = TaskFlowUtil.getNextActivityId((String)viewId, (ITaskFlow)taskFlow);
            if (newId.endsWith("0")) {
                newId = newId.substring(0, newId.length() - 1);
            }
            newView.setActivityId(newId);
            newView.setPage("/" + relativePath.toPortableString());
            newViewPart = diagramPart.getDiagramNodePart((Element)newView);
        }
        return newViewPart;
    }

    private IPath convertToRelative(IFile file) {
        IContainer underlyingFolder = ProjectUtil.getWebContentFolderIResource((IProject)file.getProject());
        if (underlyingFolder != null) {
            IPath webRootPath = underlyingFolder.getProjectRelativePath();
            IPath relativePath = file.getProjectRelativePath().makeRelativeTo(webRootPath);
            return relativePath;
        }
        return null;
    }

    private DiagramNodePart newTFCallFromFile(SapphireDiagramEditorPagePart diagramPart, IFile file) {
        DiagramNodePart newActivityPart = null;
        ITaskFlow referedTaskFlow = TaskFlowFactory.createTaskFlow((IFile)file);
        String referedTaskFlowId = (String)referedTaskFlow.getTaskFlowId().content();
        IPath relativePath = this.convertToRelative(file);
        ITaskFlow taskFlow = (ITaskFlow)diagramPart.getLocalModelElement().nearest(ITaskFlow.class);
        if (taskFlow != null) {
            ITaskFlowCall tfCall = (ITaskFlowCall)taskFlow.getActivities().insert(ITaskFlowCall.TYPE);
            String newId = TaskFlowUtil.getNextActivityId((String)referedTaskFlowId, (ITaskFlow)taskFlow);
            if (newId.endsWith("0")) {
                newId = newId.substring(0, newId.length() - 1);
            }
            tfCall.setActivityId(newId);
            IStaticTaskFlowReference tfRef = (IStaticTaskFlowReference)tfCall.getTaskFlowReference().content(true, IStaticTaskFlowReference.TYPE);
            tfRef.setId(referedTaskFlowId);
            tfRef.setDocument("/" + relativePath.toPortableString());
            newActivityPart = diagramPart.getDiagramNodePart((Element)tfCall);
        }
        return newActivityPart;
    }
}

