/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.ui.internal.wizard;

import oracle.eclipse.tools.adf.controller.TaskFlowFactory;
import oracle.eclipse.tools.adf.controller.model.IMetadataResource;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.ITaskFlowFile;
import oracle.eclipse.tools.adf.controller.operations.IBoundedTaskFlowOp;
import oracle.eclipse.tools.adf.controller.operations.ICreateTaskFlowOp;
import oracle.eclipse.tools.adf.controller.ui.ADFControllerUiPlugin;
import oracle.eclipse.tools.adf.controller.ui.editor.TaskFlowEditor;
import oracle.eclipse.tools.adf.controller.util.ProjectUtil;
import oracle.eclipse.tools.adf.controller.util.UniqueTaskFlowName;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.workspace.CreateWorkspaceFileOp;
import org.eclipse.sapphire.workspace.ui.CreateWorkspaceFileWizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class CreateTaskFlowWizard
extends CreateWorkspaceFileWizard<ICreateTaskFlowOp> {
    private IFile fileHandle = null;

    public CreateTaskFlowWizard() {
        super(ICreateTaskFlowOp.TYPE, DefinitionLoader.sdef(CreateTaskFlowWizard.class).wizard());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        ICreateTaskFlowOp op = (ICreateTaskFlowOp)this.element();
        op.getBoundedTaskFlow().content(true);
        if (!selection.isEmpty()) {
            IFolder webInfFolder;
            IProject project;
            IContainer webContentFolder;
            Object obj = selection.getFirstElement();
            IResource resource = null;
            if (obj instanceof IResource && (webContentFolder = ProjectUtil.getWebContentFolderIResource((IProject)(project = (resource = (IResource)obj).getProject()))) != null && (webInfFolder = ((IFolder)webContentFolder).getFolder("WEB-INF")) != null && webInfFolder.exists()) {
                if (webInfFolder.getFullPath().isPrefixOf(resource.getFullPath()) && resource instanceof IFolder) {
                    op.setFolder(PathBridge.create((IPath)resource.getFullPath().makeRelative()));
                } else {
                    op.setFolder(PathBridge.create((IPath)webInfFolder.getFullPath().makeRelative()));
                }
                String uniqueName = UniqueTaskFlowName.generateUniqueName((CreateWorkspaceFileOp)op);
                op.setFile(uniqueName);
            }
        }
    }

    protected void performPostFinish() {
        ICreateTaskFlowOp op = (ICreateTaskFlowOp)this.element();
        this.fileHandle = (IFile)op.getFile().resolve();
        IBoundedTaskFlowOp boundedOp = (IBoundedTaskFlowOp)op.getBoundedTaskFlow().content();
        if (boundedOp != null) {
            ITaskFlow newTf = TaskFlowFactory.createTaskFlow((IFile)((IFile)op.getFile().resolve()));
            CreateTaskFlowWizard.recopyTemplateModel(boundedOp, newTf);
        } else {
            IFile newFileHandle = (IFile)((ICreateTaskFlowOp)this.element()).getFile().resolve();
            IProject project = newFileHandle.getProject();
            IContainer underlyingFolder = ProjectUtil.getWebContentFolderIResource((IProject)project);
            if (underlyingFolder != null) {
                IPath webContentPath = underlyingFolder.getProjectRelativePath();
                IFile adfcConfigFile = TaskFlowFactory.getDefaultUnboundedTaskFlowFile((IProject)project);
                if (adfcConfigFile.exists() && !adfcConfigFile.equals((Object)newFileHandle)) {
                    ITaskFlow adfcConfigModel = TaskFlowFactory.createTaskFlow((IFile)adfcConfigFile);
                    IPath relativePath = newFileHandle.getProjectRelativePath();
                    relativePath = relativePath.makeRelativeTo(webContentPath);
                    Path metaDataPath = new Path("/" + relativePath.toPortableString());
                    IMetadataResource newMetaData = (IMetadataResource)adfcConfigModel.getMetadataResources().insert();
                    newMetaData.setMetadataResource(metaDataPath);
                    try {
                        adfcConfigModel.resource().save();
                    }
                    catch (ResourceStoreException e) {
                        LoggingService.logException((Plugin)ADFControllerUiPlugin.getDefault(), (Throwable)e);
                    }
                }
            }
        }
        super.performPostFinish();
    }

    public IFile getFileHandle() {
        return this.fileHandle;
    }

    protected static void recopyTemplateModel(IBoundedTaskFlowOp boundedOp, ITaskFlow newTf) {
        if (boundedOp.getDocument().content() != null && !((Boolean)boundedOp.isUpdateWhenTemplateChange().content()).booleanValue()) {
            Path templatePath = (Path)boundedOp.getDocument().content();
            IFile templateFile = ResourcesPlugin.getWorkspace().getRoot().getFile(PathBridge.create((Path)templatePath));
            if (templateFile.exists()) {
                FileEditorInput input = new FileEditorInput(templateFile);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart ep = page.findEditor((IEditorInput)input);
                if (ep instanceof TaskFlowEditor && ep.isDirty()) {
                    ITaskFlowFile rootModel = (ITaskFlowFile)((TaskFlowEditor)ep).getModelElement();
                    ITaskFlow templateTf = rootModel.getTaskFlow();
                    String newId = (String)newTf.getTaskFlowId().content();
                    newTf.copy((Element)templateTf);
                    newTf.setTaskFlowId(newId);
                    try {
                        ((ITaskFlowFile)newTf.nearest(ITaskFlowFile.class)).resource().save();
                    }
                    catch (ResourceStoreException e) {
                        LoggingService.logException((Plugin)ADFControllerUiPlugin.getDefault(), (Throwable)e);
                    }
                }
            }
        }
    }
}

