/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.ui.actionhandler;

import oracle.eclipse.tools.adf.controller.model.IActivity;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import oracle.eclipse.tools.adf.debugger.AdfDebugModel;
import oracle.eclipse.tools.adf.debugger.taskflow.ActivityBreakpoint;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ToggleActivityBreakpointHandler
extends SapphireActionHandler {
    protected Object run(Presentation context) {
        DiagramNodePart nodePart = (DiagramNodePart)context.part();
        if (nodePart.getModelElement() instanceof IActivity) {
            String activityId;
            String taskflowName;
            IFile file;
            block6: {
                IActivity act = (IActivity)nodePart.getModelElement();
                file = (IFile)act.adapt(IFile.class);
                taskflowName = "UNBOUNDED_TASK_FLOW";
                ITaskFlow tf = (ITaskFlow)act.nearest(ITaskFlow.class);
                if (TaskFlowUtil.isBoundedTaskFlow((ITaskFlow)tf) || TaskFlowUtil.isTaskFlowTemplate((ITaskFlow)tf)) {
                    taskflowName = (String)tf.getTaskFlowId().content();
                }
                activityId = (String)act.getActivityId().content();
                if (activityId != null) break block6;
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Please specify an activity ID before setting breakpoint");
                return null;
            }
            try {
                ActivityBreakpoint brkpt = ActivityBreakpoint.findBreakpoint((IFile)file, (String)taskflowName, (String)activityId);
                if (brkpt == null) {
                    boolean register = true;
                    return AdfDebugModel.createTaskflowActivityBreakpoint((IResource)file, (String)taskflowName, (String)activityId, (boolean)register, null);
                }
                IBreakpointManager brkptMgr = DebugPlugin.getDefault().getBreakpointManager();
                brkptMgr.removeBreakpoint((IBreakpoint)brkpt, true);
                return brkpt;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

