/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.upgrade.internal;

import java.util.ArrayList;
import oracle.eclipse.tools.common.upgrade.IWorkspaceUpgradeParticipant;
import oracle.eclipse.tools.common.util.IOperation;
import oracle.eclipse.tools.common.wtp.core.ServerUtil;
import oracle.eclipse.tools.weblogic.upgrade.internal.WlsRuntimeNameProjectUpgradeParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;

public final class WlsRuntimeNameWorkspaceUpgradeParticipant
implements IWorkspaceUpgradeParticipant {
    public boolean check() throws CoreException {
        boolean hasOld92 = false;
        boolean hasNew92 = false;
        boolean hasOld100 = false;
        boolean hasNew100 = false;
        IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            String name = runtime.getName();
            if (name.equals("BEA WebLogic v9.2")) {
                hasOld92 = true;
            } else if (name.equals(WlsRuntimeNameProjectUpgradeParticipant.NEW_RUNTIME_NAME_9_2)) {
                hasNew92 = true;
            } else if (name.equals("BEA WebLogic v10.0")) {
                hasOld100 = true;
            } else if (name.equals(WlsRuntimeNameProjectUpgradeParticipant.NEW_RUNTIME_NAME_10_0)) {
                hasNew100 = true;
            }
            ++n2;
        }
        return hasOld92 && !hasNew92 || hasOld100 && !hasNew100;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        IOperation operation = new IOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                String name;
                IRuntime runtime;
                boolean hasNew92 = false;
                boolean hasNew100 = false;
                IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
                int n = iRuntimeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    runtime = iRuntimeArray[n2];
                    name = runtime.getName();
                    if (name.equals(WlsRuntimeNameProjectUpgradeParticipant.NEW_RUNTIME_NAME_9_2)) {
                        hasNew92 = true;
                    } else if (name.equals(WlsRuntimeNameProjectUpgradeParticipant.NEW_RUNTIME_NAME_10_0)) {
                        hasNew100 = true;
                    }
                    ++n2;
                }
                iRuntimeArray = ServerCore.getRuntimes();
                n = iRuntimeArray.length;
                n2 = 0;
                while (n2 < n) {
                    runtime = iRuntimeArray[n2];
                    name = runtime.getName();
                    if (name.equals("BEA WebLogic v9.2") && !hasNew92 || name.equals("BEA WebLogic v10.0") && !hasNew100) {
                        ArrayList<IServer> servers = new ArrayList<IServer>();
                        IServer[] iServerArray = ServerCore.getServers();
                        int n3 = iServerArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IServer server = iServerArray[n4];
                            IRuntime serverRuntime = server.getRuntime();
                            if (serverRuntime != null && serverRuntime.equals(runtime)) {
                                servers.add(server);
                            }
                            ++n4;
                        }
                        IRuntimeWorkingCopy rwc = runtime.createWorkingCopy();
                        ((RuntimeWorkingCopy)rwc).setAttribute("id-set", false);
                        rwc.setName(WlsRuntimeNameWorkspaceUpgradeParticipant.convertName(name));
                        runtime = rwc.save(true, null);
                        for (IServer server : servers) {
                            IServerWorkingCopy swc = server.createWorkingCopy();
                            swc.setRuntime(runtime);
                            swc.save(true, null);
                        }
                        IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
                        int n5 = iVMInstallTypeArray.length;
                        n3 = 0;
                        while (n3 < n5) {
                            IVMInstallType vmInstallType = iVMInstallTypeArray[n3];
                            IVMInstall[] iVMInstallArray = vmInstallType.getVMInstalls();
                            int n6 = iVMInstallArray.length;
                            int n7 = 0;
                            while (n7 < n6) {
                                IVMInstall vmInstall = iVMInstallArray[n7];
                                if (vmInstall.getName().equals(String.valueOf(name) + " JRE")) {
                                    vmInstall.setName(String.valueOf(rwc.getName()) + " JRE");
                                    JavaRuntime.saveVMConfiguration();
                                }
                                ++n7;
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
        };
        ServerUtil.modifyServerCoreMetadata((IOperation)operation);
    }

    private static String convertName(String oldName) {
        if (oldName.equals("BEA WebLogic v9.2")) {
            return WlsRuntimeNameProjectUpgradeParticipant.NEW_RUNTIME_NAME_9_2;
        }
        if (oldName.equals("BEA WebLogic v10.0")) {
            return WlsRuntimeNameProjectUpgradeParticipant.NEW_RUNTIME_NAME_10_0;
        }
        throw new IllegalStateException();
    }
}

