/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.upgrade.internal;

import java.util.Set;
import oracle.eclipse.tools.common.upgrade.AbstractProjectUpgradeParticipant;
import oracle.eclipse.tools.common.upgrade.IProjectUpgradeLog;
import oracle.eclipse.tools.common.upgrade.IProjectUpgradeParticipant;
import oracle.eclipse.tools.common.upgrade.UpgradeFramework;
import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import oracle.eclipse.tools.common.util.wtp.FacetedProjectMetadata;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class WlsRuntimeNameProjectUpgradeParticipant
extends AbstractProjectUpgradeParticipant {
    static final String OLD_RUNTIME_NAME_9_2 = "BEA WebLogic v9.2";
    static final String NEW_RUNTIME_NAME_9_2 = IWeblogicServerRuntime.RUNTIME_TYPE_9_2.getName();
    static final String OLD_RUNTIME_NAME_10_0 = "BEA WebLogic v10.0";
    static final String NEW_RUNTIME_NAME_10_0 = IWeblogicServerRuntime.RUNTIME_TYPE_10_0.getName();
    static final String JRE_NAME_SUFFIX = " JRE";

    public boolean check(IProject project) throws CoreException {
        IProjectUpgradeLog upgradeLog = UpgradeFramework.getProjectUpgradeLog((IProject)project);
        if (upgradeLog.findLastLogEntry(((Object)((Object)this)).getClass().getName()) != null) {
            return false;
        }
        if (!FacetedProjectMetadata.isFacetedProject((IProject)project)) {
            return false;
        }
        FacetedProjectMetadata md = new FacetedProjectMetadata(project);
        FacetedProjectMetadata.Runtime primaryRuntime = null;
        primaryRuntime = md.getPrimaryRuntime();
        if (primaryRuntime != null) {
            if (WlsRuntimeNameProjectUpgradeParticipant.checkRuntime(primaryRuntime)) {
                return true;
            }
            for (FacetedProjectMetadata.Runtime runtime : md.getSecondaryRuntimes()) {
                if (!WlsRuntimeNameProjectUpgradeParticipant.checkRuntime(runtime)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkRuntime(FacetedProjectMetadata.Runtime runtime) {
        String name = runtime.getName();
        return name.equals(OLD_RUNTIME_NAME_9_2) || name.equals(OLD_RUNTIME_NAME_10_0);
    }

    protected void prepare(IProject project, Set<IProjectUpgradeParticipant.Action> actions) throws CoreException {
        IFile f = project.getFile(".settings/org.eclipse.wst.common.project.facet.core.xml");
        actions.add(new IProjectUpgradeParticipant.Action(IProjectUpgradeParticipant.Action.Type.EDIT, f));
        if (JavaProjectUtil.isJavaProject((IProject)project)) {
            f = project.getFile(".classpath");
            actions.add(new IProjectUpgradeParticipant.Action(IProjectUpgradeParticipant.Action.Type.EDIT, f));
            f = project.getFile(".settings/org.eclipse.jst.common.project.facet.core.prefs");
            actions.add(new IProjectUpgradeParticipant.Action(IProjectUpgradeParticipant.Action.Type.EDIT, f));
        }
    }

    public void execute(IProject project, IProgressMonitor monitor) throws CoreException {
        FacetedProjectMetadata md = new FacetedProjectMetadata(project);
        FacetedProjectMetadata.Runtime primaryRuntime = null;
        primaryRuntime = md.getPrimaryRuntime();
        if (primaryRuntime != null) {
            String newRuntimeName = WlsRuntimeNameProjectUpgradeParticipant.convertOldName(primaryRuntime.getName());
            if (newRuntimeName != null) {
                primaryRuntime.setName(newRuntimeName);
            }
            for (FacetedProjectMetadata.Runtime runtime : md.getSecondaryRuntimes()) {
                newRuntimeName = WlsRuntimeNameProjectUpgradeParticipant.convertOldName(runtime.getName());
                if (newRuntimeName == null) continue;
                runtime.setName(newRuntimeName);
            }
        }
        md.save(project);
        if (!JavaProjectUtil.isJavaProject((IProject)project)) {
            return;
        }
        IJavaProject jproj = JavaCore.create((IProject)project);
        IClasspathEntry oldClasspathEntry = null;
        IClasspathEntry newClasspathEntry = null;
        IClasspathEntry[] iClasspathEntryArray = jproj.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            String oldName;
            String newName;
            String jreName;
            IPath path;
            IClasspathEntry cpentry = iClasspathEntryArray[n2];
            if (cpentry.getEntryKind() == 5 && (path = cpentry.getPath()).segment(0).equals("org.eclipse.jdt.launching.JRE_CONTAINER") && path.segmentCount() == 3 && (jreName = path.segment(2)).endsWith(JRE_NAME_SUFFIX) && (newName = WlsRuntimeNameProjectUpgradeParticipant.convertOldName(oldName = jreName.substring(0, jreName.length() - JRE_NAME_SUFFIX.length()))) != null) {
                oldClasspathEntry = cpentry;
                String newJreName = String.valueOf(newName) + JRE_NAME_SUFFIX;
                IPath newPath = path.removeLastSegments(1).append(newJreName);
                newClasspathEntry = JavaCore.newContainerEntry((IPath)newPath, (IAccessRule[])cpentry.getAccessRules(), (IClasspathAttribute[])cpentry.getExtraAttributes(), (boolean)cpentry.isExported());
                break;
            }
            ++n2;
        }
        if (newClasspathEntry != null) {
            JavaProjectUtil.replaceClasspathEntry((IJavaProject)jproj, oldClasspathEntry, newClasspathEntry);
            try {
                Preferences prefs = WlsRuntimeNameProjectUpgradeParticipant.getClasspathHelperPrefsNode(project);
                String[] stringArray = prefs.childrenNames();
                int n3 = stringArray.length;
                n = 0;
                while (n < n3) {
                    String name = stringArray[n];
                    if (name.equals(WlsRuntimeNameProjectUpgradeParticipant.encode(oldClasspathEntry.getPath()))) {
                        Preferences oldNode = prefs.node(name);
                        Preferences newNode = prefs.node(WlsRuntimeNameProjectUpgradeParticipant.encode(newClasspathEntry.getPath()));
                        String[] stringArray2 = oldNode.keys();
                        int n4 = stringArray2.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            String key = stringArray2[n5];
                            newNode.put(key, oldNode.get(key, null));
                            ++n5;
                        }
                        oldNode.removeNode();
                        prefs.flush();
                        break;
                    }
                    ++n;
                }
            }
            catch (BackingStoreException e) {
                throw new CoreException(WlsCorePlugin.createErrorStatus((Exception)((Object)e)));
            }
        }
    }

    private static final String convertOldName(String name) {
        if (name.equals(OLD_RUNTIME_NAME_9_2)) {
            return NEW_RUNTIME_NAME_9_2;
        }
        if (name.equals(OLD_RUNTIME_NAME_10_0)) {
            return NEW_RUNTIME_NAME_10_0;
        }
        return null;
    }

    private static Preferences getClasspathHelperPrefsNode(IProject project) {
        ProjectScope scope = new ProjectScope(project);
        IEclipsePreferences pluginRoot = scope.getNode("org.eclipse.jst.common.project.facet.core");
        return pluginRoot.node("classpath.helper");
    }

    private static String encode(IPath path) {
        return path.toString().replaceAll("/", "::");
    }
}

