/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.upgrade.internal;

import java.util.Set;
import oracle.eclipse.tools.common.upgrade.AbstractClasspathUpgradeParticipant;
import oracle.eclipse.tools.common.upgrade.IProjectUpgradeParticipant;
import oracle.eclipse.tools.weblogic.WlsRuntimeComponentType;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.syslib.SystemLibrariesContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.osgi.service.prefs.Preferences;

public final class WlsRuntimeClasspathUpgradeParticipant
extends AbstractClasspathUpgradeParticipant {
    private static final String PREV_RUNTIME_TARGET_1 = "com.bea.wlw.server.runtimeTarget";
    private static final String PREV_RUNTIME_TARGET_2 = "com.bea.weblogic.runtimeTarget";
    private static final String GENERIC_RUNTIME_TARGET = "org.eclipse.jst.server.generic.runtimeTarget";

    public boolean check(IJavaProject project, IClasspathEntry cpe) throws CoreException {
        String seg;
        if (cpe.getEntryKind() == 5 && (seg = cpe.getPath().segment(1)) != null) {
            IRuntimeComponentVersion targetedWlsVersion;
            if (seg.equals(PREV_RUNTIME_TARGET_1) || seg.equals(PREV_RUNTIME_TARGET_2)) {
                return true;
            }
            if (seg.equals(GENERIC_RUNTIME_TARGET) && (targetedWlsVersion = WlsRuntimeUtil.getWlsRuntimeVersion(project.getProject())) == WlsRuntimeComponentType.VERSION_9_2) {
                return true;
            }
        }
        return false;
    }

    protected void prepare(IProject project, Set<IProjectUpgradeParticipant.Action> actions) {
        super.prepare(project, actions);
        IFile f = project.getFile(".settings/org.eclipse.jst.common.project.facet.core.prefs");
        actions.add(new IProjectUpgradeParticipant.Action(IProjectUpgradeParticipant.Action.Type.EDIT, f));
    }

    public void execute(IJavaProject project, IClasspathEntry[] cp, int position) throws CoreException {
        IPath oldEntryPath = cp[position].getPath();
        String oldPrefsKey = oldEntryPath.toString().replaceAll("/", "::");
        cp[position] = JavaCore.newContainerEntry((IPath)SystemLibrariesContainer.CONTAINER_PATH);
        try {
            Preferences prefs = WlsRuntimeClasspathUpgradeParticipant.getClasspathHelperPrefsNode(project.getProject());
            String[] stringArray = prefs.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.equals(oldPrefsKey)) {
                    Preferences oldNode = prefs.node(name);
                    Preferences newNode = prefs.node("oracle.eclipse.tools.weblogic.lib.system");
                    String[] stringArray2 = oldNode.keys();
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String key = stringArray2[n4];
                        String value = oldNode.get(key, null);
                        if (value != null) {
                            newNode.put(key, value);
                        }
                        ++n4;
                    }
                    oldNode.removeNode();
                    prefs.flush();
                    break;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.weblogic", 0, e.getLocalizedMessage(), (Throwable)e));
        }
    }

    private static Preferences getClasspathHelperPrefsNode(IProject project) {
        ProjectScope scope = new ProjectScope(project);
        IEclipsePreferences pluginRoot = scope.getNode("org.eclipse.jst.common.project.facet.core");
        return pluginRoot.node("classpath.helper");
    }
}

