/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.upgrade.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import oracle.eclipse.tools.common.upgrade.IWorkspaceUpgradeParticipant;
import oracle.eclipse.tools.common.util.IOperation;
import oracle.eclipse.tools.common.util.wtp.ServerCorePrefs;
import oracle.eclipse.tools.common.wtp.core.ServerUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public final class Wls92RuntimeUpgradeParticipant
implements IWorkspaceUpgradeParticipant {
    private static final String PREVIOUS_SERVER_RUNTIME_TYPE_ID = "com.bea.wlw.server.runtime";

    public boolean check() throws CoreException {
        return this.getWls92Runtimes().length > 0;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        IOperation operation = new IOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                IRuntime[] wls92runtimes;
                IRuntime[] iRuntimeArray = wls92runtimes = Wls92RuntimeUpgradeParticipant.this.getWls92Runtimes();
                int n = wls92runtimes.length;
                int n2 = 0;
                while (n2 < n) {
                    IRuntime runtime = iRuntimeArray[n2];
                    String name = runtime.getName();
                    File location = runtime.getLocation().toFile();
                    runtime.delete();
                    WlsRuntimeUtil.createWlsRuntime(location, name);
                    ++n2;
                }
            }
        };
        ServerUtil.modifyServerCoreMetadata((IOperation)operation);
    }

    private IRuntime[] getWls92Runtimes() throws CoreException {
        IRuntime[] runtimes;
        ArrayList<IRuntime> wls92Runtimes = new ArrayList<IRuntime>();
        IRuntime[] iRuntimeArray = runtimes = ServerCore.getRuntimes();
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            if (this.isPrevVersionServerRuntime(runtime)) {
                wls92Runtimes.add(runtime);
            }
            ++n2;
        }
        return wls92Runtimes.toArray(new IRuntime[wls92Runtimes.size()]);
    }

    private boolean isPrevVersionServerRuntime(IRuntime runtime) throws CoreException {
        if (runtime.getRuntimeType() != null) {
            return runtime.getRuntimeType().getId().equals(PREVIOUS_SERVER_RUNTIME_TYPE_ID);
        }
        Set runtimes = ServerCorePrefs.getInstance().getRuntimes();
        for (ServerCorePrefs.Runtime rt : runtimes) {
            if (!rt.getName().equals(runtime.getName()) || !rt.getRuntimeTypeId().equals(PREVIOUS_SERVER_RUNTIME_TYPE_ID)) continue;
            return true;
        }
        return false;
    }
}

