/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.upgrade.internal;

import java.util.ArrayList;
import java.util.Set;
import oracle.eclipse.tools.common.upgrade.AbstractProjectUpgradeParticipant;
import oracle.eclipse.tools.common.upgrade.IProjectUpgradeParticipant;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class Wls92ProjectsTaskListUpgradeParticipant
extends AbstractProjectUpgradeParticipant {
    private static final String OLD_VALIDATOR_ID_9_2 = "org.eclipse.wst.xml.ui.internal.validation.Validator";
    private static final String VALIDATION_TYPE = "org.eclipse.wst.validation.problemmarker";

    public boolean check(IProject project) throws CoreException {
        IMarker[] marks = project.findMarkers(VALIDATION_TYPE, true, 2);
        if (marks == null || marks.length == 0) {
            return false;
        }
        IMarker[] iMarkerArray = marks;
        int n = marks.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker mark = iMarkerArray[n2];
            String owner = (String)mark.getAttribute("owner");
            if (owner != null && owner.equals(OLD_VALIDATOR_ID_9_2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void prepare(IProject project, Set<IProjectUpgradeParticipant.Action> actions) throws CoreException {
        IMarker[] marks = project.findMarkers(VALIDATION_TYPE, true, 2);
        if (marks == null || marks.length == 0) {
            return;
        }
        IMarker[] iMarkerArray = marks;
        int n = marks.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker mark = iMarkerArray[n2];
            String owner = (String)mark.getAttribute("owner");
            if (owner != null && owner.equals(OLD_VALIDATOR_ID_9_2)) {
                actions.add(new IProjectUpgradeParticipant.Action(IProjectUpgradeParticipant.Action.Type.CHANGE_MARKERS));
                return;
            }
            ++n2;
        }
    }

    public void execute(IProject project, IProgressMonitor monitor) throws CoreException {
        ArrayList<IMarker> marklist = new ArrayList<IMarker>();
        IMarker[] marks = project.findMarkers(VALIDATION_TYPE, true, 2);
        if (marks == null || marks.length == 0) {
            return;
        }
        IMarker[] iMarkerArray = marks;
        int n = marks.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker mark = iMarkerArray[n2];
            String owner = (String)mark.getAttribute("owner");
            if (owner != null && owner.equals(OLD_VALIDATOR_ID_9_2)) {
                marklist.add(mark);
            }
            ++n2;
        }
        int msize = marklist.size();
        if (msize == 0) {
            return;
        }
        IMarker[] dlist = new IMarker[msize];
        marklist.toArray(dlist);
        ResourcesPlugin.getWorkspace().deleteMarkers(dlist);
    }
}

