/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.upgrade.internal;

import java.io.File;
import java.io.IOException;
import oracle.eclipse.tools.common.upgrade.IWorkspaceUpgradeParticipant;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRegistry;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public final class J2EELibrariesRegistryUpgradeParticipant
implements IWorkspaceUpgradeParticipant {
    private static final String OLD_REGISTRY_DIR = ".metadata/.plugins/com.bea.wlw.libmodules.core";
    private static final String OLD_REGISTRY_FILE = ".metadata/.plugins/com.bea.wlw.libmodules.core/libmodules.xml";

    public boolean check() {
        File wsdir = J2EELibrariesRegistryUpgradeParticipant.getWorkspaceLocation();
        File regdir = new File(wsdir, OLD_REGISTRY_DIR);
        return regdir.exists();
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        File wsdir = J2EELibrariesRegistryUpgradeParticipant.getWorkspaceLocation();
        File regdir = new File(wsdir, OLD_REGISTRY_DIR);
        File regfile = new File(wsdir, OLD_REGISTRY_FILE);
        if (regfile.exists()) {
            LibraryModuleRegistry oldRegistry = new LibraryModuleRegistry(regfile);
            LibraryModuleRegistry newRegistry = LibraryModulesSvc.getRegistry();
            LibraryModule[] libraryModuleArray = oldRegistry.list();
            int n = libraryModuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                LibraryModule libmod = libraryModuleArray[n2];
                if (libmod.getLocation().exists() && !newRegistry.isConflicting(libmod, null)) {
                    try {
                        LibraryModule newLibraryModule = new LibraryModule(libmod.getLocation(), libmod.getName(), libmod.getSpecificationVersion(), libmod.getImplementationVersion(), libmod.getSourceLocations(), libmod.getJavadocLocations(), LibraryModulesSvc.getTempDir());
                        newRegistry.add(newLibraryModule);
                    }
                    catch (IOException e) {
                        LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        if (regdir.exists()) {
            new DeleteThread(regdir).start();
        }
    }

    private static File getWorkspaceLocation() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        return ws.getRoot().getLocation().toFile();
    }

    private static final class DeleteThread
    extends Thread {
        private final File dir;

        public DeleteThread(File dir) {
            this.dir = dir;
        }

        @Override
        public void run() {
            while (this.dir.exists()) {
                try {
                    FileUtil.delete((File)this.dir, (boolean)true);
                }
                catch (IOException iOException) {
                    throw new IllegalStateException();
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

