/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.syslib.internal;

import oracle.eclipse.tools.weblogic.syslib.IPathBasedSystemLibrary;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;

public final class SystemLibraryPathBinding
extends XmlValueBindingImpl {
    private static final String ATTR_PATH = "path";
    private static final char PATH_VAR_ESCAPE_CHAR = '%';
    private static final String PATH_VAR_ESCAPE_STRING = "%";

    public String read() {
        XmlElement el = this.xml(false);
        if (el != null) {
            if (this.property().definition() == IPathBasedSystemLibrary.PROP_LOCATION_KEY) {
                return SystemLibraryPathBinding.getLocationKey(el);
            }
            return SystemLibraryPathBinding.getRelativePath(el);
        }
        return null;
    }

    public void write(String value) {
        XmlElement el = this.xml(true);
        if (this.property().definition() == IPathBasedSystemLibrary.PROP_LOCATION_KEY) {
            SystemLibraryPathBinding.setLocationKey(el, value);
        } else {
            SystemLibraryPathBinding.setRelativePath(el, value);
        }
    }

    private static String getLocationKey(XmlElement el) {
        String locationKey;
        String path = el.getAttributeText(ATTR_PATH);
        if (path.startsWith(PATH_VAR_ESCAPE_STRING)) {
            int closingEscape = path.indexOf(37, 1);
            if (closingEscape == -1) {
                return null;
            }
            locationKey = path.substring(1, closingEscape);
        } else {
            locationKey = null;
        }
        return locationKey;
    }

    public static void setLocationKey(XmlElement el, String locationKey) {
        String relativePath = SystemLibraryPathBinding.getRelativePath(el);
        String path = SystemLibraryPathBinding.createCombinedPath(locationKey, relativePath);
        el.setAttributeText(ATTR_PATH, path, false);
    }

    private static String getRelativePath(XmlElement el) {
        String relativePath;
        String path = el.getAttributeText(ATTR_PATH);
        if (path.startsWith(PATH_VAR_ESCAPE_STRING)) {
            int closingEscape = path.indexOf(37, 1);
            if (closingEscape == -1) {
                return null;
            }
            relativePath = closingEscape < path.length() - 2 ? path.substring(closingEscape + 2) : null;
        } else {
            relativePath = path;
        }
        return relativePath;
    }

    private static void setRelativePath(XmlElement el, String relativePath) {
        String locationKey = SystemLibraryPathBinding.getLocationKey(el);
        String path = SystemLibraryPathBinding.createCombinedPath(locationKey, relativePath);
        el.setAttributeText(ATTR_PATH, path, false);
    }

    private static String createCombinedPath(String locationKey, String relativePath) {
        boolean isRelativePathNull;
        if ("WEBLOGIC_INSTALL_DIR".equals(locationKey)) {
            locationKey = null;
        }
        boolean isLocationKeyNull = locationKey == null || locationKey.length() == 0;
        boolean bl = isRelativePathNull = relativePath == null || relativePath.length() == 0;
        if (isLocationKeyNull) {
            return isRelativePathNull ? null : relativePath;
        }
        StringBuilder buf = new StringBuilder();
        buf.append('%');
        buf.append(locationKey);
        buf.append('%');
        if (!isRelativePathNull) {
            buf.append('/');
            buf.append(relativePath);
        }
        return buf.toString();
    }
}

