/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.syslib.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.syslib.ISystemLibrariesContainerDef;
import oracle.eclipse.tools.weblogic.syslib.ISystemLibrary;
import oracle.eclipse.tools.weblogic.syslib.SystemLibrariesContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;

public final class SystemLibrariesContainerImpl
implements IClasspathContainer {
    private static boolean initialized = false;
    private static ContainersRefresherThread containersRefresherThread = null;
    private final IPath containerPath;
    private final IClasspathEntry[] entries;

    private SystemLibrariesContainerImpl(IPath containerPath, IClasspathEntry[] entries) {
        this.containerPath = containerPath;
        this.entries = entries;
    }

    public IClasspathEntry[] getClasspathEntries() {
        return this.entries;
    }

    public String getDescription() {
        return Resources.containerLabel;
    }

    public int getKind() {
        return 2;
    }

    public IPath getPath() {
        return this.containerPath;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SystemLibrariesContainerImpl)) {
            return false;
        }
        return Arrays.equals(this.entries, ((SystemLibrariesContainerImpl)obj).entries);
    }

    public int hashCode() {
        return Arrays.hashCode(this.entries);
    }

    private static final IPath toPath(String str) {
        if (str == null) {
            return null;
        }
        return new Path(str);
    }

    private static final URL toUrl(String str) {
        if (str != null) {
            try {
                return new URL(str);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    private static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            RuntimeLifecycleListener.register();
            ResourceChangeListener.register();
            containersRefresherThread = new ContainersRefresherThread();
            containersRefresherThread.start();
        }
    }

    private static ContainersRefresherThread getContainersRefresherThread() {
        return containersRefresherThread;
    }

    public static SystemLibrariesContainerImpl createContainer(IJavaProject project, IPath containerPath) throws CoreException {
        WebLogicServerInstall wlsInstall = WebLogicServerInstall.getWebLogicServerInstall(project.getProject());
        HashSet<File> files = new HashSet<File>();
        ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
        if (wlsInstall != null && wlsInstall.isValid()) {
            File patchProfileJarLocation = wlsInstall.getPatchProfileJarLocation();
            if (patchProfileJarLocation != null) {
                SystemLibrariesContainerImpl.addLibraryWithReferences(cpEntries, files, (IPath)new Path(patchProfileJarLocation.getAbsolutePath()));
            }
            for (File library : wlsInstall.getSystemClasspathContributions()) {
                String libName = library.getName();
                String javadocLocation = libName.startsWith("javax.persistence") ? "http://java.sun.com/javaee/5/docs/api" : null;
                SystemLibrariesContainerImpl.addLibraryWithReferences(cpEntries, files, (IPath)new Path(library.getAbsolutePath()), null, SystemLibrariesContainerImpl.toUrl(javadocLocation));
            }
            ISystemLibrariesContainerDef def = null;
            try {
                def = SystemLibrariesContainer.getContainerDef(project);
            }
            catch (ResourceStoreException e) {
                WlsCorePlugin.logException((Exception)((Object)e));
            }
            if (def != null) {
                for (ISystemLibrary library : def.getSystemLibraries()) {
                    File resolvedLibPath;
                    Value<String> resolvedLibPathValue = library.getResolvedPath();
                    String resolvedLibPathValueString = resolvedLibPathValue.text();
                    if (resolvedLibPathValue.validation().severity() == Status.Severity.ERROR || resolvedLibPathValueString == null || files.contains(resolvedLibPath = new File(resolvedLibPathValueString))) continue;
                    Path libraryLocation = new Path(resolvedLibPath.getAbsolutePath());
                    IPath sourceLocation = SystemLibrariesContainerImpl.toPath(library.getSourceLocation().text());
                    URL javadocLocation = SystemLibrariesContainerImpl.toUrl(library.getJavadocLocation().text());
                    SystemLibrariesContainerImpl.addLibraryWithReferences(cpEntries, files, (IPath)libraryLocation, sourceLocation, javadocLocation);
                }
                def.dispose();
            }
        }
        IClasspathEntry[] cpEntriesArray = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
        return new SystemLibrariesContainerImpl(containerPath, cpEntriesArray);
    }

    private static void addLibraryWithReferences(List<IClasspathEntry> cpEntries, Set<File> files, IPath libraryLocation) {
        SystemLibrariesContainerImpl.addLibraryWithReferences(cpEntries, files, libraryLocation, null, null);
    }

    private static void addLibraryWithReferences(List<IClasspathEntry> cpEntries, Set<File> files, IPath libraryLocation, IPath sourceLocation, URL javadocLocation) {
        File file = new File(libraryLocation.toOSString());
        if (!files.contains(file) && file.exists()) {
            files.add(file);
            IClasspathEntry cpe = JavaProjectUtil.newLibraryEntry((IPath)libraryLocation, (IPath)sourceLocation, (URL)javadocLocation);
            cpEntries.add(cpe);
            IClasspathEntry[] iClasspathEntryArray = JavaCore.getReferencedClasspathEntries((IClasspathEntry)cpe, null);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry refClasspathEntry = iClasspathEntryArray[n2];
                IPath refLibraryPath = refClasspathEntry.getPath();
                File refFile = new File(refLibraryPath.toOSString());
                if (!files.contains(refFile) && refFile.exists()) {
                    files.add(refFile);
                    cpEntries.add(JavaProjectUtil.newLibraryEntry((IPath)refLibraryPath, (IPath)sourceLocation, (URL)javadocLocation));
                }
                ++n2;
            }
        }
    }

    private static final class ContainersRefresherThread
    extends Thread {
        private final LinkedList<IProject> projects = new LinkedList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IProject getProjectFromQueue() {
            LinkedList<IProject> linkedList = this.projects;
            synchronized (linkedList) {
                block6: {
                    if (!this.projects.isEmpty()) break block6;
                    try {
                        this.projects.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                }
                return this.projects.removeFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjectToQueue(IProject project) {
            LinkedList<IProject> linkedList = this.projects;
            synchronized (linkedList) {
                this.projects.addLast(project);
                this.projects.notify();
            }
        }

        @Override
        public void run() {
            IProject project;
            while ((project = this.getProjectFromQueue()) != null) {
                try {
                    IWorkspaceRunnable wsr = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor arg0) throws CoreException {
                            SystemLibrariesContainer.refreshContainer(project);
                        }
                    };
                    IWorkspace ws = ResourcesPlugin.getWorkspace();
                    ws.run(wsr, (ISchedulingRule)ws.getRoot(), 0, null);
                    continue;
                }
                catch (CoreException e) {
                    WlsCorePlugin.logException((Exception)((Object)e));
                    continue;
                }
                break;
            }
            return;
        }
    }

    public static final class Initializer
    extends ClasspathContainerInitializer {
        public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
            SystemLibrariesContainerImpl.initialize();
            SystemLibrariesContainerImpl container = SystemLibrariesContainerImpl.createContainer(project, containerPath);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }

        public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
            return true;
        }

        public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
            try {
                ISystemLibrariesContainerDef def = SystemLibrariesContainer.getContainerDef(project);
                for (ISystemLibrary lib : def.getSystemLibraries()) {
                    IClasspathEntry cpe = Initializer.findClasspathEntry(lib, containerSuggestion);
                    if (cpe == null) continue;
                    IPath newSourceAttachment = cpe.getSourceAttachmentPath();
                    String newSourceLocation = newSourceAttachment != null ? newSourceAttachment.toOSString() : null;
                    lib.setSourceLocation(newSourceLocation);
                    lib.setJavadocLocation(JavaProjectUtil.getJavadocLocation((IClasspathEntry)cpe));
                }
                def.resource().save();
                def.dispose();
            }
            catch (ResourceStoreException e) {
                throw new CoreException(WlsCorePlugin.createErrorStatus((Exception)((Object)e)));
            }
        }

        private static IClasspathEntry findClasspathEntry(ISystemLibrary lib, IClasspathContainer container) {
            String resolvedLibLocation = lib.getResolvedPath().text();
            if (resolvedLibLocation == null) {
                return null;
            }
            Path resolvedLibPath = new Path(resolvedLibLocation);
            IClasspathEntry[] iClasspathEntryArray = container.getClasspathEntries();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getPath().equals((Object)resolvedLibPath)) {
                    return entry;
                }
                ++n2;
            }
            return null;
        }
    }

    private static final class ResourceChangeListener
    implements IResourceChangeListener {
        private final List<IPath> triggerFiles = new ArrayList<IPath>();

        public static void register() {
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            ws.addResourceChangeListener((IResourceChangeListener)new ResourceChangeListener(), 1);
        }

        private ResourceChangeListener() {
            this.triggerFiles.add((IPath)new Path(".settings/org.eclipse.wst.common.project.facet.core.xml"));
            this.triggerFiles.add((IPath)new Path(".settings/oracle.eclipse.tools.weblogic.syslib.xml"));
            this.triggerFiles.add((IPath)new Path(".settings/com.bea.workshop.wls.core.systemlibs.xml"));
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta subdelta = iResourceDeltaArray[n2];
                IProject project = (IProject)subdelta.getResource();
                boolean relevant = false;
                for (IPath p : this.triggerFiles) {
                    if (subdelta.findMember(p) == null) continue;
                    try {
                        if (!SystemLibrariesContainer.isOnClasspath(project)) break;
                        relevant = true;
                    }
                    catch (CoreException e) {
                        WlsCorePlugin.logException((Exception)((Object)e));
                    }
                    break;
                }
                if (relevant) {
                    SystemLibrariesContainerImpl.getContainersRefresherThread().addProjectToQueue(project);
                }
                ++n2;
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String containerLabel;

        static {
            Resources.initializeMessages((String)SystemLibrariesContainerImpl.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private static final class RuntimeLifecycleListener
    implements IRuntimeLifecycleListener {
        private RuntimeLifecycleListener() {
        }

        public static void register() {
            ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)new RuntimeLifecycleListener());
        }

        public void runtimeAdded(IRuntime runtime) {
            this.handleEvent(runtime);
        }

        public void runtimeChanged(IRuntime runtime) {
            this.handleEvent(runtime);
        }

        public void runtimeRemoved(IRuntime runtime) {
            this.handleEvent(runtime);
        }

        private void handleEvent(IRuntime runtime) {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                try {
                    org.eclipse.wst.common.project.facet.core.runtime.IRuntime r;
                    IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
                    if (fproj != null && (r = fproj.getPrimaryRuntime()) != null && r.getName().equals(runtime.getId())) {
                        SystemLibrariesContainerImpl.getContainersRefresherThread().addProjectToQueue(project);
                    }
                }
                catch (CoreException e) {
                    WlsCorePlugin.logException((Exception)((Object)e));
                }
                ++n2;
            }
        }
    }
}

