/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.properties;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IJ2EEDeploymentHelper;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.server.IWlsJMXHelper;
import oracle.eclipse.tools.weblogic.server.ServerInfo;
import oracle.eclipse.tools.weblogic.server.internal.ServerConfiguration;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerRuntime;
import oracle.eclipse.tools.weblogic.server.properties.AutoPublishSetting;
import oracle.eclipse.tools.weblogic.server.properties.IModuleDeploymentOptionsModel;
import oracle.eclipse.tools.weblogic.server.properties.IModulePublishingTarget;
import oracle.eclipse.tools.weblogic.server.properties.IRuntimeComponentModel;
import oracle.eclipse.tools.weblogic.server.properties.IWebLogicServerModel;
import oracle.eclipse.tools.weblogic.server.properties.KeystoreType;
import oracle.eclipse.tools.weblogic.server.properties.ModuleDeploymentOptionsModelResource;
import oracle.eclipse.tools.weblogic.server.properties.ModulePublishingTargetResource;
import oracle.eclipse.tools.weblogic.server.properties.PublishMode;
import oracle.eclipse.tools.weblogic.server.properties.RuntimeComponentModelResource;
import oracle.eclipse.tools.weblogic.server.properties.ServerType;
import oracle.eclipse.tools.weblogic.server.properties.internal.DeploymentTarget;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LayeredListPropertyBinding;
import org.eclipse.sapphire.ListPropertyBinding;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;

public final class WebLogicServerModelResource
extends Resource {
    private WeblogicServer weblogicServer;
    private IServerWorkingCopy swc;
    private String remotePort = null;
    private String publishInterval = null;
    private IServer server = null;
    private String domainPath = null;
    private String domainName = null;
    private String adminServer = null;
    private boolean serverDisconnected = true;
    private String publishTimeout = null;
    private boolean useSSLPort = false;
    private boolean useTunneling = false;
    private String identityStorePasswd = null;
    private String trustStorePasswd = null;
    private String owsmKeyStorePasswd = null;

    public WebLogicServerModelResource(IServer newServer) {
        super(null);
        this.server = newServer;
        this.swc = this.server.createWorkingCopy();
        this.weblogicServer = (WeblogicServer)this.swc.loadAdapter(WeblogicServer.class, (IProgressMonitor)new NullProgressMonitor());
    }

    public void save() throws ResourceStoreException {
        super.save();
        try {
            WeblogicServerBehaviour serverBehavior;
            if (this.swc.isDirty()) {
                this.swc.save(true, (IProgressMonitor)new NullProgressMonitor());
            }
            if ((serverBehavior = (WeblogicServerBehaviour)this.weblogicServer.getServer().loadAdapter(WeblogicServerBehaviour.class, (IProgressMonitor)new NullProgressMonitor())) != null) {
                serverBehavior.resetServerWatcher();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected PropertyBinding createBinding(Property property) {
        String defaultVal;
        PropertyDef p = property.definition();
        DefaultValue dv = (DefaultValue)p.getAnnotation(DefaultValue.class);
        String string = defaultVal = dv != null ? dv.text() : null;
        if (p == IWebLogicServerModel.PROP_RUNTIME_COMPONENTS) {
            return this.createRuntimeComponentList(property);
        }
        if (p == IWebLogicServerModel.PROP_MODULE_DEPLOYMENT_OPTIONS) {
            return this.createDeploymentOptionList(property);
        }
        if (p == IWebLogicServerModel.PROP_MODULE_PUBLISHING_TARGETS) {
            return this.createPublishTargetsList(property);
        }
        String propName = property.name();
        final Class<WebLogicServerModelResource> clz = WebLogicServerModelResource.class;
        String getter = "read" + propName;
        final String setter = "write" + propName;
        WebLogicServerModelResource obj = this;
        return new ValuePropertyBinding((Object)obj, getter, defaultVal){
            private final /* synthetic */ Object val$obj;
            private final /* synthetic */ String val$getter;
            private final /* synthetic */ String val$defaultVal;
            {
                this.val$obj = object;
                this.val$getter = string2;
                this.val$defaultVal = string3;
            }

            public void write(String value) {
                try {
                    Method m = clz.getMethod(setter, String.class);
                    m.invoke(this.val$obj, value);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }

            public String read() {
                Object ret = null;
                try {
                    Method m = clz.getMethod(this.val$getter, String.class);
                    ret = m.invoke(this.val$obj, this.val$defaultVal);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException invocationTargetException) {
                    String msg = CorePlugin.getString("errorServerInvalid", new Object[0]);
                    WlsCorePlugin.logError(msg);
                }
                return ret == null ? null : ret.toString();
            }
        };
    }

    private PropertyBinding createPublishTargetsList(Property property) {
        LayeredListPropertyBinding listBinding = new LayeredListPropertyBinding(){
            List<DeploymentTarget> targetList = null;

            protected List<?> readUnderlyingList() {
                if (this.targetList == null) {
                    this.targetList = new ArrayList<DeploymentTarget>();
                    String deployTargets = WebLogicServerModelResource.this.getServerWorkingCopy().getAttribute("deployment_targets", "");
                    if (deployTargets.length() == 0) {
                        String adminServerName = WebLogicServerModelResource.this.getServerInfo().getServerName();
                        if (WebLogicServerModelResource.this.weblogicServer.isRemote()) {
                            if (WebLogicServerModelResource.this.weblogicServer.getServer().getServerState() == 2) {
                                IJ2EEDeploymentHelper helper;
                                WeblogicServerBehaviour behavior = (WeblogicServerBehaviour)WebLogicServerModelResource.this.server.loadAdapter(WeblogicServerBehaviour.class, (IProgressMonitor)new NullProgressMonitor());
                                if (WebLogicServerModelResource.this.server.getServerState() == 2 && (helper = behavior.getPublisher()) != null) {
                                    try {
                                        IWlsJMXHelper JMXHelper = helper.getWlsJMXHelper();
                                        adminServerName = JMXHelper.getAdminServerName();
                                    }
                                    catch (Exception exception) {}
                                }
                            } else {
                                adminServerName = "AdminServer";
                            }
                        }
                        WebLogicServerModelResource.this.getServerWorkingCopy().setAttribute("deployment_targets", String.valueOf(adminServerName) + ",");
                        this.targetList.add(new DeploymentTarget(adminServerName));
                    } else {
                        String[] targets = deployTargets.split(",");
                        if (targets.length > 0) {
                            String[] stringArray = targets;
                            int n = targets.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String e = stringArray[n2];
                                if (e.length() > 0) {
                                    this.targetList.add(new DeploymentTarget(e));
                                }
                                ++n2;
                            }
                        }
                    }
                }
                return this.targetList;
            }

            protected Object insertUnderlyingObject(ElementType type, int position) {
                DeploymentTarget ret = new DeploymentTarget("");
                this.targetList.add(ret);
                return ret;
            }

            public void remove(Resource resource) {
                ModulePublishingTargetResource res = (ModulePublishingTargetResource)resource;
                String deployTargets = WebLogicServerModelResource.this.getServerWorkingCopy().getAttribute("deployment_targets", "");
                deployTargets = deployTargets.replace(String.valueOf(res.getTarget().getName()) + ',', "");
                WebLogicServerModelResource.this.swc.setAttribute("deployment_targets", deployTargets);
                Iterator<DeploymentTarget> it = this.targetList.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(res.getTarget())) continue;
                    it.remove();
                    break;
                }
            }

            protected Resource resource(Object obj) {
                ModulePublishingTargetResource res = new ModulePublishingTargetResource(WebLogicServerModelResource.this, obj);
                return res;
            }

            public ElementType type(Resource obj) {
                return IModulePublishingTarget.TYPE;
            }
        };
        return listBinding;
    }

    private PropertyBinding createDeploymentOptionList(Property property) {
        LayeredListPropertyBinding listBinding = new LayeredListPropertyBinding(){
            List<String> moduleDeployOptions = null;

            protected List<?> readUnderlyingList() {
                this.moduleDeployOptions = WebLogicServerModelResource.this.swc.getAttribute("module_deploy_options", new ArrayList());
                StringBuilder moduleDeployplans = new StringBuilder();
                for (String s : this.moduleDeployOptions) {
                    String[] options = s.split(",");
                    String name = null;
                    String deployplan = null;
                    String[] stringArray = options;
                    int n = options.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String option = stringArray[n2];
                        if (option.startsWith("deployplan=")) {
                            deployplan = option.substring(option.indexOf(61) + 1);
                        }
                        if (option.startsWith("name=")) {
                            name = option.substring(option.indexOf(61) + 1);
                        }
                        ++n2;
                    }
                    moduleDeployplans.append(String.valueOf(name) + '=' + deployplan + ',');
                }
                return this.moduleDeployOptions;
            }

            protected Object insertUnderlyingObject(ElementType type, int position) {
                String name = "";
                String deployplan = "plan.xml";
                String newOption = "name=" + name + ',' + "deployplan=" + deployplan;
                List moduleDeployOptions = WebLogicServerModelResource.this.swc.getAttribute("module_deploy_options", new ArrayList());
                moduleDeployOptions.add(newOption);
                WebLogicServerModelResource.this.swc.setAttribute("module_deploy_options", moduleDeployOptions);
                return newOption;
            }

            public void remove(Resource resource) {
                ModuleDeploymentOptionsModelResource res = (ModuleDeploymentOptionsModelResource)resource;
                List moduleDeployOptions = WebLogicServerModelResource.this.swc.getAttribute("module_deploy_options", new ArrayList());
                moduleDeployOptions.remove(res.getOptionString());
                WebLogicServerModelResource.this.swc.setAttribute("module_deploy_options", moduleDeployOptions);
            }

            protected Resource resource(Object obj) {
                ModuleDeploymentOptionsModelResource res = new ModuleDeploymentOptionsModelResource(WebLogicServerModelResource.this, obj);
                return res;
            }

            public ElementType type(Resource obj) {
                return IModuleDeploymentOptionsModel.TYPE;
            }
        };
        return listBinding;
    }

    private ListPropertyBinding createRuntimeComponentList(Property property) {
        LayeredListPropertyBinding listBinding = new LayeredListPropertyBinding(){
            List<IRuntimeComponent> runtimeComps = null;

            protected List<?> readUnderlyingList() {
                if (this.runtimeComps == null) {
                    this.runtimeComps = new ArrayList<IRuntimeComponent>();
                    IRuntime runtime = WebLogicServerModelResource.this.server.getRuntime();
                    for (IRuntimeComponent rc : RuntimeBridgeUtil.bridge((IRuntime)runtime).getRuntimeComponents()) {
                        this.runtimeComps.add(rc);
                    }
                }
                return this.runtimeComps;
            }

            protected Resource resource(Object obj) {
                return new RuntimeComponentModelResource(WebLogicServerModelResource.this, obj);
            }

            public ElementType type(Resource obj) {
                return IRuntimeComponentModel.TYPE;
            }
        };
        return listBinding;
    }

    public IServerWorkingCopy getServerWorkingCopy() {
        return this.swc;
    }

    public String readRuntimeName(String defaultVal) {
        String runtimeName = this.server.getRuntime().getName();
        return runtimeName;
    }

    public String readWeblogicHome(String defaultVal) {
        String ret = this.getServerWorkingCopy().getRuntime().getLocation().toOSString();
        return ret;
    }

    private ServerInfo getServerInfo() {
        ServerInfo ret = this.weblogicServer.getServerInfo();
        if (ret == null) {
            ret = new ServerInfo("localhost", 7001);
        }
        return ret;
    }

    public String readAdminServer(String defaultVal) {
        if (!this.weblogicServer.isRemote()) {
            return this.getServerInfo().getServerName();
        }
        return this.adminServer;
    }

    public void writeAdminServer(String val) {
        this.adminServer = val;
    }

    public String readDomainHome(String defaultVal) {
        if (this.domainPath != null) {
            return this.domainPath;
        }
        if (!this.weblogicServer.isRemote()) {
            this.domainPath = this.weblogicServer.getDomainPath().toOSString();
            return this.domainPath;
        }
        return null;
    }

    public void writeDomainHome(String path) {
        this.domainPath = path;
        if (!this.weblogicServer.isRemote()) {
            try {
                ServerConfiguration cfg = new ServerConfiguration((IPath)new Path(path));
                cfg.getServerInfo();
                this.weblogicServer.setDomainPath((IPath)new Path(path));
            }
            catch (CoreException coreException) {}
        }
    }

    public String readDomainName(String defaultVal) {
        if (!this.weblogicServer.isRemote()) {
            return this.getServerInfo().getDomainName();
        }
        return this.domainName;
    }

    public void writeDomainName(String val) {
        this.domainName = val;
    }

    public String readDomainVersion(String defaultVal) {
        if (!this.weblogicServer.isRemote()) {
            return this.getServerInfo().getConfigVersion();
        }
        return null;
    }

    public String readListeningAddress(String defaultVal) {
        ServerInfo info = this.getServerInfo();
        return info.getHostName();
    }

    public String readHttpsPort(String defaultVal) {
        ServerInfo info = this.getServerInfo();
        if (this.weblogicServer.isRemote()) {
            String httpsPort = this.swc.getAttribute("weblogic_https_port", "");
            return defaultVal.equals(httpsPort) ? null : httpsPort;
        }
        return info.getHttpsPort() != -1 ? Integer.toString(info.getHttpsPort()) : "";
    }

    public void writeHttpsPort(String value) {
        if (value == null) {
            value = "7002";
        }
        this.swc.setAttribute("weblogic_https_port", value);
        this.writeUseSSLPort(Boolean.FALSE.toString());
    }

    public String readPort(String defaultVal) {
        ServerInfo info = this.getServerInfo();
        String port = Integer.toString(info.getPortNumber());
        return defaultVal.equals(port) ? null : port;
    }

    public String readRemoteHost(String defaultVal) {
        return this.swc.getAttribute("weblogic_host_name", null);
    }

    public String readUserName(String defaultVal) {
        return this.swc.getAttribute("weblogic_username", null);
    }

    public String readDebugPort(String defaultVal) {
        String debugPort = this.swc.getAttribute("weblogic_debug_port", defaultVal);
        return debugPort.equals(defaultVal) ? null : debugPort;
    }

    public String readServerType(String defaultVal) {
        boolean isRemote = this.weblogicServer.isRemote();
        if (isRemote) {
            return ServerType.REMOTE_SERVER.toString();
        }
        ServerInfo serverInfo = this.getServerInfo();
        if (serverInfo != null) {
            Set<String> clusterNames = serverInfo.getClusterNames();
            List<ServerInfo> serverInfoList = this.getServerInfo().getManagedServerList();
            if (clusterNames.size() > 0 || serverInfoList.size() > 0) {
                return ServerType.LOCAL_MUTIL_SERVERS.toString();
            }
        }
        return ServerType.LOCAL_SERVER.toString();
    }

    public void writeServerType(String value) {
        throw new UnsupportedOperationException();
    }

    public void writeDebugPort(String value) {
        this.swc.setAttribute("weblogic_debug_port", value);
    }

    public void writeRemoteHost(String value) {
        this.swc.setAttribute("weblogic_host_name", value);
    }

    public String readRemotePort(String defaultVal) {
        if (this.remotePort == null) {
            ServerInfo info = this.getServerInfo();
            this.remotePort = Integer.toString(info.getPortNumber());
        }
        return defaultVal.equals(this.remotePort) ? null : this.remotePort;
    }

    public void writeRemotePort(String value) {
        if (value == null) {
            value = "7001";
        }
        this.remotePort = value;
        try {
            int val = Integer.parseInt(value);
            this.swc.setAttribute("weblogic_port", val);
        }
        catch (Exception exception) {}
    }

    public void writeUserName(String value) {
        this.swc.setAttribute("weblogic_username", value);
    }

    public void writePort(String value) {
        if (value == null) {
            this.swc.setAttribute("weblogic_port", "7001");
        } else {
            this.swc.setAttribute("weblogic_port", value);
        }
    }

    public String readPassword(String defaultVal) {
        String passwd = this.weblogicServer.getPassword();
        return passwd;
    }

    public void writePassword(String value) {
        if (value == null) {
            value = "";
        }
        if (value != null) {
            this.weblogicServer.setPassword(value);
        }
    }

    public String readUseSSLPort(String defaultVal) {
        this.useSSLPort = this.weblogicServer.isUseSSLPort();
        if (!this.useSSLPort) {
            return null;
        }
        return "true";
    }

    public void writeUseSSLPort(String value) {
        if (value == null) {
            this.weblogicServer.setUseSSLPort(false);
        } else {
            this.weblogicServer.setUseSSLPort(Boolean.valueOf(value));
        }
    }

    public String readUseTunneling(String defaultVal) {
        this.useTunneling = this.weblogicServer.isTunneling();
        if (!this.useTunneling) {
            return null;
        }
        return "true";
    }

    public void writeUseTunneling(String value) {
        if (value == null) {
            this.weblogicServer.setTunneling(false);
        } else {
            this.weblogicServer.setTunneling(Boolean.valueOf(value));
        }
    }

    public String readExpressMode(String defaultVal) {
        boolean isExpressMode = this.swc.getAttribute("start_as_wlx", false);
        return isExpressMode ? Boolean.toString(isExpressMode) : null;
    }

    public void writeExpressMode(String value) {
        this.swc.setAttribute("start_as_wlx", Boolean.parseBoolean(value));
    }

    public String readLaunchBrowser(String defaultVal) {
        boolean isLaunchBrowser = this.swc.getAttribute("LAUNCH_BROWSER_AFTER_START", false);
        return isLaunchBrowser ? Boolean.toString(isLaunchBrowser) : null;
    }

    public void writeLaunchBrowser(String value) {
        this.swc.setAttribute("LAUNCH_BROWSER_AFTER_START", Boolean.parseBoolean(value));
    }

    public String readLaunchInConsole(String defaultVal) {
        boolean isLaunchInConsole = this.swc.getAttribute("START_SERVER_IN_CONSOLE", true);
        return isLaunchInConsole ? null : Boolean.toString(isLaunchInConsole);
    }

    public void writeLaunchInConsole(String value) {
        this.swc.setAttribute("START_SERVER_IN_CONSOLE", Boolean.parseBoolean(value));
    }

    public String readStartInDebug(String defaultVal) {
        boolean isLaunchInDebug = this.swc.getAttribute("start_with_debug", false);
        return isLaunchInDebug ? Boolean.toString(isLaunchInDebug) : null;
    }

    public void writeStartInDebug(String value) {
        this.swc.setAttribute("start_with_debug", Boolean.parseBoolean(value));
    }

    public String readStartTimeout(String defaultVal) {
        String val = this.swc.getAttribute("start-timeout", defaultVal);
        return defaultVal.equals(val) ? null : val;
    }

    public void writeStartTimeout(String value) {
        this.swc.setAttribute("start-timeout", value);
    }

    public String readStopTimeout(String defaultVal) {
        String val = this.swc.getAttribute("stop-timeout", defaultVal);
        return defaultVal.equals(val) ? null : val;
    }

    public void writeStopTimeout(String value) {
        this.swc.setAttribute("stop-timeout", value);
    }

    public String readPublishMode(String defaultVal) {
        if (this.weblogicServer.isRemote()) {
            return PublishMode.EXPLODED_ARCHIVE.toString();
        }
        ServerWorkingCopy swc2 = (ServerWorkingCopy)this.swc;
        if (!swc2.isAttributeSet("RUN_WEB_MODULE_FROM_WORKSPACE")) {
            return null;
        }
        boolean isSplitSource = this.swc.getAttribute("RUN_WEB_MODULE_FROM_WORKSPACE", true);
        return isSplitSource ? PublishMode.SPLIT_SOURCE.toString() : PublishMode.EXPLODED_ARCHIVE.toString();
    }

    public void writePublishMode(String value) {
        if (value == null) {
            this.swc.setAttribute("RUN_WEB_MODULE_FROM_WORKSPACE", !this.weblogicServer.isRemote());
            return;
        }
        boolean isSplitSource = PublishMode.SPLIT_SOURCE.toString().equals(value);
        this.swc.setAttribute("RUN_WEB_MODULE_FROM_WORKSPACE", isSplitSource);
    }

    public String readIgnoreBuildError(String defaultVal) {
        boolean isIgnoreErr = this.swc.getAttribute("IGNORE_COMPILER_ERRORS", false);
        return isIgnoreErr ? Boolean.toString(isIgnoreErr) : null;
    }

    public void writeIgnoreBuildError(String value) {
        this.swc.setAttribute("IGNORE_COMPILER_ERRORS", Boolean.parseBoolean(value));
    }

    public String readAutoPublishSetting(String defaultVal) {
        int setting = this.swc.getAttribute("auto-publish-setting", 1);
        if (setting == 3) {
            return AutoPublishSetting.AUTO_AFTER_BUILD.toString();
        }
        if (setting == 2) {
            return AutoPublishSetting.AUTO_AFTER_RES_CHANGE.toString();
        }
        return null;
    }

    public void writeAutoPublishSetting(String value) {
        if (AutoPublishSetting.AUTO_AFTER_BUILD.toString().equals(value)) {
            this.swc.setAttribute("auto-publish-setting", 3);
        } else if (AutoPublishSetting.AUTO_AFTER_RES_CHANGE.toString().equals(value)) {
            this.swc.setAttribute("auto-publish-setting", 2);
        } else {
            this.swc.setAttribute("auto-publish-setting", 1);
        }
    }

    public String readPublishInterval(String defaultVal) {
        if (this.publishInterval == null) {
            String val;
            this.publishInterval = val = this.swc.getAttribute("auto-publish-time", defaultVal);
        }
        return defaultVal.equals(this.publishInterval) ? null : this.publishInterval;
    }

    public void writePublishInterval(String value) {
        this.publishInterval = value;
        this.swc.setAttribute("auto-publish-time", value);
    }

    public void writeServerDisconnected(String value) {
        this.serverDisconnected = Boolean.parseBoolean(value);
    }

    public String readServerDisconnected(String defaultVal) {
        IServer server = this.swc.getOriginal();
        this.serverDisconnected = server.getServerState() != 2;
        return String.valueOf(this.serverDisconnected);
    }

    public String readPublishTimeout(String defaultVal) {
        if (this.publishTimeout == null) {
            String val;
            this.publishTimeout = val = this.swc.getAttribute("deployment_timeout", defaultVal);
        }
        return this.publishTimeout.equals(defaultVal) ? null : this.publishTimeout;
    }

    public void writePublishTimeout(String value) {
        this.publishTimeout = value;
        this.swc.setAttribute("deployment_timeout", value);
    }

    private WeblogicServer getWeblogic() {
        WeblogicServer weblogic = (WeblogicServer)this.getServerWorkingCopy().getAdapter(WeblogicServer.class);
        return weblogic;
    }

    public String readKeystoreType(String defaultValue) {
        KeystoreType type = this.getWeblogic().getKeystoreType();
        return type.toString();
    }

    public String readIdentityStore(String defaultValue) {
        KeystoreType type = this.getWeblogic().getKeystoreType();
        if (type == KeystoreType.DemoIdentityAndDemoTrust) {
            return this.getDemoIdentityStore();
        }
        String path = this.getWeblogic().getCustomIdentityKeystore();
        return path;
    }

    public String readIdentityStorePasswd(String defaultValue) {
        KeystoreType type = this.getWeblogic().getKeystoreType();
        if (type == KeystoreType.DemoIdentityAndDemoTrust) {
            return defaultValue;
        }
        return this.identityStorePasswd;
    }

    public void writeIdentityStorePasswd(String value) {
        this.identityStorePasswd = value;
    }

    public String readTrustStore(String defaultValue) {
        KeystoreType type = this.getWeblogic().getKeystoreType();
        if (type == KeystoreType.DemoIdentityAndDemoTrust || type == KeystoreType.CustomIdentityAndDemoTrust) {
            return this.getDemoTrustStore();
        }
        String path = this.getWeblogic().getCustomTrustKeystore();
        return path;
    }

    public String readTrustStorePasswd(String defaultValue) {
        KeystoreType type = this.getWeblogic().getKeystoreType();
        if (type == KeystoreType.DemoIdentityAndDemoTrust || type == KeystoreType.CustomIdentityAndDemoTrust) {
            return defaultValue;
        }
        return this.trustStorePasswd;
    }

    public void writeTrustStorePasswd(String value) {
        this.trustStorePasswd = value;
    }

    public String getDemoIdentityStore() {
        IRuntime rt = this.getServerWorkingCopy().getRuntime();
        Path p = new Path(String.valueOf(rt.getLocation().toPortableString()) + "/server/lib/DemoIdentity.jks");
        if (p.toFile().exists()) {
            return p.toOSString();
        }
        return null;
    }

    public String getDemoTrustStore() {
        IRuntime rt = this.getServerWorkingCopy().getRuntime();
        Path p = new Path(String.valueOf(rt.getLocation().toPortableString()) + "/server/lib/DemoTrust.jks");
        if (p.toFile().exists()) {
            return p.toOSString();
        }
        return null;
    }

    public String readJavaStandardTrustStore(String defaultValue) {
        IRuntime rt = this.getServerWorkingCopy().getRuntime();
        WeblogicServerRuntime wlsRt = (WeblogicServerRuntime)rt.getAdapter(WeblogicServerRuntime.class);
        File loc = wlsRt.getVMInstall().getInstallLocation();
        Path path = new Path(String.valueOf(loc.getAbsolutePath()) + "/jre/lib/security/cacerts");
        if (path.toFile().exists()) {
            return path.toOSString();
        }
        return defaultValue;
    }

    public String readOwsmKeystore(String defaultValue) {
        IWeblogicServer weblogic = (IWeblogicServer)this.getServerWorkingCopy().getAdapter(IWeblogicServer.class);
        IPath path = weblogic.getDomainPath().append("/config/fmwconfig/default-keystore.jks");
        if (path.toFile().exists()) {
            return path.toOSString();
        }
        return defaultValue;
    }

    public String readOwsmKeystorePasswd(String defaultValue) {
        return this.owsmKeyStorePasswd;
    }

    public void writeOwsmKeystorePasswd(String value) {
        this.owsmKeyStorePasswd = value;
    }
}

