/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.properties;

import oracle.eclipse.tools.weblogic.server.properties.internal.WlxModeEnabler;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;

public interface IStartupProperties
extends Element {
    public static final ElementType TYPE = new ElementType(IStartupProperties.class);
    @Label(standard="launch WebLogic server in Eclipse &console")
    @Type(base=Boolean.class)
    @DefaultValue(text="true")
    @Enablement(expr="${ ServerDisconnected }")
    @Documentation(content="If this option is selected, output from the server console is redirected and displayed in the Eclipse Console view when WLS is started. Otherwise, the WLS output is displayed in its own terminal window.")
    public static final ValueProperty PROP_LAUNCH_IN_CONSOLE = new ValueProperty(TYPE, "LaunchInConsole");
    @Label(standard="always start WebLogic server in &debug mode")
    @Type(base=Boolean.class)
    @DefaultValue(text="false")
    @Enablement(expr="${ ServerDisconnected }")
    @Documentation(content="If this option is selected, WLS is started with the debug flag.")
    public static final ValueProperty PROP_START_IN_DEBUG = new ValueProperty(TYPE, "StartInDebug");
    @Label(standard="start WebLogic server in e&xpress mode")
    @Type(base=Boolean.class)
    @DefaultValue(text="false")
    @Enablement(expr="${ ServerDisconnected }")
    @Service(impl=WlxModeEnabler.class)
    @Documentation(content="If this option is selected, WebLogic Server is started with the '-DserverType=wlx' option that offers a lighter runtime footprint by excluding EJB, JCA, and JMS from being started. This startup mode can result in quicker startup times for WebLogic Server and a smaller resource footprint on the host machine.")
    public static final ValueProperty PROP_EXPRESS_MODE = new ValueProperty(TYPE, "ExpressMode");
    @Label(standard="launch b&rowser after republishing")
    @Type(base=Boolean.class)
    @DefaultValue(text="false")
    @Documentation(content="If you perform a republish from the Servers view, OEPE will launch the Eclipse integrated browser and open the URL of the first web project found on the server.")
    public static final ValueProperty PROP_LAUNCH_BROWSER = new ValueProperty(TYPE, "LaunchBrowser");
    @Type(base=Integer.class)
    @Label(standard="&start (seconds)")
    @DefaultValue(text="480")
    @Enablement(expr="${ ServerDisconnected && ( ServerType == 'LOCAL_SERVER' || ServerType == 'LOCAL_MUTIL_SERVERS' ) }")
    @Documentation(content="Duration in seconds after which OEPE considers the server start operation to have timed out. ")
    public static final ValueProperty PROP_START_TIMEOUT = new ValueProperty(TYPE, "StartTimeout");
    @Type(base=Integer.class)
    @Label(standard="sto&p (seconds)")
    @DefaultValue(text="240")
    @Enablement(expr="${ ServerDisconnected && ( ServerType == 'LOCAL_SERVER' || ServerType == 'LOCAL_MUTIL_SERVERS' ) }")
    @Documentation(content="Duration in seconds after which OEPE considers the server stop operation to have timed out. ")
    public static final ValueProperty PROP_STOP_TIMEOUT = new ValueProperty(TYPE, "StopTimeout");

    public Value<Boolean> isLaunchInConsole();

    public void setLaunchInConsole(String var1);

    public void setLaunchInConsole(Boolean var1);

    public Value<Boolean> isStartInDebug();

    public void setStartInDebug(String var1);

    public void setStartInDebug(Boolean var1);

    public Value<Boolean> isExpressMode();

    public void setExpressMode(String var1);

    public void setExpressMode(Boolean var1);

    public Value<Boolean> isLaunchBrowser();

    public void setLaunchBrowser(String var1);

    public void setLaunchBrowser(Boolean var1);

    public Value<Integer> getStartTimeout();

    public void setStartTimeout(String var1);

    public void setStartTimeout(Integer var1);

    public Value<Integer> getStopTimeout();

    public void setStopTimeout(String var1);

    public void setStopTimeout(Integer var1);
}

