/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.properties;

import oracle.eclipse.tools.weblogic.server.properties.AutoPublishSetting;
import oracle.eclipse.tools.weblogic.server.properties.IModuleDeploymentOptionsModel;
import oracle.eclipse.tools.weblogic.server.properties.IModulePublishingTarget;
import oracle.eclipse.tools.weblogic.server.properties.PublishMode;
import oracle.eclipse.tools.weblogic.server.properties.internal.AutoPublishSettingValidator;
import oracle.eclipse.tools.weblogic.server.properties.internal.DeploymentOptionsValidator;
import oracle.eclipse.tools.weblogic.server.properties.internal.PublishModeValidator;
import oracle.eclipse.tools.weblogic.server.properties.internal.PublishTargetValidator;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.CountConstraint;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.FixedOrderList;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;

public interface IPublishingProperties
extends Element {
    public static final ElementType TYPE = new ElementType(IPublishingProperties.class);
    @Type(base=PublishMode.class)
    @Label(standard="WebLogic Server publishing mode")
    @DefaultValue(text="SPLIT_SOURCE")
    @Service(impl=PublishModeValidator.class)
    @Documentation(content="Virtual application mode: selecting this option ensures that project artifacts run from the workspace with minimal file copying. A standalone web module will be wrapped as part of an auto-generated EAR application.  Exploded archive mode: Project artifacts are copied and deployed from a separate staging area.")
    public static final ValueProperty PROP_PUBLISH_MODE = new ValueProperty(TYPE, "PublishMode");
    @Type(base=AutoPublishSetting.class)
    @DefaultValue(text="NEVER")
    @Service(impl=AutoPublishSettingValidator.class)
    @Documentation(content="Specify settings for automatic publishing to the server. Note that automatic publishing should not typically be used with WebLogic Server.")
    public static final ValueProperty PROP_AUTO_PUBLISH_SETTING = new ValueProperty(TYPE, "AutoPublishSetting");
    @Label(standard="&ignore project build errors when publishing")
    @Type(base=Boolean.class)
    @DefaultValue(text="false")
    @Documentation(content="Specify to continue publishing to Weblogic Server even if there are build or validation errors in the Java EE project being deployed. For example, some XML validators may require a network connection to retrieve external XML schemas, and if the network is down, a validation error may be flagged. If this option is checked, this error will not prevent you from deploying and running the application.")
    public static final ValueProperty PROP_IGNORE_BUILD_ERROR = new ValueProperty(TYPE, "IgnoreBuildError");
    @Type(base=Integer.class)
    @Label(standard="publishing inter&val (seconds)")
    @Enablement(expr="${ AutoPublishSetting == 'AUTO_AFTER_RES_CHANGE' || AutoPublishSetting == 'AUTO_AFTER_BUILD' }")
    @NumericRange(min="0", max="120")
    @DefaultValue(text="15")
    @Documentation(content="Specify settings for automatic publishing interval.")
    public static final ValueProperty PROP_PUBLISH_INTERVAL = new ValueProperty(TYPE, "PublishInterval");
    @Label(standard="module publishing options")
    @Type(base=IModuleDeploymentOptionsModel.class)
    @FixedOrderList
    @Service(impl=DeploymentOptionsValidator.class)
    @Documentation(content="Specify deployment plan used to deplopy the selected Java EE module. Cannot be set when modules are deployed as virtual application.")
    public static final ListProperty PROP_MODULE_DEPLOYMENT_OPTIONS = new ListProperty(TYPE, "ModuleDeploymentOptions");
    @Label(standard="module publishing targets")
    @Type(base=IModulePublishingTarget.class)
    @FixedOrderList
    @CountConstraint(min=1)
    @Service(impl=PublishTargetValidator.class)
    @Documentation(content="Specify deployment targets. Cannot be set when modules are deployed as virtual application.")
    public static final ListProperty PROP_MODULE_PUBLISHING_TARGETS = new ListProperty(TYPE, "ModulePublishingTargets");
    @Type(base=Integer.class)
    @Label(standard="publishing &timeout (minutes)")
    @DefaultValue(text="5")
    @NumericRange(min="1", max="720")
    @Documentation(content="Specify the length of time after which publishing will timeout. Set to5 minutes by default. Increase this value when deploying large-scale Java EE applications that require lengthy running and processing.")
    public static final ValueProperty PROP_PUBLISH_TIMEOUT = new ValueProperty(TYPE, "PublishTimeout");

    public Value<PublishMode> getPublishMode();

    public void setPublishMode(String var1);

    public void setPublishMode(PublishMode var1);

    public Value<AutoPublishSetting> getAutoPublishSetting();

    public void setAutoPublishSetting(String var1);

    public void setAutoPublishSetting(AutoPublishSetting var1);

    public Value<Boolean> isIgnoreBuildError();

    public void setIgnoreBuildError(String var1);

    public void setIgnoreBuildError(Boolean var1);

    public Value<Integer> getPublishInterval();

    public void setPublishInterval(String var1);

    public void setPublishInterval(Integer var1);

    public ElementList<IModuleDeploymentOptionsModel> getModuleDeploymentOptions();

    public ElementList<IModulePublishingTarget> getModulePublishingTargets();

    public Value<Integer> getPublishTimeout();

    public void setPublishTimeout(String var1);

    public void setPublishTimeout(Integer var1);
}

