/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.operations.internal;

import java.util.HashSet;
import java.util.Map;
import oracle.eclipse.tools.weblogic.server.internal.util.DomainTemplateUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.TemplateInfo;
import oracle.eclipse.tools.weblogic.server.operations.ICreateDefaultDomainOp;
import oracle.eclipse.tools.weblogic.server.operations.ICreationTemplate;
import oracle.eclipse.tools.weblogic.server.operations.internal.CreationTemplateValueChangeListener;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class TemplatesValidator
extends ValidationService {
    protected Status compute() {
        if (CreationTemplateValueChangeListener.inAction) {
            return Status.createOkStatus();
        }
        ICreateDefaultDomainOp model = (ICreateDefaultDomainOp)this.context(ICreateDefaultDomainOp.class);
        ElementList list = model.property((ListProperty)this.context(ListProperty.class));
        HashSet<String> existingNames = new HashSet<String>();
        for (ICreationTemplate t : list) {
            String name = t.getName().text();
            if (name == null) continue;
            existingNames.add(name);
        }
        String runtimeId = (String)model.getRuntimeid().content();
        IRuntime rt = ServerCore.findRuntime((String)runtimeId);
        Map<String, TemplateInfo> allTemplates = DomainTemplateUtil.findAllDomainExtensionTemplates(rt);
        for (ICreationTemplate t : list) {
            String name = t.getName().text();
            if (name == null) continue;
            TemplateInfo template = allTemplates.get(name);
            HashSet<TemplateInfo> dependencies = new HashSet<TemplateInfo>();
            DomainTemplateUtil.addDependencies(rt, template, dependencies);
            for (TemplateInfo dep : dependencies) {
                String depname;
                if (!dep.selectable.equals("true") || !"Extension Template".equals(dep.type) || existingNames.contains(depname = dep.getFullName())) continue;
                return Status.createErrorStatus((String)(String.valueOf(name) + " requires " + depname));
            }
        }
        return Status.createOkStatus();
    }
}

