/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.operations.internal;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.WLSTRunnerUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.util.TemplateInfo;
import oracle.eclipse.tools.weblogic.server.operations.IExtendDomainOp;
import oracle.eclipse.tools.weblogic.server.operations.IExtensionTemplate;
import oracle.eclipse.tools.weblogic.server.operations.internal.CreateDefaultDomainOpMethods;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.osgi.framework.Bundle;

public class ExtendDomainOpMethods
extends CreateDefaultDomainOpMethods {
    public static final String NEW_DEFAULT_DOMAIN_SCRIPT = "/wlst.scripts/extend_domain.py";

    public static Status execute(IExtendDomainOp operation, ProgressMonitor monitor) {
        IServer server;
        block12: {
            if (monitor == null) {
                monitor = new ProgressMonitor();
            }
            monitor.beginTask(Resources.executeTaskName, 50);
            String serverId = (String)operation.getServerid().content();
            server = ExtendDomainOpMethods.getServer(serverId);
            if (server != null) break block12;
            Status status = Status.createErrorStatus((String)("Invalid runtime " + serverId));
            monitor.done();
            return status;
        }
        try {
            try {
                if (server.getServerState() != 4) {
                    monitor.setTaskName(Resources.stoppingServer);
                    final boolean[] serverStopped = new boolean[1];
                    server.stop(false, new IServer.IOperationListener(){

                        public void done(IStatus status) {
                            if (status.getCode() == 0) {
                                serverStopped[0] = true;
                            }
                        }
                    });
                    System.out.println(serverStopped[0]);
                    while (!serverStopped[0]) {
                        Thread.sleep(1000L);
                        monitor.worked(1);
                    }
                }
                monitor.setTaskName(Resources.loadingTmeplate);
                String wlHome = server.getRuntime().getLocation().toPortableString();
                String beaHome = new File(wlHome).getParentFile().getAbsolutePath().replace('\\', '/');
                InputStream ios = FileLocator.openStream((Bundle)WlsCorePlugin.getPluginBundle(), (IPath)new Path(NEW_DEFAULT_DOMAIN_SCRIPT), (boolean)false);
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("%BEA_HOME%", beaHome);
                props.put("%WL_HOME%", wlHome);
                WeblogicServer weblogicServer = (WeblogicServer)server.loadAdapter(WeblogicServer.class, null);
                props.put("%DOMAIN_LOCATION%", weblogicServer.getDomainPath().toPortableString());
                StringBuilder sb = new StringBuilder();
                ElementList<IExtensionTemplate> templates = operation.getTemplates();
                if (templates.size() >= 0) {
                    ArrayList<TemplateInfo> list = new ArrayList<TemplateInfo>();
                    for (IExtensionTemplate t : templates) {
                        String location;
                        String name = (String)t.getName().content();
                        TemplateInfo info = CreateDefaultDomainOpMethods.getTemplateInfo(server.getRuntime(), name);
                        String string = location = info != null ? info.location : null;
                        if (location == null || info == null) continue;
                        list.add(info);
                    }
                    Collections.sort(list);
                    for (TemplateInfo info : list) {
                        String location = info.location;
                        if (location == null) continue;
                        sb.append("addTemplate('");
                        sb.append(location);
                        sb.append("')");
                        sb.append("\n");
                        if (!info.getFullName().startsWith("Oracle WSM Policy Manager - File")) continue;
                        ExtendDomainOpMethods.addFileBasedOWSMDomainConfigTemplates(sb, info);
                    }
                    props.put("%ADD_TEMPLATES%", sb.toString());
                    monitor.setTaskName(Resources.executeTaskName);
                    String ret = WLSTRunnerUtil.runWLSTScriptInCommandLine(server.getRuntime(), ios, props, ProgressMonitorBridge.create((ProgressMonitor)monitor));
                    LoggingService.logInfo((String)"oracle.eclipse.tools.weblogic", (String)(String.valueOf(Resources.extendingDomain) + ret));
                }
                monitor.done();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                monitor.done();
            }
        }
        catch (Throwable throwable) {
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return Status.createOkStatus();
    }

    private static IServer getServer(String serverId) {
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (server.getId().equals(serverId)) {
                return server;
            }
            ++n2;
        }
        return null;
    }

    private static final class Resources
    extends NLS {
        public static String executeTaskName;
        public static String loadingTmeplate;
        public static String stoppingServer;
        public static String extendingDomain;

        static {
            Resources.initializeMessages((String)ExtendDomainOpMethods.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

