/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.operations;

import oracle.eclipse.tools.weblogic.server.operations.ICreateDefaultDomainOp;
import oracle.eclipse.tools.weblogic.server.operations.Resources;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class DomainPasswordValidator
extends ValidationService {
    protected void initValidationService() {
        ICreateDefaultDomainOp op = (ICreateDefaultDomainOp)this.context(ICreateDefaultDomainOp.class);
        ValueProperty other = ((Value)this.context(Value.class)).definition() == ICreateDefaultDomainOp.PROP_PASSWORD ? ICreateDefaultDomainOp.PROP_PASSWORD2 : ICreateDefaultDomainOp.PROP_PASSWORD;
        op.property(other).attach((Listener)new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                DomainPasswordValidator.this.refresh();
            }
        });
    }

    protected Status compute() {
        Value value = (Value)this.context(Value.class);
        String password = value.text();
        if (password != null) {
            ICreateDefaultDomainOp model = (ICreateDefaultDomainOp)value.element().nearest(ICreateDefaultDomainOp.class);
            if (password.length() == 0) {
                return Status.createErrorStatus((String)Resources.passwordCannotBeEmpty);
            }
            if (password.length() < 8) {
                return Status.createErrorStatus((String)Resources.passwordLessThanEight);
            }
            if (!this.isAlphanumeric(password)) {
                return Status.createErrorStatus((String)Resources.passwordNotAlphaNumeric);
            }
            if (!this.match(model.getPassword(), model.getPassword2())) {
                return Status.createErrorStatus((String)Resources.passwordNotMatch);
            }
        }
        return Status.createOkStatus();
    }

    private boolean match(Value<String> password, Value<String> password2) {
        String s1 = (String)password.content();
        String s2 = (String)password2.content();
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        return false;
    }

    private boolean isAlphanumeric(String password) {
        boolean hasAlphabetic = false;
        boolean hasNumeric = false;
        boolean hasSpecialChar = false;
        char[] cArray = password.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isLetter(c)) {
                hasAlphabetic = true;
            } else if (Character.isDigit(c)) {
                hasNumeric = true;
            } else {
                if (Character.isWhitespace(c)) {
                    return false;
                }
                hasSpecialChar = true;
            }
            ++n2;
        }
        return hasAlphabetic & hasNumeric || hasAlphabetic & hasSpecialChar;
    }
}

