/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.weblogic.MBeanUtil;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.modules.PublishedModule;
import oracle.eclipse.tools.weblogic.server.modules.WebServiceNode;
import org.eclipse.wst.server.core.IServer;

public class WebServiceRootNode
extends PublishedModule {
    private static final String WS_PATH = "serverRuntime:/ApplicationRuntimes/%s/WseeRuntimes";
    IServer server = null;

    public WebServiceRootNode(PublishedModule parent, IServer server) {
        super("Web Services", "ws", parent);
        this.server = server;
    }

    @Override
    public Object[] getChildren() {
        if (this.childModules == null) {
            this.childModules = new ArrayList();
            String moduleName = this.getParent().label();
            WeblogicServer wls = (WeblogicServer)this.server.getAdapter(WeblogicServer.class);
            String path = String.format(WS_PATH, moduleName);
            List<String> wsNames = MBeanUtil.getChildMBeanNames(wls, path);
            for (String s : wsNames) {
                WebServiceNode node1 = new WebServiceNode(s, this);
                Map<String, String> attributes = MBeanUtil.getMBeanAttributes(wls, String.valueOf(path) + "/" + s);
                String url = attributes.get("URI");
                String protocol = wls.isUseSSLPort() ? "https" : "http";
                String host = wls.getHostname();
                String port = wls.isUseSSLPort() ? "" + wls.getHttpsPort() : "" + wls.getPort();
                String wsdlUrl = String.valueOf(protocol) + "://" + host + ":" + port + url + "?wsdl";
                node1.setWsdlURI(wsdlUrl);
                this.addChild(node1);
            }
        }
        return this.childModules.toArray();
    }
}

