/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.modules;

import java.util.ArrayList;
import oracle.eclipse.tools.weblogic.server.IJ2EEDeploymentHelper;
import oracle.eclipse.tools.weblogic.server.IWlsJMXHelper;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import oracle.eclipse.tools.weblogic.server.modules.PublishedModule;
import oracle.eclipse.tools.weblogic.server.modules.PublishedModuleTarget;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IServer;

public class PublishedModulesRoot
extends PublishedModule {
    protected IServer server = null;
    protected PublishedModuleTarget[] moduleTargets = null;
    private boolean showSharedLibraries = false;
    private boolean showEjbModules = true;
    private boolean showWebModules = true;
    private boolean showEarModules = true;

    public PublishedModulesRoot(IServer server) {
        super("Published Modules", "", server);
        this.server = server;
    }

    public void setShowEarModules(boolean showEarModules) {
        this.showEarModules = showEarModules;
    }

    public void setShowEjbModules(boolean showEjbModules) {
        this.showEjbModules = showEjbModules;
    }

    public void setShowSharedLibraries(boolean showSharedLibraries) {
        this.showSharedLibraries = showSharedLibraries;
    }

    public void setShowWebModules(boolean showWebModules) {
        this.showWebModules = showWebModules;
    }

    public boolean isShowEarModules() {
        return this.showEarModules;
    }

    public boolean isShowEjbModules() {
        return this.showEjbModules;
    }

    public boolean isShowSharedLibraries() {
        return this.showSharedLibraries;
    }

    public boolean isShowWebModules() {
        return this.showWebModules;
    }

    public IServer getServer() {
        return this.server;
    }

    public Object getEditableValue() {
        return null;
    }

    public WeblogicServerBehaviour getWeblogicServerBehavior() {
        return (WeblogicServerBehaviour)this.server.loadAdapter(WeblogicServerBehaviour.class, null);
    }

    @Override
    public Object[] getChildren() {
        ArrayList<PublishedModuleTarget> moduleTargetList = new ArrayList<PublishedModuleTarget>();
        if (this.moduleTargets == null) {
            this.createModuleTargetList(moduleTargetList, (IProgressMonitor)new NullProgressMonitor());
            this.moduleTargets = moduleTargetList.toArray(new PublishedModuleTarget[moduleTargetList.size()]);
        }
        return this.moduleTargets;
    }

    @Override
    public void refresh() {
        this.moduleTargets = null;
    }

    protected void createModuleTargetList(ArrayList<PublishedModuleTarget> list, IProgressMonitor monitor) {
        try {
            PublishedModuleTarget target;
            WeblogicServerBehaviour behaviour = this.getWeblogicServerBehavior();
            if (behaviour == null) {
                return;
            }
            monitor.beginTask("Retrieving published target list from WebLogic server", 100);
            monitor.worked(20);
            monitor.worked(30);
            IJ2EEDeploymentHelper deployHelper = behaviour.getPublisher();
            IWlsJMXHelper jmxHelper = deployHelper.getWlsJMXHelper();
            for (String name : jmxHelper.getServers()) {
                target = new PublishedModuleTarget(this, this.server, name);
                list.add(target);
                monitor.worked(1);
            }
            for (String name : jmxHelper.getClusters().keySet()) {
                target = new PublishedModuleTarget(this, this.server, name);
                list.add(target);
                monitor.worked(1);
            }
            monitor.done();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

