/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.modules;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.server.core.IServer;

public abstract class PublishedModule {
    IServer server = null;
    PublishedModule parent = null;
    String name = null;
    String type = null;
    boolean isSharedLibrary = false;
    protected ArrayList<PublishedModule> childModules = null;

    public PublishedModule(String name, String type, PublishedModule parent) {
        this.parent = parent;
        this.name = name;
        this.type = type;
    }

    public PublishedModule(String name2, String type2, IServer server) {
        this.name = name2;
        this.type = type2;
        this.server = server;
    }

    public String label() {
        return this.name;
    }

    public IServer server() {
        return this.server;
    }

    public String getType() {
        return this.type;
    }

    public void addChild(PublishedModule childModule) {
        if (this.childModules == null) {
            this.childModules = new ArrayList();
        }
        this.childModules.add(childModule);
    }

    public void removeChild(PublishedModule childModule) {
        if (this.childModules != null) {
            this.childModules.remove(childModule);
        }
    }

    public List<PublishedModule> getChildModules() {
        return this.childModules;
    }

    public abstract Object[] getChildren();

    public boolean hasChildren() {
        if (this.childModules == null) {
            return false;
        }
        return this.childModules.size() > 0;
    }

    public void refresh() {
        this.childModules = null;
    }

    public PublishedModule getParent() {
        return this.parent;
    }

    public boolean isSharedLibrary() {
        return this.isSharedLibrary;
    }

    public void setSharedLibrary(boolean isSharedLibrary) {
        this.isSharedLibrary = isSharedLibrary;
    }

    public boolean isReadOnly() {
        return false;
    }
}

