/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.model;

import java.util.List;
import oracle.eclipse.tools.common.util.fileio.FolderUtil;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicModule;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.PublishOperation;

public abstract class WeblogicPublishOperation
extends PublishOperation {
    protected IServer _server;

    public WeblogicPublishOperation(String taskName, String taskDescription, IServer server) {
        super(taskName, taskDescription);
        this._server = server;
    }

    public int getKind() {
        return 2;
    }

    protected void setBuildFolderDerived(IModule module, IProgressMonitor monitor) throws CoreException {
        if (module == null) {
            return;
        }
        IProject project = module.getProject();
        IFolder buildFolder = project.getFolder("build");
        FolderUtil.ensureDerivedFolderExists((IFolder)buildFolder, (IProgressMonitor)monitor);
    }

    public void execute(IProgressMonitor monitor, IAdaptable shell) throws CoreException {
        try {
            String msg = CorePlugin.getString("errorPublishTaskGeneral", this.getLabel());
            MultiStatus multi = CorePlugin.createMultiStatus(msg, null);
            List modules = (List)this.getTaskModel().getObject("weblogic_modules");
            for (IWeblogicModule module : modules) {
                this.processRootModule(module, monitor);
            }
            if (multi.getChildren().length == 1) {
                throw new CoreException(multi.getChildren()[0]);
            }
            if (multi.getChildren().length > 1) {
                throw new CoreException((IStatus)multi);
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            String msg = CorePlugin.getString("errorPublishTaskRuntimeException", this.getLabel());
            throw new CoreException(CorePlugin.createErrorStatus(msg, re));
        }
        catch (CoreException ce) {
            String msg = CorePlugin.getString("errorPublishTaskGeneral", this.getLabel());
            MultiStatus status = CorePlugin.createMultiStatus(msg, ce.getStatus());
            throw new CoreException((IStatus)status);
        }
    }

    protected static boolean hasChanges(IWeblogicModule module) {
        if (WeblogicPublishOperation.hasModuleChanges(module)) {
            return true;
        }
        List<IWeblogicModule> childModules = module.getChildModules();
        for (IWeblogicModule childModule : childModules) {
            if (!WeblogicPublishOperation.hasChanges(childModule)) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasModuleChanges(IWeblogicModule module) {
        if (module.getKind() == 1) {
            return true;
        }
        IModuleResourceDelta[] deltas = module.getResourceDelta();
        return deltas != null && deltas.length > 0;
    }

    protected abstract void processRootModule(IWeblogicModule var1, IProgressMonitor var2) throws CoreException;
}

