/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.server.core.internal.Messages;
import org.eclipse.jst.server.core.internal.ProgressUtil;
import org.eclipse.osgi.util.NLS;

public class FileUtil {
    public static final void copy(IFile source, File file) throws CoreException {
        InputStream is = null;
        FileOutputStream os = null;
        try {
            try {
                is = source.getContents();
                os = new FileOutputStream(file, false);
                byte[] buf = new byte[4096];
                int i = is.read(buf);
                while (i > 0) {
                    ((OutputStream)os).write(buf, 0, i);
                    i = is.read(buf);
                }
            }
            catch (IOException ioe) {
                String msg = CorePlugin.getString("errorPathIOException", new Object[0]);
                throw new CoreException(CorePlugin.createErrorStatus(msg, ioe));
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(is);
            FileUtil.close(os);
            throw throwable;
        }
        FileUtil.close(is);
        FileUtil.close(os);
    }

    public static final void copy(IContainer sourceRoot, File destRoot) throws CoreException {
        sourceRoot.hashCode();
        destRoot.hashCode();
        if (!sourceRoot.exists()) {
            return;
        }
        FileUtil.assertFolder(destRoot);
        LinkedList<Pair> queue = new LinkedList<Pair>();
        queue.add(new Pair((Object)sourceRoot, (Object)destRoot));
        while (!queue.isEmpty()) {
            Pair cur = (Pair)queue.poll();
            IResource[] iResourceArray = ((IContainer)cur.getFirst()).members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (!member.isPhantom()) {
                    IFile source;
                    if (member.getType() == 1) {
                        source = (IFile)member;
                        FileUtil.copy(source, new File((File)cur.getSecond(), source.getName()));
                    } else if (member.getType() == 2) {
                        source = (IFolder)member;
                        File dest = new File((File)cur.getSecond(), source.getName());
                        FileUtil.assertFolder(dest);
                        queue.add(new Pair((Object)source, (Object)dest));
                    }
                }
                ++n2;
            }
        }
    }

    public static void deleteDirectory(File dir, IProgressMonitor monitor) throws CoreException {
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        int size = files.length;
        monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
        monitor.beginTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{dir.getAbsolutePath()}), size * 10);
        int i = 0;
        while (i < size) {
            File current = files[i];
            if (current.isFile()) {
                if (!current.delete()) {
                    String msg = CorePlugin.getString("errorPathDeleteFile", current);
                    throw new CoreException(CorePlugin.createErrorStatus(msg));
                }
                monitor.worked(10);
            } else if (current.isDirectory()) {
                monitor.subTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{current.getAbsolutePath()}));
                FileUtil.deleteDirectory(current, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)10));
            }
            ++i;
        }
        if (!dir.delete()) {
            String msg = CorePlugin.getString("errorPathDelete", dir);
            throw new CoreException(CorePlugin.createErrorStatus(msg));
        }
        monitor.done();
    }

    public static void smartCopy(IResource[] resources, IPath path, IProgressMonitor monitor) throws CoreException {
        int toSize;
        if (resources == null) {
            return;
        }
        File toDir = path.toFile();
        File[] toFiles = toDir.listFiles();
        int fromSize = resources.length;
        if (toDir.exists() && toDir.isDirectory()) {
            toSize = toFiles.length;
            int i = 0;
            while (i < toSize) {
                String name = toFiles[i].getName();
                boolean isDir = toFiles[i].isDirectory();
                boolean found = false;
                int j = 0;
                while (j < fromSize) {
                    if (name.equals(resources[j].getName()) && isDir == resources[j] instanceof IFolder) {
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    if (isDir) {
                        FileUtil.deleteDirectory(toFiles[i], null);
                    } else if (!toFiles[i].delete()) {
                        String msg = CorePlugin.getString("errorPathDeleteFile", toFiles[i]);
                        throw new CoreException(CorePlugin.createErrorStatus(msg));
                    }
                }
                if (monitor.isCanceled()) {
                    return;
                }
                ++i;
            }
        } else {
            if (toDir.isFile() && !toDir.delete()) {
                String msg = CorePlugin.getString("errorPathDeleteFile", toDir);
                throw new CoreException(CorePlugin.createErrorStatus(msg));
            }
            if (!toDir.mkdir()) {
                if (toDir.getPath().length() > 255) {
                    String overLength = CorePlugin.getString("errorFileLength", new Object[0]);
                    IStatus status = CorePlugin.createErrorStatus(overLength);
                    String msg = CorePlugin.getString("errorPathCreate", toDir);
                    throw new CoreException((IStatus)CorePlugin.createMultiStatus(msg, status));
                }
                String msg = CorePlugin.getString("errorPathCreate", toDir);
                throw new CoreException(CorePlugin.createErrorStatus(msg));
            }
        }
        monitor.worked(50);
        toFiles = toDir.listFiles();
        toSize = toFiles.length;
        int dw = 0;
        if (toSize > 0) {
            dw = 500 / toSize;
        }
        int i = 0;
        while (i < fromSize) {
            IResource current = resources[i];
            boolean copy = true;
            boolean currentIsDir = current instanceof IFolder;
            if (!currentIsDir) {
                String name = current.getName();
                File file = path.append(name).toFile();
                if (current.getLocalTimeStamp() < file.lastModified()) {
                    copy = false;
                }
            }
            if (copy) {
                IPath toPath = path.append(current.getName());
                if (!currentIsDir) {
                    IFile mf = (IFile)current;
                    FileUtil.copy(mf, toPath.toFile());
                    monitor.worked(dw);
                } else {
                    IFolder folder = (IFolder)current;
                    IResource[] children = folder.members();
                    monitor.subTask(NLS.bind((String)Messages.copyingTask, (Object[])new String[]{resources[i].getName(), current.getName()}));
                    FileUtil.smartCopy(children, toPath, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)dw));
                }
            }
            if (monitor.isCanceled()) {
                return;
            }
            ++i;
        }
        monitor.worked(500 - dw * toSize);
        monitor.done();
    }

    public static void close(Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
    }

    public static void thrust(File dir) throws CoreException {
        if (dir.exists()) {
            try {
                oracle.eclipse.tools.common.util.fileio.FileUtil.delete((File)dir);
            }
            catch (IOException ioe) {
                String msg = CorePlugin.getString("errorPathClean", dir);
                throw new CoreException(CorePlugin.createErrorStatus(msg, ioe));
            }
        }
        if (!dir.mkdirs()) {
            String msg = CorePlugin.getString("errorPathCreate", dir);
            throw new CoreException(CorePlugin.createErrorStatus(msg));
        }
    }

    private static void assertFolder(File folder) throws CoreException {
        if (!folder.exists()) {
            if (!folder.mkdirs()) {
                String msg = CorePlugin.getString("errorPathCreate", folder);
                throw new CoreException(CorePlugin.createErrorStatus(msg));
            }
        } else if (!folder.isDirectory()) {
            if (folder.delete()) {
                String msg = CorePlugin.getString("errorPathDelete", folder);
                throw new CoreException(CorePlugin.createErrorStatus(msg));
            }
            if (!folder.mkdir()) {
                String msg = CorePlugin.getString("errorPathCreate", folder);
                throw new CoreException(CorePlugin.createErrorStatus(msg));
            }
        }
    }
}

