/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import oracle.eclipse.tools.weblogic.appmodel.IModule;
import oracle.eclipse.tools.weblogic.appmodel.IModuleDependency;
import oracle.eclipse.tools.weblogic.appmodel.IWebLogicJdbcConfigRef;
import oracle.eclipse.tools.weblogic.appmodel.IWebLogicJmsConfigRef;
import oracle.eclipse.tools.weblogic.appmodel.IWorkspaceModel;
import oracle.eclipse.tools.weblogic.appmodel.WorkspaceModelFactory;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.Resources;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicModule;
import oracle.eclipse.tools.weblogic.server.model.WeblogicPublishOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.sapphire.ElementList;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.model.PublishTaskDelegate;

public abstract class WeblogicSystemModulePublishTask
extends PublishTaskDelegate {
    public static final int ID_WARNING_REMOTE_JMS_NOT_SUPPORTED = 5001;
    public static final int ID_WARNING_FOUND_JMS_SUBDEPLOYMENT = 5002;
    protected HashMap<String, String> systemModuleNames = new HashMap();

    public PublishOperation[] getTasks(IServer server, List modules) {
        IWeblogicServer ws = (IWeblogicServer)server.loadAdapter(IWeblogicServer.class, null);
        if (ws == null || modules == null || modules.isEmpty()) {
            return new PublishOperation[0];
        }
        return new PublishOperation[]{new Task(server)};
    }

    protected void deploySystemModule(IServer server, IModuleDependency dep, IProgressMonitor monitor) throws CoreException {
        if (dep instanceof IWebLogicJdbcConfigRef) {
            IWebLogicJdbcConfigRef jdbcConfig = (IWebLogicJdbcConfigRef)dep;
            String cfgName = jdbcConfig.getName().text();
            String name = cfgName.substring(0, cfgName.indexOf("-jdbc.xml"));
            if (this.systemModuleNames.keySet().contains(name)) {
                String msg = String.format(Resources.conflictingName, cfgName, this.systemModuleNames.get(name));
                throw new CoreException(CorePlugin.createErrorStatus(msg));
            }
            this.systemModuleNames.put(name, cfgName);
        } else if (dep instanceof IWebLogicJmsConfigRef) {
            IWebLogicJmsConfigRef jmsConfig = (IWebLogicJmsConfigRef)dep;
            String cfgName = jmsConfig.getName().text();
            String name = cfgName.substring(0, cfgName.indexOf("-jms.xml"));
            if (this.systemModuleNames.keySet().contains(name)) {
                String msg = String.format(Resources.conflictingName, cfgName, this.systemModuleNames.get(name));
                throw new CoreException(CorePlugin.createErrorStatus(msg));
            }
            this.systemModuleNames.put(name, cfgName);
        }
    }

    protected String getTaskName() {
        return Resources.taskName;
    }

    protected String getTaskDescription() {
        return Resources.taskDescription;
    }

    private boolean isModuleAccessible(IWeblogicModule wlModule) {
        return wlModule.getKind() != 3;
    }

    class Task
    extends WeblogicPublishOperation {
        public Task(IServer server) {
            super(WeblogicSystemModulePublishTask.this.getTaskName(), WeblogicSystemModulePublishTask.this.getTaskDescription(), server);
        }

        public int getOrder() {
            return 10;
        }

        @Override
        protected void processRootModule(IWeblogicModule rootWLModule, IProgressMonitor monitor) throws CoreException {
            if (!WeblogicSystemModulePublishTask.this.isModuleAccessible(rootWLModule)) {
                return;
            }
            try {
                org.eclipse.wst.server.core.IModule rootModule = rootWLModule.getModule();
                if (this.isEARModule(rootModule)) {
                    this.processModule(rootWLModule, monitor);
                    List<IWeblogicModule> childModules = rootWLModule.getChildModules();
                    for (IWeblogicModule childModule : childModules) {
                        this.processModule(childModule, monitor);
                    }
                } else {
                    this.processModule(rootWLModule, monitor);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        private boolean isEARModule(org.eclipse.wst.server.core.IModule module) {
            return module.getModuleType().getId().equals("jst.ear");
        }

        protected void processModule(IWeblogicModule wlModule, IProgressMonitor monitor) throws CoreException, IOException {
            if (!WeblogicSystemModulePublishTask.this.isModuleAccessible(wlModule)) {
                return;
            }
            WeblogicSystemModulePublishTask.this.systemModuleNames.clear();
            org.eclipse.wst.server.core.IModule module = wlModule.getModule();
            IProject project = module.getProject();
            WeblogicServerBehaviour behaviour = (WeblogicServerBehaviour)this._server.loadAdapter(WeblogicServerBehaviour.class, null);
            WeblogicServer ws = (WeblogicServer)this._server.loadAdapter(IWeblogicServer.class, null);
            IWorkspaceModel wsmodel = WorkspaceModelFactory.create();
            IModule wsmodule = wsmodel.getModule(project.getName());
            ElementList<IModuleDependency> dependecies = wsmodule.getDependencies();
            if (dependecies.size() == 0) {
                wsmodel.dispose();
                return;
            }
            if (ws.isRemote()) {
                behaviour.addPublishWarnings(5001, Resources.deploySysModuleNotSupportedOnRemoteServer);
                wsmodel.dispose();
                return;
            }
            for (IModuleDependency dep : dependecies) {
                WeblogicSystemModulePublishTask.this.deploySystemModule(this._server, dep, monitor);
            }
            wsmodel.dispose();
        }
    }
}

