/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import oracle.eclipse.tools.common.wtp.core.ServerUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.WlsRuntimeComponentType;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IExternalProcess;
import oracle.eclipse.tools.weblogic.server.IValidatable;
import oracle.eclipse.tools.weblogic.server.IWeblogicDomainConfigurator;
import oracle.eclipse.tools.weblogic.server.IWeblogicDomainUpgrade;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntimeWorkingCopy;
import oracle.eclipse.tools.weblogic.server.internal.DomainConfigurator;
import oracle.eclipse.tools.weblogic.server.internal.Paths;
import oracle.eclipse.tools.weblogic.server.internal.SilentScriptDomainConfigurator;
import oracle.eclipse.tools.weblogic.server.internal.SilentUpgradeDomainConfigurator;
import oracle.eclipse.tools.weblogic.server.internal.UpgradeDomainConfigurator;
import oracle.eclipse.tools.weblogic.server.internal.util.FileUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.ServerLaunchUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.launching.StandardVM;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.model.RuntimeDelegate;

public class WeblogicServerRuntime
extends RuntimeDelegate
implements IWeblogicServerRuntimeWorkingCopy,
IValidatable {
    protected static final String WL_RUNTIME_VM_TYPE = "wl-vm-install-type-id";
    protected static final String WL_RUNTIME_VM_ID = "wl-vm-install-id";
    protected static final String WL_RUNTIME_VM_ENTRY = "wl-vm-classpath";
    private static final String JAR_PROPERTIES = "oracle/eclipse/tools/weblogic/server/internal/runtime-jars.properties";
    private static final Properties JAR_PATHS_PROP = WeblogicServerRuntime.initalizeJarPathsProperties();
    private static final String WL_PATCH_PROFILE = "wl-patch-profile";
    private static final String WL_JAVA_HOME = "wl-java-home";

    public WebLogicServerInstall getWebLogicServerInstall() {
        IRuntime runtime = this.getRuntime();
        IPath location = runtime.getLocation();
        if (location != null) {
            return new WebLogicServerInstall(location.toFile());
        }
        return null;
    }

    @Override
    public IStatus validateEclipseEnv() {
        WebLogicServerInstall install = this.getWebLogicServerInstall();
        if (install != null && install.isValid() && install.getVersion().compareTo(WebLogicServerVersion.VERSION_10_3_0) >= 0 && (double)ServerLaunchUtils.getEclipseVMVersion().floatValue() < 1.6) {
            String msg = NLS.bind((String)Resources.cannotUseEssexOnOlderVm, (Object)this.getRuntime().getRuntimeType().getName());
            return CorePlugin.createErrorStatus(msg);
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus validate() {
        IPath root;
        IStatus status = this.validateEclipseEnv();
        if (status.isOK()) {
            status = super.validate();
        }
        if (status.isOK()) {
            IRuntime runtime = this.getRuntime();
            File wlhome = runtime.getLocation().toFile();
            IRuntimeComponentVersion rcvExpected = WlsRuntimeComponentType.convert(runtime.getRuntimeType());
            IRuntimeComponentVersion rcvActual = WlsRuntimeComponentType.detectVersion(wlhome);
            if (rcvActual == null) {
                String msg = Resources.bind((String)Resources.invalidWebLogicHome, (Object)wlhome.getAbsolutePath());
                return CorePlugin.createErrorStatus(msg);
            }
            if (rcvActual != rcvExpected) {
                String msg = Resources.bind(Resources.wrongWebLogicVersion, wlhome.getAbsolutePath(), rcvExpected.getVersionString(), rcvActual.getVersionString());
                return CorePlugin.createErrorStatus(msg);
            }
        }
        if (status.isOK() && (status = WeblogicServerRuntime.validateWeblogicRuntime(root = this.getRuntime().getLocation())).isOK()) {
            IPath vmPath = this.getJavaVmLocation();
            status = this.validateVMPath(vmPath);
            this.getVMInstall();
            if (status.isOK()) {
                return CorePlugin.STATUS_OK;
            }
        }
        return status;
    }

    private static IStatus validateWeblogicRuntime(IPath root) {
        IStatus status = Paths.validateDirectory(root);
        if (!status.isOK()) {
            return status;
        }
        status = WeblogicServerRuntime.validateRequiredFiles(root);
        if (!status.isOK()) {
            String msg = CorePlugin.getString("errorRuntimeInvalidLocation", root.toOSString());
            MultiStatus result = CorePlugin.createMultiStatus(msg, status);
            return result;
        }
        return CorePlugin.STATUS_OK;
    }

    private static IStatus validateRequiredFiles(IPath path) {
        IStatus status = Paths.verifyExists(path, JAR_PATHS_PROP, "required.dir");
        if (!status.isOK()) {
            return status;
        }
        status = CorePlugin.IS_WINDOWS ? Paths.verifyExists(path, JAR_PATHS_PROP, "required.win.dir") : Paths.verifyExists(path, JAR_PATHS_PROP, "required.unix.dir");
        if (!status.isOK()) {
            return status;
        }
        status = CorePlugin.IS_WINDOWS ? Paths.verifyExists(path, JAR_PATHS_PROP, "required.win.file") : Paths.verifyExists(path, JAR_PATHS_PROP, "required.unix.file");
        if (!status.isOK()) {
            return status;
        }
        status = Paths.verifyExists(path, JAR_PATHS_PROP, "required.file");
        if (!status.isOK()) {
            return status;
        }
        return CorePlugin.STATUS_OK;
    }

    private IStatus validateVMPath(IPath path) {
        if (path == null || path.isEmpty()) {
            String msg = CorePlugin.getString("msgRuntimeJRENotFound", new Object[0]);
            return CorePlugin.createErrorStatus(msg);
        }
        if (!path.toFile().exists()) {
            String msg = CorePlugin.getString("msgRuntimeJREInvalidPath", new Object[0]);
            return CorePlugin.createErrorStatus(msg);
        }
        File vmInstallLocation = path.toFile();
        File javaExe = StandardVMType.findJavaExecutable((File)vmInstallLocation);
        if (javaExe == null) {
            IStatus invalidJvmStatus = WlsCorePlugin.createErrorStatus(Resources.invalidJavaHome);
            return invalidJvmStatus;
        }
        IVMInstallType type = JavaRuntime.getDefaultVMInstall().getVMInstallType();
        if (type != null) {
            String vmId = "StandardVM " + System.currentTimeMillis();
            IVMInstall vm = this.findVMInstall(type, vmInstallLocation);
            StandardVM svm = null;
            if (vm == null) {
                VMStandin vmWorkingCopy = new VMStandin(type, vmId);
                vmWorkingCopy.setName(vmId);
                vmWorkingCopy.setInstallLocation(vmInstallLocation);
                vm = vmWorkingCopy.convertToRealVM();
                if (vm instanceof StandardVM) {
                    svm = (StandardVM)vm;
                }
            } else if (vm instanceof StandardVM) {
                svm = (StandardVM)vm;
            }
            if (svm != null) {
                String version = svm.getJavaVersion();
                WebLogicServerVersion wlsVersion = this.getWebLogicServerInstall().getVersion();
                boolean isSupported = wlsVersion.canSupportJVM(version);
                if (!isSupported) {
                    String msg = Resources.bind((String)Resources.invalidJavaVersion, (Object)version);
                    IStatus invalidJvmStatus = WlsCorePlugin.createErrorStatus(msg);
                    if (vm.getId().equals(vmId)) {
                        type.disposeVMInstall(vmId);
                    }
                    return invalidJvmStatus;
                }
                if (vm.getId().equals(vmId)) {
                    type.disposeVMInstall(vmId);
                }
            }
        }
        return CorePlugin.STATUS_OK;
    }

    private IVMInstall findVMInstall(IVMInstallType type, File vmInstallLocation) {
        IVMInstall[] iVMInstallArray = type.getVMInstalls();
        int n = iVMInstallArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstall x = iVMInstallArray[n2];
            if (x.getInstallLocation().equals(vmInstallLocation)) {
                return x;
            }
            ++n2;
        }
        return null;
    }

    private static Properties initalizeJarPathsProperties() {
        Properties properties;
        InputStream is = null;
        try {
            is = WeblogicServerRuntime.class.getClassLoader().getResourceAsStream(JAR_PROPERTIES);
            Properties prop = new Properties();
            prop.load(is);
            properties = prop;
        }
        catch (IOException iOException) {
            try {
                String msg = CorePlugin.getString("errorRuntimeLoadJarProperties", JAR_PROPERTIES);
                throw new RuntimeException(msg);
            }
            catch (Throwable throwable) {
                FileUtil.close(is);
                throw throwable;
            }
        }
        FileUtil.close(is);
        return properties;
    }

    public void setDefaults(IProgressMonitor monitor) {
        IRuntimeWorkingCopy rwc = this.getRuntimeWorkingCopy();
        rwc.setName(ServerUtil.createDefaultRuntimeName((IRuntimeType)rwc.getRuntimeType()));
        String wlHome = System.getProperties().getProperty("weblogic.home");
        if (wlHome != null && wlHome.length() != 0) {
            IRuntimeComponentVersion expectedVersion = WlsRuntimeComponentType.convert(rwc.getRuntimeType());
            IRuntimeComponentVersion foundVersion = WlsRuntimeComponentType.detectVersion(new File(wlHome));
            if (foundVersion != null && foundVersion == expectedVersion) {
                rwc.setLocation((IPath)new Path(wlHome));
            }
        }
    }

    public static Properties getWeblogicJARPaths() {
        return JAR_PATHS_PROP;
    }

    @Override
    public IPath getDefaultJavaVmLocation() {
        return WeblogicServerRuntime.getDefaultJavaVmLocation(this.getRuntime());
    }

    public static IPath getDefaultJavaVmLocation(IRuntime runtime) {
        IPath path = runtime.getLocation();
        if (path == null || !path.toFile().exists()) {
            return null;
        }
        String vmLocationStr = WeblogicServerRuntime.getProperty(runtime, "JAVA_HOME");
        if (vmLocationStr != null) {
            Path vmLocation = new Path(vmLocationStr);
            try {
                vmLocation = new Path(vmLocation.toFile().getCanonicalPath());
            }
            catch (IOException e) {
                WlsCorePlugin.logException(e);
            }
            return vmLocation;
        }
        return null;
    }

    public static String getProperty(IRuntime runtime, String propName) {
        FileInputStream fis = null;
        try {
            IRuntimeType rtype = runtime.getRuntimeType();
            IPath path = runtime.getLocation();
            if (path == null || !path.toFile().exists()) {
                return null;
            }
            String propFileName = rtype == IWeblogicServerRuntime.RUNTIME_TYPE_8_1 || rtype == IWeblogicServerRuntime.RUNTIME_TYPE_9_0 || rtype == IWeblogicServerRuntime.RUNTIME_TYPE_9_1 || rtype == IWeblogicServerRuntime.RUNTIME_TYPE_9_2 ? "common/lib/platform.properties" : ".product.properties";
            Properties prop = new Properties();
            IPath filePath = path.append(propFileName);
            File file = filePath.toFile();
            if (!file.exists()) {
                return null;
            }
            fis = new FileInputStream(file);
            prop.load(fis);
            String string = prop.getProperty(propName, null);
            FileUtil.close(fis);
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            FileUtil.close(fis);
        }
        return null;
    }

    public static Properties getProductProperties(File wlhome) {
        FileInputStream fis = null;
        try {
            WebLogicServerVersion ver = WebLogicServerVersion.detect(wlhome);
            String propFileName = ver.compareTo(WebLogicServerVersion.VERSION_9_2) > 0 ? ".product.properties" : "common/lib/platform.properties";
            Properties prop = new Properties();
            File file = new File(wlhome, propFileName);
            if (!file.exists()) {
                return null;
            }
            fis = new FileInputStream(file);
            prop.load(fis);
            Properties properties = prop;
            FileUtil.close(fis);
            return properties;
        }
        catch (IOException iOException) {
        }
        finally {
            FileUtil.close(fis);
        }
        return null;
    }

    @Override
    public IPath getJavaVmLocation() {
        String javaHomeStr = this.getAttribute(WL_JAVA_HOME, null);
        if (javaHomeStr != null) {
            return new Path(javaHomeStr);
        }
        return this.getDefaultJavaVmLocation();
    }

    @Override
    public void setJavaVmLocation(IPath path) {
        this.setAttribute(WL_JAVA_HOME, path == null ? null : path.toOSString());
    }

    @Override
    public IPath getJavaVmClasspathEntry() {
        String path = this.getAttribute(WL_RUNTIME_VM_TYPE, null);
        if (path != null) {
            return new Path(path);
        }
        return null;
    }

    public IVMInstall getVMInstall() {
        return WeblogicServerRuntime.getVMInstall(this.getRuntime(), this.getJavaVmLocation());
    }

    public static IVMInstall getVMInstall(IRuntime runtime, IPath javaVmLocation) {
        IVMInstall vm = null;
        IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
        if (vmInstall == null) {
            return null;
        }
        IVMInstallType type = vmInstall.getVMInstallType();
        String vmId = String.valueOf(runtime.getId()) + " JRE";
        if (javaVmLocation != null) {
            IVMInstall[] iVMInstallArray = type.getVMInstalls();
            int n = iVMInstallArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstall x = iVMInstallArray[n2];
                if (new Path(x.getInstallLocation().getAbsolutePath()).equals((Object)javaVmLocation) && x.getName().equals(vmId)) {
                    vm = x;
                    break;
                }
                ++n2;
            }
            if (vm == null) {
                File vmLocation;
                block8: {
                    type.disposeVMInstall(vmId);
                    vmLocation = new File(javaVmLocation.toOSString());
                    if (vmLocation.exists()) break block8;
                    return null;
                }
                try {
                    VMStandin vmWorkingCopy = new VMStandin(type, vmId);
                    vmWorkingCopy.setName(vmId);
                    vmWorkingCopy.setInstallLocation(vmLocation);
                    vm = vmWorkingCopy.convertToRealVM();
                    JavaRuntime.saveVMConfiguration();
                    JavaRuntime.getDefaultVMInstall();
                }
                catch (CoreException ce) {
                    String msg = CorePlugin.getString("errorRuntimeJVMSave", new Object[0]);
                    MultiStatus multi = CorePlugin.createMultiStatus(msg, ce.getStatus());
                    CorePlugin.getLevelLog().log((IStatus)multi);
                }
            }
        }
        return vm;
    }

    public boolean isUsingDefaultJRE() {
        return false;
    }

    @Override
    public IWeblogicDomainConfigurator createSilentScriptDomainConfigurator(IProgressMonitor monitor) {
        SilentScriptDomainConfigurator configurator = new SilentScriptDomainConfigurator();
        configurator.initialize(this.getRuntime(), monitor);
        return configurator;
    }

    @Override
    public IExternalProcess createDomainConfigurator(IProgressMonitor monitor) {
        DomainConfigurator configurator = new DomainConfigurator();
        configurator.initialize(this.getRuntime(), monitor);
        return configurator;
    }

    @Override
    public IWeblogicDomainUpgrade createSilentDomainUpgrade(IProgressMonitor monitor) {
        SilentUpgradeDomainConfigurator configurator = new SilentUpgradeDomainConfigurator();
        configurator.initialize(this.getRuntime(), monitor);
        return configurator;
    }

    @Override
    public IWeblogicDomainUpgrade createDomainUpgrade(IProgressMonitor monitor) {
        UpgradeDomainConfigurator configurator = new UpgradeDomainConfigurator();
        configurator.initialize(this.getRuntime(), monitor);
        return configurator;
    }

    @Override
    public String getPatchProfile() {
        String profile = this.getAttribute(WL_PATCH_PROFILE, null);
        if (profile == null || !this.getPossiblePatchProfiles().contains(profile)) {
            profile = "default";
        }
        return profile;
    }

    @Override
    public void setPatchProfile(String profile) {
        this.setAttribute(WL_PATCH_PROFILE, profile);
    }

    @Override
    public List<String> getPossiblePatchProfiles() {
        WebLogicServerInstall install = this.getWebLogicServerInstall();
        if (install != null && install.isValid()) {
            return install.getPatchProfiles();
        }
        return Collections.emptyList();
    }

    @Override
    public IPath getPatchProfileJarPath() {
        File location;
        String patchProfile;
        WebLogicServerInstall install = this.getWebLogicServerInstall();
        if (install != null && install.isValid() && (patchProfile = this.getPatchProfile()) != null && (location = install.getPatchProfileJarLocation(patchProfile)) != null) {
            return new Path(location.getAbsolutePath());
        }
        return null;
    }

    private static final class Resources
    extends NLS {
        public static String invalidWebLogicHome;
        public static String wrongWebLogicVersion;
        public static String cannotUseEssexOnOlderVm;
        public static String invalidJavaHome;
        public static String invalidJavaVersion;

        static {
            Resources.initializeMessages((String)WeblogicServerRuntime.class.getName(), Resources.class);
        }

        private Resources() {
        }

        public static final String bind(String msg, String ... args) {
            return NLS.bind((String)msg, (Object[])args);
        }
    }
}

