/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.net.URL;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.UrlPathEncoder;
import oracle.eclipse.tools.weblogic.server.internal.util.FacetUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.ServerLaunchUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.server.core.Servlet;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.LaunchableAdapterDelegate;
import org.eclipse.wst.server.core.util.HttpLaunchable;
import org.eclipse.wst.server.core.util.WebResource;

public class WeblogicServerLaunchableAdapterDelegate
extends LaunchableAdapterDelegate {
    private CorePlugin.LevelLog log = CorePlugin.getLevelLog();

    public Object getLaunchable(IServer server, IModuleArtifact moduleObject) throws CoreException {
        WebResource resource;
        String path;
        URL url;
        block15: {
            IURLProvider delegate;
            block14: {
                if (server == null) {
                    return null;
                }
                String serverTypeId = server.getServerType().getId();
                if (!serverTypeId.startsWith("com.bea.wlw.server") && !serverTypeId.startsWith("com.bea.weblogic")) {
                    return null;
                }
                IWeblogicServer weblogic = (IWeblogicServer)server.loadAdapter(IWeblogicServer.class, (IProgressMonitor)new NullProgressMonitor());
                if (weblogic == null) {
                    return null;
                }
                if (!(moduleObject instanceof Servlet) && !(moduleObject instanceof WebResource)) {
                    return null;
                }
                IFacetedProject facetProject = ProjectFacetsManager.create((IProject)moduleObject.getModule().getProject());
                if (!facetProject.hasProjectFacet(FacetUtil.FACET_JST_WEB)) {
                    return null;
                }
                ServerLaunchUtils.setModuleToLaunch(server, moduleObject.getModule());
                try {
                    delegate = (IURLProvider)server.loadAdapter(IURLProvider.class, null);
                    if (delegate != null) break block14;
                    return null;
                }
                catch (Exception e) {
                    this.log.log(CorePlugin.createErrorStatus("Error getting URL for " + moduleObject, e));
                    return null;
                }
            }
            url = delegate.getModuleRootURL(moduleObject.getModule());
            if (url != null) break block15;
            return null;
        }
        if (moduleObject instanceof Servlet) {
            String path2;
            String base;
            Servlet servlet = (Servlet)moduleObject;
            if (servlet.getAlias() != null) {
                base = this.normalize(url.getFile());
                path2 = this.normalize(servlet.getAlias());
                url = new URL(url, String.valueOf(base) + path2);
            } else {
                base = "/servlet";
                path2 = servlet.getServletClassName();
            }
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), String.valueOf(base) + path2);
        } else if (moduleObject instanceof WebResource && (path = this.normalize((resource = (WebResource)moduleObject).getPath().toPortableString())).length() != 0) {
            String base = this.normalize(url.getFile());
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), String.valueOf(base) + path);
        }
        return new HttpLaunchable(new UrlPathEncoder(url).asURL());
    }

    private String normalize(String path) {
        if (path == null) {
            return "";
        }
        if (path.equals("/")) {
            return "";
        }
        if (path.length() > 0 && path.endsWith("/")) {
            return path.substring(0, path.length() - 2);
        }
        if (path.length() > 0 && !path.startsWith("/")) {
            return "/" + path;
        }
        return path;
    }
}

