/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.eclipse.tools.common.wtp.core.ServerUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.appmodel.IModule;
import oracle.eclipse.tools.weblogic.appmodel.IModuleDependency;
import oracle.eclipse.tools.weblogic.appmodel.IWebLogicJdbcConfigRef;
import oracle.eclipse.tools.weblogic.appmodel.IWebLogicJmsConfigRef;
import oracle.eclipse.tools.weblogic.appmodel.IWorkspaceModel;
import oracle.eclipse.tools.weblogic.appmodel.WorkspaceModelFactory;
import oracle.eclipse.tools.weblogic.descriptors.IModuleDefinition;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.CredentialInfo;
import oracle.eclipse.tools.weblogic.server.IJ2EEDeploymentHelper;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerDebugSupport;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerDeployment;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerLaunchConfiguration;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import oracle.eclipse.tools.weblogic.server.IWlsAdapterListener;
import oracle.eclipse.tools.weblogic.server.IWlsDeployRuntime;
import oracle.eclipse.tools.weblogic.server.IWlsJMXHelper;
import oracle.eclipse.tools.weblogic.server.IWlsRunnable;
import oracle.eclipse.tools.weblogic.server.ServerInfo;
import oracle.eclipse.tools.weblogic.server.WlsDeployRuntimeFactory;
import oracle.eclipse.tools.weblogic.server.debugger.WeblogicDebugTarget;
import oracle.eclipse.tools.weblogic.server.internal.ClassloaderStructureHelper;
import oracle.eclipse.tools.weblogic.server.internal.IServerStateListener;
import oracle.eclipse.tools.weblogic.server.internal.JDBCSystemModulePublishTask;
import oracle.eclipse.tools.weblogic.server.internal.JMSSystemModulePublishTask;
import oracle.eclipse.tools.weblogic.server.internal.ServerWatcher;
import oracle.eclipse.tools.weblogic.server.internal.Trace;
import oracle.eclipse.tools.weblogic.server.internal.WebProjectContentUpdater;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicDeployableModule;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicEARModule;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicModule;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicStandaloneEJBModule;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicStandaloneGARModule;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicStandaloneWARModule;
import oracle.eclipse.tools.weblogic.server.internal.util.FacetUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.FileUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.ModuleUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.ServerLaunchUtils;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicDeployableModule;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicModule;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.jdt.internal.launching.JavaRemoteApplicationLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.ElementList;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.DeletedModule;
import org.eclipse.wst.server.core.internal.IModuleVisitor;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ModuleResourceDelta;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.util.ProjectModule;

public class WeblogicServerBehaviour
extends ServerBehaviourDelegate
implements IWeblogicServerDeployment,
IServerStateListener,
IServerLifecycleListener,
IResourceChangeListener {
    private static final long TIMEOUT_STOPPING_SERVER = 480000L;
    private static final int TIMEOUT_PING_SERVER = 5000;
    private static final int SLEEP_TIME = 500;
    protected static final int STOP_WORK_TICKS = 30000;
    protected static final int LAUNCH_WORK_TICKS = 60000;
    protected static final int ATTACH_WORK_TICKS = 10000;
    private static String[] EMPTY_STRINGS = new String[0];
    private static final String DEPLOY_FOLDER = "beadep";
    private static String[] PATTERNS_AUTO_DEPLOY_FILE;
    private static JavaRemoteApplicationLaunchConfigurationDelegate REMOTE_JAVA_APP_LAUNCH_DELEGATE;
    private ILaunchConfigurationDelegate debuggerLaunchConfigurationDelegate = null;
    private transient ServerWatcher watcher;
    private transient Job stateUpdater;
    private transient IJ2EEDeploymentHelper publishHelper = null;
    private transient IServer server;
    private transient ILaunch launch;
    private final WebProjectContentUpdater webProjectContentUpdater;
    private boolean updateStandaloneWebApps = true;
    private boolean isServerAlive = false;
    private boolean isRemoteDebugging = false;
    private boolean isLaunchInIDE = false;
    private boolean deployInSplitSrcMode = true;
    protected boolean isRestarting = false;
    protected boolean surpassNoWebModuleWarning = false;
    ILaunchConfigurationWorkingCopy workingLaunchConfig = null;
    IProgressMonitor launchMonitor = null;
    boolean isNeedsRestart = false;
    private TreeMap<Integer, String> publishWarnings = new TreeMap();

    static {
        REMOTE_JAVA_APP_LAUNCH_DELEGATE = new JavaRemoteApplicationLaunchConfigurationDelegate();
    }

    public WeblogicServerBehaviour() {
        this.webProjectContentUpdater = new WebProjectContentUpdater(this);
    }

    public void initialize(IProgressMonitor monitor) {
        this.getWeblogicServer();
        this.server = this.getServer();
        this.stateUpdater = new StateUpdateJob();
        this.watcher = new ServerWatcher(this);
        this.updateStandaloneWebApps = this.getAutoDeployPatterns().length > 0;
        Thread startWatcherThread = new Thread("Starting Weblogic server watcher"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IServer iServer = WeblogicServerBehaviour.this.server;
                synchronized (iServer) {
                    WeblogicServerBehaviour.this.watcher.startWatcher();
                    WeblogicServerBehaviour.this.watcher.addServerStateListeners(WeblogicServerBehaviour.this);
                }
            }
        };
        startWatcherThread.start();
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        IWlsAdapterListener adapter = WlsRuntimeUtil.getWlsAdapter();
        if (adapter != null) {
            adapter.serverStart(this);
        }
    }

    public void dispose() {
        if (this.publishHelper != null) {
            this.publishHelper.disconnect();
        }
        super.dispose();
        if (this.watcher != null && this.watcher.isWatcherStarted()) {
            this.watcher.stopWatcher();
        }
        this.watcher = null;
        this.disconnectDebugger();
    }

    public void handleResourceChange() {
        IModuleVisitor visitor = new IModuleVisitor(){

            public boolean visit(org.eclipse.wst.server.core.IModule[] module) {
                int size = module.length;
                org.eclipse.wst.server.core.IModule m = module[size - 1];
                if (m.getProject() == null) {
                    return true;
                }
                if (WeblogicServerBehaviour.this.getWeblogicServer().isRemote()) {
                    WeblogicServerBehaviour.this.updateRootModulePublishState(module);
                    return true;
                }
                try {
                    if (ModuleUtil.isWebModule(m) || ModuleUtil.isEARModule(m)) {
                        if (((Server)WeblogicServerBehaviour.this.server).hasPublishedResourceDelta(module)) {
                            if (!WeblogicServerBehaviour.this.deployInSplitSrcMode && WeblogicServerBehaviour.this.updateStandaloneWebApps) {
                                boolean onlyStaticChanges = WeblogicServerBehaviour.this.webProjectContentUpdater.processModuleChange(module);
                                if (!onlyStaticChanges) {
                                    ((Server)WeblogicServerBehaviour.this.server).setModulePublishState(new org.eclipse.wst.server.core.IModule[]{module[0]}, 3);
                                }
                            } else {
                                WeblogicServerBehaviour.this.updateRootModulePublishState(module);
                            }
                        }
                    } else {
                        WeblogicServerBehaviour.this.updateRootModulePublishState(module);
                    }
                }
                catch (Exception e) {
                    CorePlugin.getLevelLog().logDebug(CorePlugin.createErrorStatus("Weblogic Server handleResourceChange", e));
                }
                return true;
            }
        };
        ((Server)this.server).visit(visitor, null);
    }

    private void updateRootModulePublishState(org.eclipse.wst.server.core.IModule[] module) {
        if (((Server)this.server).hasPublishedResourceDelta(module)) {
            ((Server)this.server).setModulePublishState(new org.eclipse.wst.server.core.IModule[]{module[0]}, 3);
        }
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy launchConfig, IProgressMonitor monitor) throws CoreException {
        boolean val;
        super.setupLaunchConfiguration(launchConfig, monitor);
        IWeblogicServerLaunchConfiguration launch = WeblogicServerBehaviour.getWeblogicServerLaunchConfiguration((ILaunchConfiguration)launchConfig);
        if (launch != null) {
            launch.setDefaults(launchConfig);
            launch.setServer(launchConfig, this.getServer());
        }
        this.workingLaunchConfig = launchConfig;
        ServerWorkingCopy swc = (ServerWorkingCopy)this.server.createWorkingCopy();
        this.deployInSplitSrcMode = val = swc.getAttribute("RUN_WEB_MODULE_FROM_WORKSPACE", true);
        this.surpassNoWebModuleWarning = false;
    }

    public void serverAdded(IServer server) {
    }

    public void serverChanged(IServer server) {
    }

    public void serverRemoved(IServer server) {
        if (this.server != server) {
            return;
        }
        if (this.watcher != null) {
            this.watcher.stopWatcher();
        }
        try {
            ILaunchConfiguration[] cfgs;
            LaunchConfiguration lcfg = (LaunchConfiguration)this.getLaunchConfiguration();
            if (lcfg != null) {
                lcfg.delete();
            }
            String ID = "org.eclipse.jst.server.generic.core.launchConfigurationType";
            ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(ID);
            ILaunchConfiguration[] iLaunchConfigurationArray = cfgs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
            int n = cfgs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration cfg = iLaunchConfigurationArray[n2];
                String serverId = cfg.getAttribute("server-id", "");
                if (serverId.equals(server.getId())) {
                    cfg.delete();
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
    }

    private void disconnectDebugger() {
        if (this.launch != null) {
            IDebugTarget[] debugTargets = this.launch.getDebugTargets();
            int i = 0;
            while (i < debugTargets.length) {
                IDebugTarget target = debugTargets[i];
                if (target.canDisconnect()) {
                    try {
                        target.disconnect();
                    }
                    catch (DebugException debugException) {}
                }
                ++i;
            }
        }
    }

    public WeblogicServer getWeblogicServer() {
        return (WeblogicServer)this.getServer().loadAdapter(WeblogicServer.class, null);
    }

    public ServerInfo getServerInfo() {
        return this.getWeblogicServer().getServerInfo();
    }

    protected CredentialInfo getCredentialInfo() {
        return this.getWeblogicServer().getCredentialInfo();
    }

    public synchronized IJ2EEDeploymentHelper getPublisher() {
        if (this.publishHelper == null) {
            this.publishHelper = this.createPublisher();
        }
        return this.publishHelper;
    }

    private IJ2EEDeploymentHelper createPublisher() {
        IRuntime runtime;
        IJ2EEDeploymentHelper h;
        block6: {
            IWlsDeployRuntime wlsDeployRuntime;
            block5: {
                h = null;
                runtime = this.server.getRuntime();
                wlsDeployRuntime = WlsDeployRuntimeFactory.create(runtime);
                if (wlsDeployRuntime != null) break block5;
                CorePlugin.getLevelLog().logDebug(CorePlugin.createInfoStatus("Cannot load DeploymentManager for " + runtime.toString()));
                return null;
            }
            boolean debugClassLoader = false;
            if (debugClassLoader) {
                ClassLoader pluginClassLoader = Thread.currentThread().getContextClassLoader();
                System.out.println(pluginClassLoader);
                ClassLoader wlsJarLoader = wlsDeployRuntime.getClass().getClassLoader();
                System.out.println(wlsJarLoader);
            }
            if ((h = wlsDeployRuntime.getJ2EEDeploymentHelper()) != null) break block6;
            CorePlugin.getLevelLog().logDebug(CorePlugin.createInfoStatus("Cannot load DeploymentManager for " + runtime.toString()));
            return null;
        }
        try {
            h.initialize(this.getWeblogicServer());
        }
        catch (Throwable e) {
            CorePlugin.getLevelLog().logInfo(CorePlugin.createErrorStatus("Cannot load DeploymentManager for " + runtime.toString(), e));
        }
        return h;
    }

    public void publishStart(IProgressMonitor monitor) throws CoreException {
        IStatus validated;
        this.publishWarnings.clear();
        IWlsAdapterListener adapter = WlsRuntimeUtil.getWlsAdapter();
        if (adapter != null) {
            adapter.publishStarted(this, monitor);
            if (monitor.isCanceled()) {
                return;
            }
        }
        if (!(validated = this.validateConfiguration()).isOK()) {
            String msg = CorePlugin.getString("errorPublishNotReady", new Object[0]);
            MultiStatus status = CorePlugin.createMultiStatus(msg, validated);
            throw new CoreException((IStatus)status);
        }
        this.publishHelper = this.getPublisher();
        if (this.publishHelper != null) {
            this.publishHelper.deployStart(monitor);
        }
    }

    public void publishFinish(IProgressMonitor monitor) throws CoreException {
        if (this.publishHelper != null) {
            this.getPublisher().deployFinish(monitor);
        }
        ServerWorkingCopy swc = (ServerWorkingCopy)this.server.createWorkingCopy();
        boolean launchBrowser = swc.getAttribute("LAUNCH_BROWSER_AFTER_START", false);
        IWlsAdapterListener adapter = WlsRuntimeUtil.getWlsAdapter();
        if (adapter != null) {
            adapter.publishFinished(this, launchBrowser);
        }
    }

    public ILaunchConfiguration getWorkingLaunchConfiguration() {
        return this.workingLaunchConfig;
    }

    public IStatus publish(int kind, IProgressMonitor monitor) {
        try {
            Trace.trace("/finest", "Calling publishStart()");
            try {
                this.publishStart(ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)1000));
            }
            catch (CoreException ce) {
                Trace.trace("/info", "CoreException publishing to " + this.toString(), ce);
                return ce.getStatus();
            }
            if (this.isRemoteDebugging()) {
                return Status.OK_STATUS;
            }
            if (this.server.getServerState() == 4) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.server.getServerState() != 2) {
                return Status.OK_STATUS;
            }
            IStatus ret = this.publishOnce(kind, monitor);
            if (this.isNeedsRestart) {
                this.isNeedsRestart = false;
                if (!this.getWeblogicServer().isRemote()) {
                    String mode = "run";
                    if (this.launch != null && this.launch.getLaunchMode() == null) {
                        mode = this.launch.getLaunchMode();
                    }
                    this.server.restart(mode, monitor);
                    return Status.OK_STATUS;
                }
            }
            if (ret.getCode() == 0 && this.launch != null && this.launch.getLaunchMode().equals("debug")) {
                this.reinstallFastSwapBreakpoints();
            }
            return ret;
        }
        catch (RuntimeException re) {
            String msg = CorePlugin.getString("errorPublishRuntimeException", new Object[0]);
            return CorePlugin.createErrorStatus(msg, re);
        }
        catch (InterruptedException e) {
            String msg = CorePlugin.getString("errorPublishRuntimeException", new Object[0]);
            return CorePlugin.createErrorStatus(msg, e);
        }
    }

    private void reinstallFastSwapBreakpoints() throws InterruptedException {
        IDebugTarget debugTarget = this.launch.getDebugTarget();
        if (debugTarget != null && debugTarget instanceof WeblogicDebugTarget) {
            ((WeblogicDebugTarget)debugTarget).reinstallBreakpoints();
        }
    }

    public boolean isRemoteDebugging() {
        return this.isRemoteDebugging;
    }

    public void setRemoteDebugging(boolean remote) {
        this.isRemoteDebugging = remote;
    }

    @Deprecated
    public boolean isRemoteServer() {
        return this.isRemoteDebugging;
    }

    @Deprecated
    public void setRemoteServer(boolean remote) {
        this.isRemoteDebugging = remote;
    }

    public void setSurpassNoWebModuleWarning(boolean val) {
        this.surpassNoWebModuleWarning = val;
    }

    public boolean getSurpassNoWebModuleWarning() {
        return this.surpassNoWebModuleWarning;
    }

    protected IStatus publishOnce(int kind, IProgressMonitor monitor) {
        block15: {
            boolean ret;
            CharSequence msg;
            if (this.isRemoteDebugging()) {
                return Status.OK_STATUS;
            }
            String domainLockedmsg = "The domain edit lock is owned by another session - this deployment operation requires exclusive access to the edit lock and hence cannot proceed.";
            domainLockedmsg = ServerLaunchUtils.ID_ESSEX_RUNTIME.equals(this.server.getRuntime().getRuntimeType().getId()) ? String.valueOf(domainLockedmsg) + "\nYou can release the lock in Administration Console by first disabling \"Automatically Acquire Lock and Activate Changes\" in Preference,\nthen clicking the Release Configuration button." : String.valueOf(domainLockedmsg) + "\nYou can release the lock by clicking the Release Configuration button in Administration Console.";
            boolean startAsWlx = this.server.getAttribute("start_as_wlx", false);
            if (startAsWlx) {
                msg = new StringBuffer();
                if (ServerLaunchUtils.hasEjbModules((Server)this.server)) {
                    ((StringBuffer)msg).append("WebLogic Server is configured to start in Express Mode but EJB modules are found on server.");
                    return CorePlugin.createErrorStatus(((StringBuffer)msg).toString());
                }
            }
            if (ServerLaunchUtils.hasMultiGarModulesInEar((Server)this.server)) {
                msg = "Found multiple GAR modules in EAR project. Only one GAR module is permitted within EAR.";
                return CorePlugin.createErrorStatus((String)msg);
            }
            IJ2EEDeploymentHelper publisher = this.getPublisher();
            IWlsJMXHelper jmxHelper = publisher.getWlsJMXHelper();
            if (this.getWeblogicServer().isRemote()) {
                try {
                    if (!jmxHelper.canAcquireDomainEditLock()) {
                        return new Status(4, "org.eclipse.wst.server.core", 0, domainLockedmsg, null);
                    }
                    break block15;
                }
                catch (SecurityException se) {
                    String msg2 = "User: " + this.getWeblogicServer().getUsername() + ", failed to be authenticated.";
                    msg2 = String.valueOf(msg2) + "To avoid security lockout, Server watcher will NOT attempt to reconnect the server. If you change username/password, please restart Eclipse.";
                    publisher.disconnect();
                    ((Server)this.getServer()).setServerState(4);
                    return new Status(4, "org.eclipse.wst.server.core", 0, msg2, (Throwable)se);
                }
            }
            if (this.getWeblogicServer().isDomainConifgEditLockOn() && !(ret = jmxHelper.cancelDomainEditLock())) {
                return new Status(4, "org.eclipse.wst.server.core", 0, domainLockedmsg, null);
            }
        }
        if (this.isProductionMode()) {
            CorePlugin.getLevelLog().logInfo(CorePlugin.createWarnStatus(Resources.wlsInProductionMode));
        }
        Trace.trace("/finest", "-->-- Publishing to server: " + this.toString() + " -->--");
        if (this.getServer().getServerType().hasRuntime() && this.getServer().getRuntime() == null) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishNoRuntime, null);
        }
        ServerWorkingCopy swc = (ServerWorkingCopy)this.server.createWorkingCopy();
        boolean val = swc.getAttribute("RUN_WEB_MODULE_FROM_WORKSPACE", true);
        boolean ignoreCompilerErrors = swc.getAttribute("IGNORE_COMPILER_ERRORS", false);
        this.deployInSplitSrcMode = val;
        List moduleList = this.getAllModules();
        IStatus accessibleStatus = this.checkAccessibility(moduleList);
        if (!accessibleStatus.isOK()) {
            return accessibleStatus;
        }
        try {
            if (!ignoreCompilerErrors) {
                this.checkAutoBuild(moduleList, monitor);
            }
        }
        catch (Exception e) {
            String msg = CorePlugin.getString("errorPublishBuildWorkspaceFailed", new Object[0]);
            MultiStatus status = CorePlugin.createMultiStatus(msg, new IStatus[]{new Status(4, "org.eclipse.wst.server.core", 0, msg, (Throwable)e)});
            return status;
        }
        return this.publishToServer(kind, ignoreCompilerErrors, monitor);
    }

    public boolean isProductionMode() {
        if (this.server.getServerState() != 2) {
            return false;
        }
        IJ2EEDeploymentHelper publisher = this.getPublisher();
        IWlsJMXHelper jmxHelper = publisher.getWlsJMXHelper();
        String isProductionMode = jmxHelper.getDomainAttribute("ProductionModeEnabled");
        return "true".equals(isProductionMode);
    }

    private boolean isJavaClassChangeOnly(IModuleResourceDelta delta) {
        IModuleResource res = delta.getModuleResource();
        if (res instanceof IModuleFile) {
            IModuleFile file = (IModuleFile)res;
            String name = file.getName();
            if (!name.endsWith(".class")) {
                return false;
            }
        } else {
            IModuleResourceDelta[] deltaChildren;
            IModuleResourceDelta[] iModuleResourceDeltaArray = deltaChildren = delta.getAffectedChildren();
            int n = deltaChildren.length;
            int n2 = 0;
            while (n2 < n) {
                IModuleResourceDelta deltaChild = iModuleResourceDeltaArray[n2];
                if (!this.isJavaClassChangeOnly(deltaChild)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private boolean isJavaClassChangeOnly(IModuleResourceDelta[] deltas) {
        boolean ret = true;
        IModuleResourceDelta[] iModuleResourceDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleResourceDelta delta = iModuleResourceDeltaArray[n2];
            ret = this.isJavaClassChangeOnly(delta);
            if (!ret) {
                return ret;
            }
            ++n2;
        }
        return true;
    }

    protected IStatus publishToServer(int kind, boolean ignoreCompilerErrors, IProgressMonitor monitor) {
        List moduleList = this.getAllModules();
        ArrayList<Integer> deltaKindList = new ArrayList<Integer>();
        MultiStatus tempMulti = new MultiStatus("org.eclipse.wst.server.core", 0, "", null);
        ArrayList<IWeblogicModule> wlmodules = new ArrayList<IWeblogicModule>();
        Iterator iterator = moduleList.iterator();
        boolean modulePublishStateChanged = false;
        ArrayList<String> listModulesToAdd = new ArrayList<String>();
        while (iterator.hasNext()) {
            Integer deltaKind;
            org.eclipse.wst.server.core.IModule[] module = (org.eclipse.wst.server.core.IModule[])iterator.next();
            if (this.server.getModulePublishState(module) != 1) {
                modulePublishStateChanged = true;
            }
            if (module[0].getName().startsWith("lib/")) continue;
            IModuleResourceDelta[] delta = null;
            if (this.hasBeenPublished(module)) {
                delta = this.getPublishedResourceDelta(module);
                if (delta.length == 0) {
                    deltaKind = 0;
                    CorePlugin.getLevelLog().logDebug(CorePlugin.createInfoStatus("Module not changed:" + this.listModules(module)));
                    deltaKindList.add(deltaKind);
                } else {
                    deltaKind = new Integer(2);
                    CorePlugin.getLevelLog().logDebug(CorePlugin.createInfoStatus("Module changed:" + this.listModules(module)));
                    deltaKindList.add(deltaKind);
                }
            } else {
                CorePlugin.getLevelLog().logDebug(CorePlugin.createInfoStatus("Found new module:" + this.listModules(module)));
                deltaKind = new Integer(1);
                deltaKindList.add(deltaKind);
                if (module.length == 1) {
                    listModulesToAdd.add(module[0].getName());
                }
            }
            this.addWeblogicModule(null, wlmodules, module, 0, deltaKind, delta);
        }
        this.checkModuleExistingOnServer(listModulesToAdd, monitor);
        int removed_index = moduleList.size();
        this.addRemovedModules(moduleList, deltaKindList);
        int moduleDeleted = moduleList.size() - removed_index;
        CorePlugin.getLevelLog().logDebug(CorePlugin.createInfoStatus("Total deleted modules: " + moduleDeleted));
        if (kind == 4 || kind == 2) {
            for (IWeblogicModule wlm : wlmodules) {
                wlm.setRedeploy(true);
                wlm.setFullRedeploy();
            }
        } else {
            boolean modulesChangedOrAdded = false;
            for (Integer deltaKind : deltaKindList) {
                if (deltaKind == 0) continue;
                modulesChangedOrAdded = true;
            }
            if (!modulesChangedOrAdded && moduleDeleted == 0 && !modulePublishStateChanged) {
                return Status.OK_STATUS;
            }
        }
        int i = removed_index;
        while (i < moduleList.size()) {
            org.eclipse.wst.server.core.IModule[] module = (org.eclipse.wst.server.core.IModule[])moduleList.get(i);
            if (!ModuleUtil.isUtilityModule(module)) {
                CorePlugin.getLevelLog().logDebug(CorePlugin.createInfoStatus("Found deleted module " + this.listModules(module)));
                this.addWeblogicModule(null, wlmodules, module, 0, 3, null);
            }
            ++i;
        }
        try {
            IStatus moduleStatus = this.getWeblogicModuleStatus(wlmodules);
            if (!ignoreCompilerErrors && moduleStatus.getSeverity() == 4) {
                ((Server)this.server).setServerPublishState(3);
                return moduleStatus;
            }
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        PublishOperation[] tasks = this.getTasks(kind, moduleList, deltaKindList);
        int size = 2000 + 3500 * moduleList.size() + 500 * tasks.length;
        monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
        monitor.beginTask(NLS.bind((String)Messages.publishing, (Object)this.getServer().getName()), size);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        MultiStatus taskStatus = this.performTasks(tasks, wlmodules, monitor);
        if (taskStatus != null) {
            tempMulti.addAll((IStatus)taskStatus);
        }
        boolean isJavaClassChangeOnly = true;
        for (org.eclipse.wst.server.core.IModule[] module : moduleList) {
            IModuleResourceDelta[] delta = null;
            if (!this.hasBeenPublished(module) || (delta = this.getPublishedResourceDelta(module)).length == 0) continue;
            Integer deltaKind = new Integer(2);
            CorePlugin.getLevelLog().logDebug(CorePlugin.createInfoStatus("Module changed:" + this.listModules(module)));
            deltaKindList.add(deltaKind);
            isJavaClassChangeOnly &= this.isJavaClassChangeOnly(delta);
        }
        try {
            if (!monitor.isCanceled()) {
                this.publishServer(kind, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)1000));
            }
        }
        catch (CoreException ce) {
            Trace.trace("/info", "CoreException publishing to " + this.toString(), ce);
            tempMulti.add(ce.getStatus());
        }
        catch (Exception e) {
            Trace.trace("/severe", "Error publishing configuration to " + this.toString(), e);
            tempMulti.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishing, (Throwable)e));
        }
        if (!monitor.isCanceled()) {
            try {
                this.publishWeblogicModules(kind, wlmodules, isJavaClassChangeOnly, tempMulti, monitor);
            }
            catch (Exception e) {
                Trace.trace("/warning", "Error while publishing modules", e);
                tempMulti.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishing, (Throwable)e));
            }
        }
        Trace.trace("/finest", "Calling publishFinish()");
        try {
            this.publishFinish(ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)500));
        }
        catch (CoreException ce) {
            Trace.trace("/info", "CoreException publishing to " + this.toString(), ce);
            tempMulti.add(ce.getStatus());
        }
        catch (Exception e) {
            Trace.trace("/severe", "Error stopping publish to " + this.toString(), e);
            tempMulti.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishing, (Throwable)e));
        }
        Server server = (Server)this.getServer();
        server.getServerPublishInfo().clearCache();
        if (monitor.isCanceled() && tempMulti.getChildren().length < 1) {
            return Status.CANCEL_STATUS;
        }
        monitor.done();
        Trace.trace("/finest", "--<-- Done publishing --<--");
        if (tempMulti.getChildren().length == 1) {
            return tempMulti.getChildren()[0];
        }
        MultiStatus multi = null;
        if (tempMulti.getSeverity() == 1) {
            multi = new MultiStatus("org.eclipse.wst.server.core", 0, Messages.publishingStatusInfo, null);
        } else if (tempMulti.getSeverity() == 2) {
            multi = new MultiStatus("org.eclipse.wst.server.core", 0, Messages.publishingStatusWarning, null);
        } else if (tempMulti.getSeverity() == 4) {
            multi = new MultiStatus("org.eclipse.wst.server.core", 0, Messages.publishingStatusError, null);
        } else {
            return tempMulti;
        }
        multi.addAll((IStatus)tempMulti);
        return multi;
    }

    private void checkModuleExistingOnServer(ArrayList listModulesToAdd, IProgressMonitor monitor) {
        if (listModulesToAdd.size() == 0) {
            return;
        }
        IJ2EEDeploymentHelper publisher = this.getPublisher();
        try {
            ArrayList<String> listToRemove = new ArrayList<String>();
            String names = publisher.getJ2EEModuleNames(monitor);
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < listModulesToAdd.size()) {
                String name = (String)listModulesToAdd.get(i);
                if (names.indexOf(String.valueOf(name) + "/;") >= 0) {
                    listToRemove.add(name);
                    buf.append(String.valueOf(name) + "\n");
                }
                ++i;
            }
            if (listToRemove.size() > 0) {
                String message = String.valueOf(Resources.warnModuleExistingOnServer1) + buf.toString();
                message = String.valueOf(message) + Resources.warnModuleExistingOnServer2;
                CorePlugin.getLevelLog().logInfo(CorePlugin.createInfoStatus(message));
                int i2 = 0;
                while (i2 < listToRemove.size()) {
                    String name = (String)listToRemove.get(i2);
                    publisher.undeploy(name, monitor);
                    ++i2;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private String listModules(org.eclipse.wst.server.core.IModule[] module) {
        StringBuffer ret = new StringBuffer();
        if (module != null) {
            ret.append("[");
            int i = 0;
            while (i < module.length) {
                ret.append(module[i] != null ? module[i].getName() : "");
                if (i < module.length - 1) {
                    ret.append(",");
                }
                ++i;
            }
            ret.append("]");
        }
        return ret.toString();
    }

    private IStatus checkAccessibility(List<org.eclipse.wst.server.core.IModule[]> moduleList) {
        for (org.eclipse.wst.server.core.IModule[] modules : moduleList) {
            IStatus accessibleStatus = this.verifyProjectAccessible(modules);
            if (accessibleStatus.isOK()) continue;
            return accessibleStatus;
        }
        return Status.OK_STATUS;
    }

    private IStatus verifyProjectAccessible(org.eclipse.wst.server.core.IModule[] modules) {
        IProject project;
        org.eclipse.wst.server.core.IModule newMod;
        org.eclipse.wst.server.core.IModule module = modules[modules.length - 1];
        if (module instanceof DeletedModule && (newMod = org.eclipse.wst.server.core.ServerUtil.getModule((String)module.getId())) != null) {
            modules[modules.length - 1] = newMod;
        }
        if (!this.isProjectAccessible(project = module.getProject())) {
            return CorePlugin.createErrorStatus(CorePlugin.getString("errorPublishProjectClosed", this.getServer().getName(), module.getName()));
        }
        if (module.getModuleType().getId().equals("jst.ear")) {
            IVirtualReference[] refs;
            IVirtualComponent earComp = ComponentCore.createComponent((IProject)project);
            IVirtualReference[] iVirtualReferenceArray = refs = earComp.getReferences();
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                IVirtualReference ref = iVirtualReferenceArray[n2];
                IVirtualComponent comp = ref.getReferencedComponent();
                if (comp == null || !this.isProjectAccessible(comp.getProject())) {
                    return CorePlugin.createErrorStatus(CorePlugin.getString("errorPublishEARChildClosed", this.getServer().getName(), module.getName()));
                }
                ++n2;
            }
        }
        return CorePlugin.STATUS_OK;
    }

    private boolean isProjectAccessible(IProject project) {
        return project != null && project.exists() && project.isOpen();
    }

    private void checkAutoBuild(List<org.eclipse.wst.server.core.IModule[]> modules, IProgressMonitor monitor) throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        if (ws.isAutoBuilding()) {
            return;
        }
        try {
            SubProgressMonitor sub = new SubProgressMonitor(monitor, 100);
            sub.beginTask(CorePlugin.getString("msgPublishBuildWorkspace", new Object[0]), 100);
            ws.build(10, (IProgressMonitor)sub);
        }
        catch (CoreException ce) {
            String msg = CorePlugin.getString("errorPublishBuildWorkspaceFailed", new Object[0]);
            MultiStatus status = CorePlugin.createMultiStatus(msg, ce.getStatus());
            throw new CoreException((IStatus)status);
        }
    }

    private void addWeblogicModule(IWeblogicModule parent, List<IWeblogicModule> modules, org.eclipse.wst.server.core.IModule[] path, int index, Integer kind, IModuleResourceDelta[] delta) {
        WeblogicModule module = null;
        for (IWeblogicModule temp : modules) {
            if (!temp.getModule().getName().equals(path[index].getName())) continue;
            if (index == path.length - 1) {
                module = (WeblogicModule)temp;
                break;
            }
            this.addWeblogicModule(temp, temp.getChildModules(), path, ++index, kind, delta);
            return;
        }
        if (module == null) {
            if (parent == null) {
                assert (index == 0);
                if (path[0] != null) {
                    if (path[0].getName().startsWith("lib/")) {
                        return;
                    }
                    IPath deployRoot = this.getDeploymentPath(path[0]);
                    if (deployRoot == null) {
                        deployRoot = new Path("");
                    }
                    if (ModuleUtil.isEARModule(path[0])) {
                        boolean isSplirSource = this.server.getAttribute("RUN_WEB_MODULE_FROM_WORKSPACE", true);
                        if (isSplirSource && !this.getWeblogicServer().isRemote()) {
                            deployRoot = deployRoot.append("split_src");
                        }
                        module = new WeblogicEARModule(deployRoot, path[index]);
                    } else if (ModuleUtil.isWebModule(path[0])) {
                        String deployName = path[index].getName();
                        module = new WeblogicStandaloneWARModule(deployRoot, path[index], deployName);
                    } else if (ModuleUtil.isEJBModule(path[0])) {
                        module = new WeblogicStandaloneEJBModule(deployRoot, path[index]);
                    } else if (ModuleUtil.isCoherenceGarModule(path[0])) {
                        module = new WeblogicStandaloneGARModule(deployRoot, path[index]);
                    } else {
                        CorePlugin.getLevelLog().logDebug("Found deployable module: " + path[0].getId() + " : " + path[0].getModuleType().getId());
                    }
                }
            } else {
                String deployName = null;
                if (ModuleUtil.isWebModule(path[index])) {
                    deployName = this.getWeblogicServer().getModuleRootPath(path[index], parent.getModule()).substring(1);
                } else if (ModuleUtil.isEJBModule(path[index]) || ModuleUtil.isConnectorModule(path[index])) {
                    deployName = path[index].getName();
                }
                module = new WeblogicModule(parent, path[index], deployName);
            }
            if (module != null) {
                modules.add(module);
            }
        }
        if (index < path.length - 1 && module != null) {
            this.addWeblogicModule(module, module.getChildModules(), path, ++index, kind, delta);
            return;
        }
        if (module != null) {
            module.setModulePath(path);
            module.setKind(kind);
            module.setDelta(delta);
            module.setRedeploy(delta == null || delta.length > 0);
        }
    }

    protected IModuleResourceDelta[] getPublishedResourceDelta(org.eclipse.wst.server.core.IModule[] module) {
        try {
            IModuleResourceDelta[] moduleDelta = super.getPublishedResourceDelta(module);
            if (moduleDelta.length == 0) {
                return moduleDelta;
            }
            String[] autoDeployPatterns = this.getAutoDeployPatterns();
            if (autoDeployPatterns.length == 0) {
                return moduleDelta;
            }
            return this.getUpdatedDelta(moduleDelta);
        }
        catch (Exception e) {
            CorePlugin.getLevelLog().logDebug(CorePlugin.createWarnStatus("Weblogic getPublishedResourceDelta", e));
            return new IModuleResourceDelta[0];
        }
    }

    protected String[] getAutoDeployPatterns() {
        if (PATTERNS_AUTO_DEPLOY_FILE == null) {
            PATTERNS_AUTO_DEPLOY_FILE = WeblogicServerBehaviour.loadAutoDeployFilePattern();
        }
        return PATTERNS_AUTO_DEPLOY_FILE;
    }

    protected IModuleResourceDelta[] getUnfilteredResourceDelta(org.eclipse.wst.server.core.IModule[] module) {
        return super.getPublishedResourceDelta(module);
    }

    /*
     * Unable to fully structure code
     */
    private IModuleResourceDelta[] getUpdatedDelta(IModuleResourceDelta[] deltaList) {
        if (deltaList == null || deltaList.length == 0) {
            return deltaList;
        }
        itemReplaced = false;
        newList = new IModuleResourceDelta[deltaList.length];
        j = 0;
        len = deltaList.length;
        i = 0;
        while (i < len) {
            block11: {
                block9: {
                    block10: {
                        delta = deltaList[i];
                        if (!(delta.getModuleResource() instanceof IModuleFolder)) break block9;
                        children = delta.getAffectedChildren();
                        newChildren = this.getUpdatedDelta(children);
                        if (newChildren != null && newChildren.length != 0) break block10;
                        if (delta.getKind() != 0) ** GOTO lbl-1000
                        break block11;
                    }
                    if (newChildren == children) {
                        newList[j++] = delta;
                    } else lbl-1000:
                    // 2 sources

                    {
                        itemReplaced = true;
                        newDelta = new ModuleResourceDelta(delta.getModuleResource(), delta.getKind());
                        newDelta.setChildren(newChildren);
                        newList[j++] = newDelta;
                    }
                    break block11;
                }
                if (delta.getModuleResource() instanceof IModuleFile) {
                    resName = delta.getModuleResource().getName();
                    matched = WeblogicServerBehaviour.matchesPattern(resName, WeblogicServerBehaviour.PATTERNS_AUTO_DEPLOY_FILE);
                    if (!matched) {
                        newList[j++] = delta;
                    }
                } else {
                    newList[j++] = delta;
                }
            }
            ++i;
        }
        if (itemReplaced && j == len) {
            return newList;
        }
        if (j < len) {
            resultList = new IModuleResourceDelta[j];
            System.arraycopy(newList, 0, resultList, 0, j);
            return resultList;
        }
        return deltaList;
    }

    protected static boolean matchesPattern(String resourceName, String[] patterns) {
        boolean matched = false;
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            if (WeblogicServerBehaviour.match(resourceName, pattern)) {
                matched = true;
                break;
            }
            ++n2;
        }
        return matched;
    }

    private static boolean match(String text, String pattern) {
        text = String.valueOf(text) + '\u0000';
        pattern = String.valueOf(pattern) + '\u0000';
        int n = pattern.length();
        boolean[] states = new boolean[n + 1];
        boolean[] old = new boolean[n + 1];
        old[0] = true;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            states = new boolean[n + 1];
            int j = 0;
            while (j < n) {
                char p = pattern.charAt(j);
                if (old[j] && p == '*') {
                    old[j + 1] = true;
                }
                if (old[j] && p == c) {
                    states[j + 1] = true;
                }
                if (old[j] && p == '*') {
                    states[j] = true;
                }
                if (old[j] && p == '*') {
                    states[j + 1] = true;
                }
                ++j;
            }
            old = states;
            ++i;
        }
        return states[n];
    }

    protected MultiStatus performTasks(PublishOperation[] tasks, IProgressMonitor monitor) {
        assert (false);
        return null;
    }

    private MultiStatus performTasks(PublishOperation[] tasks, List<IWeblogicModule> modules, IProgressMonitor monitor) {
        int size = tasks.length;
        Trace.trace("/finest", "Performing tasks: " + size);
        if (size == 0) {
            return null;
        }
        MultiStatus multi = new MultiStatus("org.eclipse.wst.server.core", 0, Messages.taskPerforming, null);
        int i = 0;
        while (i < size) {
            PublishOperation task = tasks[i];
            task.getTaskModel().putObject("weblogic_modules", modules);
            monitor.subTask(NLS.bind((String)Messages.taskPerforming, (Object)task.toString()));
            try {
                IProgressMonitor subMonitor = ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)500);
                task.execute(subMonitor, null);
            }
            catch (CoreException ce) {
                Trace.trace("/severe", "Task failed", ce);
                CorePlugin.getLevelLog().logInfo(CorePlugin.createErrorStatus(ce.getMessage(), ce));
                multi.add(ce.getStatus());
                monitor.setCanceled(true);
                break;
            }
            if (monitor.isCanceled()) break;
            ++i;
        }
        return multi;
    }

    @Override
    public IPath getDeploymentPath(org.eclipse.wst.server.core.IModule module) {
        ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, (IProgressMonitor)new NullProgressMonitor());
        if (pm == null) {
            return null;
        }
        IProject project = pm.getProject();
        if (project == null) {
            return null;
        }
        IPath serverPluginWorkingDir = project.getWorkingLocation(DEPLOY_FOLDER);
        if (serverPluginWorkingDir == null) {
            return null;
        }
        ServerInfo info = this.getServerInfo();
        if (info == null) {
            CorePlugin.getLevelLog().logInfo(CorePlugin.createWarnStatus("Unable to retrieve domain for server instance"));
            return null;
        }
        String domainName = info.getDomainName() == null ? "remote_weblogic" : info.getDomainName();
        return serverPluginWorkingDir.append(domainName).append(module.getName());
    }

    protected void publishModules(int kind, List modules2, List deltaKind, MultiStatus multi, IProgressMonitor monitor) {
        assert (false);
    }

    private void publishWeblogicModules(int kind, List<IWeblogicModule> modules, boolean isJavaClassChangeOnly, MultiStatus multi, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        if (this.getServer().getServerState() != 2) {
            CorePlugin.getLevelLog().logDebug(CorePlugin.createInfoStatus("Server is not started"));
            return;
        }
        if (modules.size() == 0) {
            CorePlugin.getLevelLog().logDebug(CorePlugin.createInfoStatus("No Weblogic J2EE module to publish"));
            this.setServerPublishState(1);
            return;
        }
        IStatus[] childrenStatus = multi.getChildren();
        if (childrenStatus != null && childrenStatus.length != 0) {
            String msg = CorePlugin.getString("errorPublishAssemblyFailed", new Object[0]);
            multi.add(CorePlugin.createErrorStatus(msg));
            return;
        }
        if (CorePlugin.getLevelLog().isDebugEnabled()) {
            CorePlugin.getLevelLog().logDebug(CorePlugin.createInfoStatus(WeblogicServerBehaviour.printDeploymentInfo(modules)));
        }
        boolean needWorkAroundForJSF20 = WebLogicServerUtil.needWorkAroundForJSF20(this.server);
        boolean hasStandAloneWebModule = false;
        for (IWeblogicModule module : modules) {
            if (monitor.isCanceled()) {
                return;
            }
            try {
                if (module instanceof WeblogicStandaloneWARModule || module instanceof WeblogicStandaloneGARModule) {
                    hasStandAloneWebModule = true;
                    if (this.deployInSplitSrcMode && !this.getWeblogicServer().isRemote() && !needWorkAroundForJSF20) continue;
                    if (!this.deployInSplitSrcMode || needWorkAroundForJSF20) {
                        this.getPublisher().undeploy("_auto_generated_ear_", monitor);
                    }
                }
                if (module.getKind() == 3) {
                    CorePlugin.getLevelLog().logDebug(CorePlugin.createInfoStatus("Module deleted: " + module.getDeployName()));
                    if (module instanceof WeblogicStandaloneGARModule) {
                        this.getPublisher().undeploy(module.getDeployName(), false, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)100));
                    } else {
                        this.getPublisher().undeploy(module, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)100));
                    }
                }
                if (module.getModulePath() == null) continue;
                this.setModuleStatus(module.getModulePath(), CorePlugin.STATUS_OK);
            }
            catch (CoreException ce) {
                ((IWeblogicDeployableModule)module).setPublishStatus(ce.getStatus());
                multi.add(ce.getStatus());
                this.setModuleStatus(module.getModulePath(), ce.getStatus());
            }
        }
        Server server2 = (Server)this.server;
        try {
            if (hasStandAloneWebModule && this.deployInSplitSrcMode && !this.getWeblogicServer().isRemote() && !needWorkAroundForJSF20) {
                this.getPublisher().deployAutoGenerateEarApplication(server2, modules, monitor);
            }
        }
        catch (CoreException e) {
            String msg = "Failed to publish module";
            CorePlugin.getLevelLog().log(CorePlugin.createErrorStatus(msg, e));
            this.setServerPublishState(0);
            IWlsAdapterListener adapter = WlsRuntimeUtil.getWlsAdapter();
            if (adapter != null) {
                adapter.publishFailed();
            }
            return;
        }
        block10: for (IWeblogicModule module : modules) {
            if (monitor.isCanceled()) {
                return;
            }
            if (module.getKind() == 3 || this.deployInSplitSrcMode && FacetUtil.hasWebFacet(module.getModule()) && !this.getWeblogicServer().isRemote() && !needWorkAroundForJSF20 || !this.getWeblogicServer().isRemote() && this.deployInSplitSrcMode && FacetUtil.hasWebLogicGarFacet(module.getModule())) continue;
            try {
                int publishState = this.getServer().getModulePublishState(module.getModulePath());
                if (module.getKind() == 1) {
                    this.getPublisher().deploy(module, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)100));
                    continue;
                }
                if (publishState == 3) {
                    module.setRedeploy(true);
                    this.getPublisher().redeploy(module, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)100));
                    continue;
                }
                if (module.redeploy()) {
                    if (isJavaClassChangeOnly) {
                        this.getPublisher().redeploy(module, true, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)100));
                        continue;
                    }
                    this.getPublisher().redeploy(module, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)100));
                    continue;
                }
                for (IWeblogicModule child : module.getChildModules()) {
                    if (!child.redeploy()) continue;
                    if (child.getKind() == 1 || child.getKind() == 3) {
                        module.setRedeploy(true);
                        this.getPublisher().redeploy(module, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)100));
                        continue block10;
                    }
                    ClassloaderStructureHelper helper = new ClassloaderStructureHelper(module);
                    if (helper.hasCustomClassloader(child.getDeployName())) {
                        CorePlugin.getLevelLog().logInfo(CorePlugin.createWarnStatus("Found EJB module with custom classloader: " + child.getDeployName()));
                        CorePlugin.getLevelLog().logInfo(CorePlugin.createWarnStatus("Publisher will only redeploy affected modules."));
                        String ejbModule = child.getDeployName();
                        List<IWeblogicModule> list = helper.findAffectedModules(ejbModule);
                        for (IWeblogicModule m : list) {
                            m.setRedeploy(true);
                        }
                        this.getPublisher().redeploy(module, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)100));
                        continue block10;
                    }
                    if (isJavaClassChangeOnly) {
                        this.getPublisher().redeploy(module, true, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)100));
                        continue block10;
                    }
                    this.getPublisher().redeploy(module, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)100));
                    continue block10;
                }
            }
            catch (CoreException ce) {
                ((IWeblogicDeployableModule)module).setPublishStatus(ce.getStatus());
                multi.add(ce.getStatus());
                this.setModuleStatus(module.getModulePath(), ce.getStatus());
                try {
                    this.getPublisher().undeploy(module, monitor);
                }
                catch (CoreException ce2) {
                    multi.add(ce2.getStatus());
                    this.setModuleStatus(module.getModulePath(), ce2.getStatus());
                }
                IWlsAdapterListener adapter = WlsRuntimeUtil.getWlsAdapter();
                if (adapter == null) continue;
                adapter.publishFailed();
            }
            catch (Exception e) {
                CorePlugin.getLevelLog().logInfo("Error redeploy modules " + e.getMessage());
            }
        }
        boolean succeeded = this.updateWeblogicModulePublishState(modules);
        if (succeeded) {
            this.setServerPublishState(1);
        } else {
            this.setServerPublishState(0);
        }
    }

    private boolean updateWeblogicModulePublishState(List<IWeblogicModule> modules) {
        boolean failed = false;
        for (IWeblogicModule module : modules) {
            if (this.updateWeblogicModulePublishState(module, true)) continue;
            failed = true;
        }
        return !failed;
    }

    private boolean updateWeblogicModulePublishState(IWeblogicModule module, boolean parentState) {
        if (module.getModulePath() == null) {
            return false;
        }
        if (module instanceof WeblogicDeployableModule) {
            IStatus status = ((IWeblogicDeployableModule)module).getPublishStatus();
            if (status.isOK()) {
                this.setModuleStatus(module.getModulePath(), null);
            } else {
                this.setModuleStatus(module.getModulePath(), status);
            }
            if (parentState && (status.isOK() || status.getSeverity() == 2)) {
                this.setModulePublishState(module.getModulePath(), 1);
                boolean failed = false;
                for (IWeblogicModule child : module.getChildModules()) {
                    if (this.updateWeblogicModulePublishState(child, true)) continue;
                    failed = true;
                }
                return !failed;
            }
            this.setModulePublishState(module.getModulePath(), 0);
            for (IWeblogicModule child : module.getChildModules()) {
                this.updateWeblogicModulePublishState(child, false);
            }
            return false;
        }
        if (parentState) {
            this.setModulePublishState(module.getModulePath(), 1);
        } else {
            this.setModulePublishState(module.getModulePath(), 0);
        }
        for (IWeblogicModule child : module.getChildModules()) {
            this.updateWeblogicModulePublishState(child, parentState);
        }
        return parentState;
    }

    private boolean hasSplitSourceFileChange() {
        return false;
    }

    private IStatus getWeblogicModuleStatus(List<IWeblogicModule> modules) throws CoreException {
        for (IWeblogicModule module : modules) {
            IStatus status = this.getModuleStatus(module);
            if (status.getSeverity() != 4) continue;
            return status;
        }
        return CorePlugin.STATUS_OK;
    }

    private IStatus getModuleStatus(IWeblogicModule module) throws CoreException {
        if (module == null || module.getKind() == 3) {
            return CorePlugin.STATUS_OK;
        }
        IMarker[] markers = module.getModule().getProject().findMarkers(null, true, 2);
        ArrayList<IMarker> errorMarkers = new ArrayList<IMarker>(3);
        if (markers != null && markers.length > 0) {
            int j = 0;
            int mlen = markers.length;
            while (j < mlen) {
                IMarker marker = markers[j];
                int seve = marker.getAttribute("severity", 0);
                if (seve == 2) {
                    if (errorMarkers.size() >= 3) break;
                    errorMarkers.add(marker);
                }
                ++j;
            }
            if (errorMarkers.size() != 0) {
                String msg = CorePlugin.getString("errorPublishWorkspaceProblem", module.getModule().getName());
                return CorePlugin.createMultiStatus(msg, this.convertStatus(errorMarkers.toArray(new IMarker[errorMarkers.size()])));
            }
        }
        for (IWeblogicModule child : module.getChildModules()) {
            IStatus status = this.getModuleStatus(child);
            if (status.getSeverity() != 4) continue;
            return status;
        }
        return CorePlugin.STATUS_OK;
    }

    private IStatus[] convertStatus(IMarker[] markers) {
        IStatus[] result = new IStatus[markers.length];
        int i = 0;
        while (i < markers.length) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(markers[i].getAttribute("message", ""));
            String resName = markers[i].getResource().getName();
            if (resName != null && resName.length() > 0) {
                buffer.append(" at " + resName);
            }
            result[i] = CorePlugin.createErrorStatus(buffer.toString());
            ++i;
        }
        return result;
    }

    public String[] getModules(IProgressMonitor monitor) throws CoreException {
        IJ2EEDeploymentHelper helper = this.getPublisher();
        if (helper != null) {
            return helper.getJ2EEModules(monitor);
        }
        return new String[0];
    }

    public void undeploy(String moduleName, String fromTarget, IProgressMonitor monitor) throws CoreException {
        IJ2EEDeploymentHelper deployHelper = this.getPublisher();
        try {
            deployHelper.deployStart(monitor);
            if (deployHelper.undeploy(moduleName, fromTarget, monitor)) {
                List moduleList = this.getAllModules();
                org.eclipse.wst.server.core.IModule[] module = null;
                for (org.eclipse.wst.server.core.IModule[] m : moduleList) {
                    if (m.length != 1 || !m[0].getName().equals(moduleName)) continue;
                    module = m;
                    break;
                }
                if (module != null) {
                    this.setModulePublishState(module, 3);
                }
            }
        }
        finally {
            deployHelper.deployFinish(monitor);
        }
    }

    protected static IWeblogicServerLaunchConfiguration getWeblogicServerLaunchConfiguration(ILaunchConfiguration config) {
        try {
            ILaunchConfigurationType type = config.getType();
            ILaunchConfigurationDelegate delegate = type.getDelegate("debug");
            if (delegate instanceof IWeblogicServerLaunchConfiguration) {
                return (IWeblogicServerLaunchConfiguration)delegate;
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private static String[] loadAutoDeployFilePattern() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("oracle.eclipse.tools.weblogic", "autoDeployFileType");
        ArrayList<String> fileType = new ArrayList<String>();
        if (cf.length == 0) {
            return EMPTY_STRINGS;
        }
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                String type = element.getAttribute("pattern");
                fileType.add(type);
            }
            catch (Throwable t) {
                String msg = CorePlugin.getString("errorExtensionPointAutoDeployFileGeneral", element.getAttribute("id"));
                CorePlugin.getLevelLog().log(CorePlugin.createErrorStatus(msg, t));
            }
            ++n2;
        }
        if (fileType.size() == 0) {
            return EMPTY_STRINGS;
        }
        return fileType.toArray(new String[fileType.size()]);
    }

    void setLaunchMode(String mode) {
        this.setMode(mode);
    }

    String getLaunchMode() {
        Server server = (Server)this.getServer();
        return server.getMode();
    }

    ILaunchConfiguration getLaunchConfiguration() throws CoreException {
        Server server = (Server)this.getServer();
        return server.getLaunchConfiguration(true, (IProgressMonitor)new NullProgressMonitor());
    }

    public IStatus canStart(String mode2) {
        boolean isRemoteHost = this.getWeblogicServer().isRemote();
        if (!isRemoteHost) {
            return Status.OK_STATUS;
        }
        return new Status(2, "oracle.eclipse.tools.weblogic", "Start remote server not supported");
    }

    public IStatus canPublish() {
        boolean isRemoteHost = this.getWeblogicServer().isRemote();
        if (!isRemoteHost) {
            return Status.OK_STATUS;
        }
        if (this.server.getServerState() == 2) {
            return Status.OK_STATUS;
        }
        return new Status(2, "oracle.eclipse.tools.weblogic", "Cannot publish when remote server is not started");
    }

    public IStatus canRestart(String mode) {
        boolean isRemoteHost = this.getWeblogicServer().isRemote();
        if (!isRemoteHost) {
            return Status.OK_STATUS;
        }
        Server server = (Server)this.getServer();
        if (server.getServerState() == 2 && mode.equals("debug")) {
            return Status.OK_STATUS;
        }
        return new Status(2, "oracle.eclipse.tools.weblogic", "Restart remote server not supported");
    }

    public IStatus canStop() {
        boolean isRemoteHost = this.getWeblogicServer().isRemote();
        if (!isRemoteHost) {
            return Status.OK_STATUS;
        }
        return new Status(2, "oracle.eclipse.tools.weblogic", "Stop remote server not supported");
    }

    public void stop(boolean force) {
        try {
            if (this.launchMonitor != null && !this.launchMonitor.isCanceled()) {
                this.launchMonitor.setCanceled(true);
            }
            Server server2 = (Server)this.server;
            if (this.server.getServerState() != 2) {
                return;
            }
            if (this.getWeblogicServer().isRemote()) {
                IWlsRunnable op = new IWlsRunnable(){

                    @Override
                    public void run() {
                        String message = "Stop operation on remote WebLogic server is not supported";
                        CorePlugin.getLevelLog().logInfo(CorePlugin.createWarnStatus(message));
                        WeblogicServerBehaviour.this.watcher.reset();
                    }
                };
                IWlsAdapterListener adapter = WlsRuntimeUtil.getWlsAdapter();
                if (adapter != null) {
                    adapter.run(op);
                }
                this.setServerState(4);
                return;
            }
            server2.setServerState(3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (force) {
            this.terminate();
        } else {
            try {
                new ShutdownJob().schedule();
            }
            catch (RuntimeException runtimeException) {
                this.terminate();
            }
        }
        this.isLaunchInIDE = false;
        IWlsAdapterListener adapter = WlsRuntimeUtil.getWlsAdapter();
        if (adapter != null) {
            adapter.serverStop(this);
        }
    }

    public void restart(String launchMode) throws CoreException {
        if (this.getWeblogicServer().isRemote()) {
            if (this.server.getMode().equals("run") && "debug".equals(launchMode)) {
                ILaunchConfiguration config = this.getLaunchConfiguration();
                ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                ILaunch newLaunch = wc.launch("debug", (IProgressMonitor)new NullProgressMonitor());
                this.setNewLaunch(newLaunch);
            }
            this.setServerState(4);
            this.setServerState(2);
            return;
        }
        this.isRestarting = true;
        if (!"debug".equals(launchMode)) {
            throw new CoreException(this.createErrorStatus("Restarting WebLogic server"));
        }
        if (!"run".equals(this.getLaunchMode())) {
            throw new CoreException(this.createErrorStatus("Restarting WebLogic server"));
        }
        if (this.getServer().getServerRestartState()) {
            throw new CoreException(this.createErrorStatus("Restarting WebLogic server"));
        }
        ServerWorkingCopy swc = (ServerWorkingCopy)this.server.createWorkingCopy();
        boolean isStartWithDebug = swc.getAttribute("start_with_debug", false);
        if (!isStartWithDebug && this.isLaunchInIDE) {
            throw new CoreException(this.createErrorStatus("Restarting WebLogic server"));
        }
        if (this.launch == null) {
            ILaunchConfiguration config = this.getLaunchConfiguration();
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("attr-semi-restart", true);
            ILaunch newLaunch = wc.launch("debug", (IProgressMonitor)new NullProgressMonitor());
            this.setNewLaunch(newLaunch);
        } else {
            ILaunchConfiguration config = this.getLaunchConfiguration();
            boolean isContinue = this.attach(config.getWorkingCopy(), launchMode, this.launch, (IProgressMonitor)new NullProgressMonitor());
            if (!isContinue) {
                this.setServerState(4);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
                this.setServerState(2);
                this.setLaunchMode("run");
                return;
            }
        }
        this.setServerState(4);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {}
        this.setServerState(2);
        this.setLaunchMode("debug");
    }

    private IStatus createErrorStatus(String msg) {
        return new Status(2, "oracle.eclipse.tools.weblogic", -1, String.valueOf(msg), null);
    }

    private void terminate() {
        this.setServerState(4);
    }

    @Override
    public void serverStateChanged() {
        try {
            this.stateUpdater.schedule();
        }
        catch (IllegalStateException illegalStateException) {}
    }

    private void updateState() {
        if (this.watcher == null || this.watcher.isWatcherStopped()) {
            this.setServerState(4);
            this.setServerStatus(this.watcher != null ? this.watcher.getServerStatus() : Status.OK_STATUS);
            return;
        }
        int state = this.watcher.getServerState();
        switch (state) {
            case 0: {
                this.setServerState(0);
                this.setServerStatus(null);
                break;
            }
            case 1: {
                this.setServerState(4);
                this.setServerStatus(this.watcher.getServerStatus());
                break;
            }
            case 6: {
                this.setServerState(2);
                this.setServerStatus(null);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                this.setServerState(4);
                this.watcher.disconnectDebugTargets();
                this.setServerStatus(null);
                break;
            }
            case 4: 
            case 7: {
                this.setServerState(4);
                this.watcher.disconnectDebugTargets();
                break;
            }
            case 8: {
                this.setServerState(1);
                this.setServerStatus(null);
                break;
            }
            case 9: {
                this.setServerState(3);
                this.setServerStatus(null);
            }
        }
        if (this.watcher.isDebuggingOnServer()) {
            this.setMode("debug");
        } else {
            this.setMode("run");
        }
    }

    private void setNewLaunch(ILaunch newLaunch) {
        if (this.launch == newLaunch) {
            return;
        }
        if (this.launch != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(this.launch);
        }
        this.launch = newLaunch;
        this.watcher.setLaunch(this.launch);
    }

    protected String getStopLaunchName() {
        return "WeblogicServerStopper";
    }

    public IStatus runStopWeblogicScript(IProgressMonitor monitor, Process[] proc) {
        CredentialInfo cred = this.getCredentialInfo();
        ServerInfo info = this.getServerInfo();
        if (info == null) {
            String msg = CorePlugin.getString("errorServerStopScriptMissing", new Object[0]);
            return CorePlugin.createErrorStatus(msg);
        }
        WeblogicServer weblogicServer = this.getWeblogicServer();
        String protocol = weblogicServer.getProtocol();
        String adminURL = String.valueOf(protocol) + "://" + info.getHostName() + ":" + weblogicServer.getPort();
        ServerWorkingCopy swc = (ServerWorkingCopy)this.server.createWorkingCopy();
        boolean launchInConsole = swc.getAttribute("START_SERVER_IN_CONSOLE", true);
        String[] cmd = this.constructStopAdminCommand(launchInConsole, cred, adminURL, info);
        if (cmd == null) {
            String msg = CorePlugin.getString("errorServerStopScriptMissing", new Object[0]);
            return CorePlugin.createErrorStatus(msg);
        }
        this.setLaunchMode("run");
        java.io.File runtimePath = this.server.getRuntime().getLocation().toFile();
        try {
            proc[0] = Runtime.getRuntime().exec(cmd, null, runtimePath);
            monitor.worked(10);
        }
        catch (IOException ioe) {
            String msg = CorePlugin.getString("errorServerStopProcessFailed", new Object[0]);
            IStatus status = CorePlugin.createErrorStatus(msg, ioe);
            this.watcher.setServerStopping(false);
            this.updateState();
            return status;
        }
        return Status.OK_STATUS;
    }

    public IStatus stop(IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        try {
            monitor.beginTask(CorePlugin.getString("msgTerminalStopServer", new Object[0]), 30000);
            int ticksLeft = 30000;
            if (this.watcher.isWatcherStopped()) {
                ((Server)this.server).setServerState(4);
                IStatus iStatus = CorePlugin.STATUS_OK;
                return iStatus;
            }
            IStatus stoppingStatus = this.watcher.validateServerStoppable();
            long currentTime = System.currentTimeMillis();
            int validateTicks = (int)(currentTime - start);
            ticksLeft -= validateTicks;
            monitor.worked(validateTicks);
            if (monitor.isCanceled()) {
                throw new CoreException(CorePlugin.createErrorStatus(CorePlugin.getString("errorServerStopCancelled", new Object[0])));
            }
            if (!stoppingStatus.isOK()) {
                this.updateState();
                IStatus iStatus = stoppingStatus;
                return iStatus;
            }
            try {
                IWlsAdapterListener adapter;
                this.watcher.setServerStopping(true);
                this.setServerState(3);
                Process[] proc = new Process[1];
                this.runStopWeblogicScript(monitor, proc);
                final ServerWatcher watcher2 = this.watcher;
                final long timeout = System.currentTimeMillis() + 480000L;
                final IProgressMonitor monitor2 = monitor;
                String encoding = null;
                if (this.launch != null) {
                    encoding = this.launch.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
                }
                if ((adapter = WlsRuntimeUtil.getWlsAdapter()) != null) {
                    adapter.captureScriptStart(proc[0], new String[]{"Stopping WebLogic Server..."}, encoding);
                }
                this.waitCondition(monitor, ticksLeft, new Condition(){

                    @Override
                    public boolean isMet() throws CoreException {
                        if (watcher2.isServerStopped()) {
                            return true;
                        }
                        if (watcher2.isWatcherStopped()) {
                            String msg = CorePlugin.getString("errorServerWatcherTerminated", new Object[0]);
                            throw new CoreException(CorePlugin.createErrorStatus(msg));
                        }
                        if (System.currentTimeMillis() > timeout) {
                            String msg = CorePlugin.getString("errorServerStopTimeout", new Object[0]);
                            throw new CoreException(CorePlugin.createErrorStatus(msg));
                        }
                        if (monitor2.isCanceled()) {
                            String msg = CorePlugin.getString("errorServerStopCancelled", new Object[0]);
                            throw new CoreException(CorePlugin.createErrorStatus(msg));
                        }
                        return false;
                    }
                });
            }
            catch (CoreException ce) {
                IStatus iStatus = ce.getStatus();
                return iStatus;
            }
        }
        finally {
            this.watcher.setServerStopping(false);
            this.updateState();
            monitor.done();
            IWlsAdapterListener adapter = WlsRuntimeUtil.getWlsAdapter();
            if (adapter != null) {
                adapter.captureScriptFinish();
            }
        }
        return CorePlugin.STATUS_OK;
    }

    private String[] constructStopAdminCommand(boolean launchInConsole, CredentialInfo cred, String adminURL, ServerInfo info) {
        String trustStorePath;
        if (cred == null || cred.getPassword() == null || cred.getUsername() == null) {
            return null;
        }
        ArrayList<String> commandList = new ArrayList<String>();
        IWeblogicServerRuntime rt = (IWeblogicServerRuntime)this.server.getRuntime().loadAdapter(IWeblogicServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        String vmPath = rt != null ? rt.getJavaVmLocation().toPortableString() : "";
        commandList.add(String.valueOf(vmPath) + "/bin/java");
        WeblogicServer weblogicServer = this.getWeblogicServer();
        if (weblogicServer.isUseSSLPort() && (trustStorePath = weblogicServer.getTrustStorePath()) != null) {
            commandList.add("-Dweblogic.security.SSL.trustedCAKeyStore=" + trustStorePath);
            commandList.add("-Djavax.net.ssl.trustStore=" + trustStorePath);
            commandList.add("-Dweblogic.security.SSL.ignoreHostnameVerification=true");
        }
        commandList.add("-classpath");
        commandList.add(this.server.getRuntime().getLocation() + "/server/lib/weblogic.jar");
        commandList.add("weblogic.Admin");
        commandList.add("-url");
        commandList.add(adminURL);
        commandList.add("-username");
        commandList.add(cred.getUsername());
        commandList.add("-password");
        commandList.add(cred.getPassword());
        commandList.add("FORCESHUTDOWN");
        commandList.add(info.getServerName());
        String[] stopCommand = new String[commandList.size()];
        int i = 0;
        while (i < stopCommand.length) {
            String arg = (String)commandList.get(i);
            stopCommand[i] = arg == null ? "" : arg;
            ++i;
        }
        return stopCommand;
    }

    private String[] constructStopScriptCommand(boolean launchInConsole, CredentialInfo cred, String adminURL) {
        String command = "stopWebLogic." + CorePlugin.getScriptExtension();
        java.io.File domainDir = this.getWeblogicServer().getDomainPath().toFile();
        java.io.File script = new java.io.File(domainDir, command);
        java.io.File binScript = new java.io.File(domainDir, "bin/" + command);
        if (!script.exists() && !binScript.exists()) {
            return null;
        }
        if (!script.exists()) {
            command = "bin" + java.io.File.separator + command;
        }
        String[] cmd = null;
        String termName = CorePlugin.getString("msgTerminalStopServer", new Object[0]);
        if (CorePlugin.IS_WINDOWS) {
            if (launchInConsole) {
                String pathWithArgs = "\"" + command + "\"";
                cmd = new String[]{"cmd.exe", "/C", pathWithArgs, cred.getUsername(), cred.getPassword(), adminURL};
            } else {
                String pathWithArgs = "\"" + command + "\"";
                cmd = new String[]{"cmd.exe", "/C", "START", "\"" + termName + "\"", "/MIN", "cmd.exe", "/C", pathWithArgs, cred.getUsername(), cred.getPassword(), adminURL};
            }
        } else if (CorePlugin.IS_UNIX) {
            cmd = launchInConsole ? new String[]{"sh", command, cred.getUsername(), cred.getPassword(), adminURL} : new String[]{"xterm", "-T", termName, "-e", "sh", command, cred.getUsername(), cred.getPassword(), adminURL};
        }
        return cmd;
    }

    public void launch(String[] cmd, String[] env, ILaunchConfigurationWorkingCopy wc, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Process process;
        this.isLaunchInIDE = true;
        this.workingLaunchConfig = wc;
        this.launchMonitor = monitor;
        if (wc.getAttribute("attachDebug", false)) {
            return;
        }
        this.setRemoteDebugging(false);
        long start = System.currentTimeMillis();
        int ticksLeft = 60000;
        if (this.watcher == null) {
            return;
        }
        if (this.watcher.isWatcherStopped()) {
            this.watcher.startWatcher();
        }
        IStatus status = this.watcher.validateServerStartable();
        long currentTime = System.currentTimeMillis();
        int validateTicks = (int)(currentTime - start);
        ticksLeft -= validateTicks;
        monitor.worked(validateTicks);
        if (monitor.isCanceled()) {
            throw new CoreException(CorePlugin.createErrorStatus(CorePlugin.getString("errorServerStartCancelled", new Object[0])));
        }
        if (!status.isOK()) {
            this.updateState();
            throw new CoreException(status);
        }
        this.setNewLaunch(launch);
        this.watcher.setServerStarting(true);
        try {
            if (this.isRestarting) {
                try {
                    Thread.sleep(2500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            process = Runtime.getRuntime().exec(cmd, env, this.getWeblogicServer().getDomainPath().toFile());
            int execTicks = (int)(System.currentTimeMillis() - currentTime);
            ticksLeft -= execTicks;
            monitor.worked(execTicks);
            this.isRestarting = false;
        }
        catch (IOException ioe) {
            this.watcher.setServerStarting(false);
            this.updateState();
            String msg = CorePlugin.getString("errorServerStartProcessFailed", new Object[0]);
            status = CorePlugin.createErrorStatus(msg, ioe);
            throw new CoreException(status);
        }
        try {
            HashMap<String, String> processAttrs = new HashMap<String, String>();
            processAttrs.put(IProcess.ATTR_PROCESS_TYPE, "java");
            ServerWorkingCopy swc = (ServerWorkingCopy)this.server.createWorkingCopy();
            boolean launchInConsole = swc.getAttribute("START_SERVER_IN_CONSOLE", true);
            if (!launchInConsole) {
                launch.setAttribute("org.eclipse.debug.core.capture_output", "false");
            }
            RuntimeProcess runtimeProcess = CorePlugin.IS_WINDOWS && !launchInConsole ? new SpawnProcess(launch, process, "Weblogic Server", processAttrs) : new RuntimeProcess(launch, process, "Weblogic Server", processAttrs){

                public boolean canTerminate() {
                    return false;
                }
            };
            final ServerWatcher watcher2 = this.watcher;
            long t = this.server.getStartTimeout() * 1000;
            final long timeout = t == -1L ? -1L : System.currentTimeMillis() + t;
            final IProgressMonitor monitor2 = monitor;
            this.waitCondition(monitor, ticksLeft, new Condition((IProcess)runtimeProcess, launchInConsole){
                private final /* synthetic */ IProcess val$runtimeProcess;
                private final /* synthetic */ boolean val$launchInConsole;
                {
                    this.val$runtimeProcess = iProcess;
                    this.val$launchInConsole = bl;
                }

                @Override
                public boolean isMet() throws CoreException {
                    if (watcher2.isServerStarted()) {
                        return true;
                    }
                    if (watcher2.isServerConflict()) {
                        String msg = CorePlugin.getString("errorServerStartConflict", WeblogicServerBehaviour.this.getServerInfo().getPortNumber());
                        throw new CoreException(CorePlugin.createErrorStatus(msg));
                    }
                    if (watcher2.isWatcherStopped()) {
                        String msg = CorePlugin.getString("errorServerWatcherTerminated", new Object[0]);
                        throw new CoreException(CorePlugin.createErrorStatus(msg));
                    }
                    if (timeout > 0L && System.currentTimeMillis() > timeout) {
                        String msg = CorePlugin.getString("errorServerStartTimeout", new Object[0]);
                        throw new CoreException(CorePlugin.createErrorStatus(msg));
                    }
                    if (monitor2.isCanceled()) {
                        String msg = CorePlugin.getString("errorServerStartCancelled", new Object[0]);
                        throw new CoreException(CorePlugin.createErrorStatus(msg));
                    }
                    if (this.val$runtimeProcess.isTerminated() && this.val$launchInConsole && !watcher2.isServerStarted()) {
                        String msg = CorePlugin.getString("errorServerStartProcessTerminated", new Object[0]);
                        throw new CoreException(CorePlugin.createErrorStatus(msg));
                    }
                    return false;
                }
            });
        }
        finally {
            if (this.watcher != null) {
                this.watcher.setServerStarting(false);
                this.updateState();
            }
            this.launchMonitor = null;
        }
    }

    public boolean preShutdown() {
        if (this.getWeblogicServer().isRemote()) {
            this.dispose();
            return true;
        }
        ServerWorkingCopy swc = (ServerWorkingCopy)this.server.createWorkingCopy();
        boolean launchInConsole = swc.getAttribute("START_SERVER_IN_CONSOLE", true);
        if (!this.isLaunchInIDE || !launchInConsole || this.getWeblogicServer().isRemote() || this.launch == null) {
            return true;
        }
        if (this.watcher != null && this.watcher.isWatcherStarted() && this.watcher.isServerStarted()) {
            return false;
        }
        this.dispose();
        return true;
    }

    ILaunchConfigurationDelegate findExtDebuggerLaunchConfigurationDelegate() {
        if (this.debuggerLaunchConfigurationDelegate != null) {
            return this.debuggerLaunchConfigurationDelegate;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(DebugPlugin.getUniqueIdentifier(), "launchConfigurationTypes");
        int j = 0;
        while (j < elements.length) {
            try {
                IWeblogicServerDebugSupport wlsDbgSupport;
                boolean canSupport;
                Object launchConfigDelegate = null;
                try {
                    launchConfigDelegate = elements[j].createExecutableExtension("delegate");
                }
                catch (CoreException coreException) {}
                if (launchConfigDelegate != null && launchConfigDelegate instanceof ILaunchConfigurationDelegate && launchConfigDelegate instanceof IWeblogicServerDebugSupport && (canSupport = (wlsDbgSupport = (IWeblogicServerDebugSupport)launchConfigDelegate).canSupport(this.getWeblogicServer()))) {
                    this.debuggerLaunchConfigurationDelegate = (ILaunchConfigurationDelegate)launchConfigDelegate;
                    return this.debuggerLaunchConfigurationDelegate;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++j;
        }
        return null;
    }

    public boolean attach(ILaunchConfigurationWorkingCopy config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.workingLaunchConfig = config;
        ILaunchConfigurationDelegate extDebuggerLaunchConfigDelegate = this.findExtDebuggerLaunchConfigurationDelegate();
        IProject webProject = null;
        String webProjectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
        if (webProjectName == null) {
            org.eclipse.wst.server.core.IModule module = ServerLaunchUtils.getModuleToLaunch(this.server);
            if (module != null) {
                if (!FacetUtil.hasEjbFacet(module) && module.getProject() != null) {
                    webProjectName = module.getProject().getName();
                }
            } else {
                webProject = ServerLaunchUtils.getFirstWebModuleInServer(this.server);
                if (webProject != null) {
                    webProjectName = webProject.getName();
                }
            }
        }
        if (webProjectName != null && webProjectName.length() > 0) {
            webProject = ResourcesPlugin.getWorkspace().getRoot().getProject(webProjectName);
        }
        if ("debug".equals(mode)) {
            IWlsAdapterListener adapter = WlsRuntimeUtil.getWlsAdapter();
            if (adapter != null) {
                adapter.handleDebugAttach();
            }
            if (extDebuggerLaunchConfigDelegate != null) {
                extDebuggerLaunchConfigDelegate.launch((ILaunchConfiguration)this.workingLaunchConfig, mode, launch, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)2000));
            } else {
                REMOTE_JAVA_APP_LAUNCH_DELEGATE.launch((ILaunchConfiguration)config, mode, launch, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)2000));
            }
            ((Server)this.server).setMode("debug");
        }
        return true;
    }

    private void waitCondition(IProgressMonitor monitor, int totalTicks, Condition cond) throws CoreException {
        int ticksLeft = totalTicks;
        while (!cond.isMet()) {
            int numWorked = 1;
            if (ticksLeft > 1) {
                try {
                    numWorked = ticksLeft / (totalTicks / (500 * ticksLeft * 10 / totalTicks));
                }
                catch (ArithmeticException arithmeticException) {
                    numWorked = 1;
                }
                numWorked = numWorked >= 1 ? numWorked : 1;
                ticksLeft -= numWorked;
            }
            monitor.worked(numWorked);
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return;
    }

    public IStatus validateConfiguration() {
        WeblogicServer server = this.getWeblogicServer();
        if (server == null) {
            String msg = CorePlugin.getString("errorDelegateDisposed", new Object[0]);
            return CorePlugin.createErrorStatus(msg);
        }
        return server.validate();
    }

    /*
     * Loose catch block
     */
    protected IStatus validatePortFree() {
        WeblogicServer server = this.getWeblogicServer();
        if (server == null) {
            String msg = CorePlugin.getString("errorDelegateDisposed", new Object[0]);
            return CorePlugin.createErrorStatus(msg);
        }
        ServerInfo info = this.getServerInfo();
        ServerSocket socket = null;
        socket = new ServerSocket(info.getPortNumber());
        socket.accept();
        socket.close();
        IStatus iStatus = CorePlugin.STATUS_OK;
        try {
            if (socket != null && !socket.isClosed()) {
                socket.close();
            }
        }
        catch (IOException iOException) {}
        return iStatus;
        catch (IOException iOException) {
            IStatus iStatus2;
            try {
                String msg = CorePlugin.getString("errorServerPortInUse", info.getPortNumber());
                iStatus2 = CorePlugin.createErrorStatus(msg);
            }
            catch (Throwable throwable) {
                try {
                    if (socket != null && !socket.isClosed()) {
                        socket.close();
                    }
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                if (socket != null && !socket.isClosed()) {
                    socket.close();
                }
            }
            catch (IOException iOException3) {}
            return iStatus2;
        }
    }

    protected IStatus validatePingable() {
        BufferedInputStream input;
        OutputStream output;
        Socket socket;
        block42: {
            IStatus iStatus;
            block43: {
                block40: {
                    IStatus iStatus2;
                    block41: {
                        block38: {
                            IStatus iStatus3;
                            block39: {
                                WeblogicServer server = this.getWeblogicServer();
                                if (server == null) {
                                    String msg = CorePlugin.getString("errorDelegateDisposed", new Object[0]);
                                    return CorePlugin.createErrorStatus(msg);
                                }
                                ServerInfo info = this.getServerInfo();
                                if (info == null) {
                                    String msg = CorePlugin.getString("errorServerInvalid", new Object[0]);
                                    return CorePlugin.createErrorStatus(msg);
                                }
                                socket = new Socket();
                                InetSocketAddress address = null;
                                output = null;
                                input = null;
                                int port = info.getPortNumber();
                                if (this.getWeblogicServer().isUseSSLPort()) {
                                    port = this.getWeblogicServer().getHttpsPort();
                                }
                                address = new InetSocketAddress(info.getHostName(), port);
                                socket.connect(address, 5000);
                                if (socket == null || !this.isServerAlive) break block38;
                                iStatus3 = CorePlugin.STATUS_OK;
                                if (input == null) break block39;
                                FileUtil.close(input);
                            }
                            if (output != null) {
                                FileUtil.close(output);
                            }
                            if (socket != null) {
                                try {
                                    socket.close();
                                }
                                catch (Exception exception) {}
                            }
                            return iStatus3;
                        }
                        if (!this.getWeblogicServer().isUseSSLPort()) break block40;
                        this.isServerAlive = true;
                        iStatus2 = CorePlugin.STATUS_OK;
                        if (input == null) break block41;
                        FileUtil.close(input);
                    }
                    if (output != null) {
                        FileUtil.close(output);
                    }
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {}
                    }
                    return iStatus2;
                }
                String path = "/console";
                output = socket.getOutputStream();
                String command = "HEAD " + path + " HTTP/1.0\n\n";
                output.write(command.getBytes("ASCII"));
                output.flush();
                input = new BufferedInputStream(socket.getInputStream());
                int c = ((InputStream)input).read();
                StringBuffer sb = new StringBuffer();
                while (c != -1) {
                    sb.append((char)c);
                    c = ((InputStream)input).read();
                }
                ((InputStream)input).close();
                output.close();
                String status = sb.toString();
                if (status.startsWith("HTTP/")) break block42;
                this.isServerAlive = false;
                String msg = CorePlugin.getString("errorPingUnexpectedReply", status);
                iStatus = CorePlugin.createErrorStatus(msg);
                if (input == null) break block43;
                FileUtil.close(input);
            }
            if (output != null) {
                FileUtil.close(output);
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
            return iStatus;
        }
        try {
            try {
                this.isServerAlive = true;
            }
            catch (IOException ioe) {
                this.isServerAlive = false;
                String msg = CorePlugin.getString("errorPingFailed", new Object[0]);
                IStatus iStatus = CorePlugin.createErrorStatus(msg, ioe);
                if (input != null) {
                    FileUtil.close(input);
                }
                if (output != null) {
                    FileUtil.close(output);
                }
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                }
                return iStatus;
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                FileUtil.close(input);
            }
            if (output != null) {
                FileUtil.close(output);
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (input != null) {
            FileUtil.close(input);
        }
        if (output != null) {
            FileUtil.close(output);
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {}
        }
        return CorePlugin.STATUS_OK;
    }

    protected IStatus validateRemote() {
        if (this.isRemoteDebugging()) {
            return Status.OK_STATUS;
        }
        WeblogicServer server = this.getWeblogicServer();
        if (server == null) {
            String msg = CorePlugin.getString("errorDelegateDisposed", new Object[0]);
            return CorePlugin.createErrorStatus(msg, null, 5001);
        }
        CorePlugin.getLevelLog().logDebug(CorePlugin.createInfoStatus("Server watcher[" + this.getServer().getName() + "]" + ":running Weblogic detected, validating..."));
        this.addToNonProxyHosts("localhost");
        try {
            InetAddress hostAddress = InetAddress.getByName(this.getWeblogicServer().getServerInfo().getHostName());
            String hostname = hostAddress.getHostName().toLowerCase();
            this.addToNonProxyHosts(hostname);
        }
        catch (UnknownHostException unknownHostException) {}
        IJ2EEDeploymentHelper newPublisher = this.getPublisher();
        IStatus ret = newPublisher.validateRemote(server);
        return ret;
    }

    private void addToNonProxyHosts(String hostname) {
        String nonProxy = System.getProperty("http.nonProxyHosts", "");
        if (nonProxy != null && nonProxy.indexOf(hostname) < 0) {
            nonProxy = nonProxy.length() == 0 ? hostname : String.valueOf(nonProxy) + "|" + hostname;
            System.setProperty("http.nonProxyHosts", nonProxy);
            System.setProperty("socksNonProxyHost", nonProxy);
        }
    }

    private static String printDeploymentInfo(List<IWeblogicModule> modules) {
        StringBuilder b = new StringBuilder();
        b.append("Module Status: \n");
        for (IWeblogicModule module : modules) {
            WeblogicServerBehaviour.printModuleDeploymentInfo(module, b, 0);
        }
        return b.toString();
    }

    private static void printModuleDeploymentInfo(IWeblogicModule module, StringBuilder b, int depth) {
        int i = -1;
        while (i < depth) {
            b.append("-");
            ++i;
        }
        b.append(module.getModule().getName());
        if (module.getKind() == 3) {
            b.append(" (delete)");
            if (depth == 0) {
                b.append(" (undeploy)");
            }
        } else if (module.getKind() == 1) {
            b.append(" (add)");
            if (depth == 0) {
                b.append(" (deploy)");
            }
        } else if (module.getKind() == 2) {
            b.append(" (change)");
            if (module.redeploy()) {
                b.append(" (redeploy)");
            }
        }
        b.append("\n");
        for (IWeblogicModule child : module.getChildModules()) {
            WeblogicServerBehaviour.printModuleDeploymentInfo(child, b, ++depth);
        }
    }

    public boolean isDeployInSplitSrcMode() {
        return this.deployInSplitSrcMode;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                IResourceDelta[] projDeltas = delta.getAffectedChildren(4);
                int i = 0;
                while (i < projDeltas.length) {
                    IProject proj;
                    IResourceDelta projDelta = projDeltas[i];
                    if (projDelta.getResource() instanceof IProject && (projDelta.getFlags() & 0x4000) != 0 && ServerUtil.isAssociatedWithServer((IServer)this.server, (IProject)(proj = (IProject)projDelta.getResource()))) {
                        if (this.server.getServerState() == 2) {
                            this.server.publish(3, (IProgressMonitor)new NullProgressMonitor());
                        }
                        org.eclipse.wst.server.core.IModule[] iModuleArray = this.server.getModules();
                        int n = iModuleArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            org.eclipse.wst.server.core.IModule m = iModuleArray[n2];
                            if (m != null && m.getProject() != null && m.getProject().equals((Object)proj)) {
                                ServerUtil.removeModulesFromServer((IServer)this.server, (org.eclipse.wst.server.core.IModule[])new org.eclipse.wst.server.core.IModule[]{m});
                                if (this.server.getServerState() == 2) {
                                    this.server.publish(3, (IProgressMonitor)new NullProgressMonitor());
                                }
                            }
                            ++n2;
                        }
                        return;
                    }
                    ++i;
                }
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (delta.getResource() instanceof IFile) {
                            IFile f = (IFile)delta.getResource();
                            if (WeblogicServerBehaviour.this.getWeblogicServer().isRemote() && WeblogicServerBehaviour.this.checkDeployPlan(f)) {
                                ((Server)WeblogicServerBehaviour.this.server).setServerPublishState(4);
                                if (WeblogicServerBehaviour.this.server.getServerState() == 2) {
                                    WorkspaceJob job = new WorkspaceJob("Publishing..."){

                                        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                                            WeblogicServerBehaviour.this.server.publish(4, (IProgressMonitor)new NullProgressMonitor());
                                            return Status.OK_STATUS;
                                        }
                                    };
                                    job.schedule();
                                }
                            }
                            WeblogicServerBehaviour.this.updateEarModulePublishState(f);
                            if (WeblogicServerBehaviour.this.checkJmsDeployableModule(delta)) {
                                WeblogicServerBehaviour.this.isNeedsRestart = true;
                            }
                        } else {
                            return true;
                        }
                        return false;
                    }
                });
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    protected void updateEarModulePublishState(IFile f) {
        String filePath = f.getProjectRelativePath().toPortableString();
        IProject proj = f.getProject();
        if (filePath.startsWith("EarContent") && ServerUtil.isAssociatedWithServer((IServer)this.server, (IProject)proj)) {
            for (org.eclipse.wst.server.core.IModule[] mm : this.getAllModules()) {
                org.eclipse.wst.server.core.IModule root = mm[mm.length - 1];
                IProject j2eeProj = root.getProject();
                if (!j2eeProj.equals((Object)proj)) continue;
                this.setModulePublishState(mm, 3);
                break;
            }
        }
    }

    boolean checkJmsDeployableModule(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        IProject project = file.getProject();
        if (file.getName().endsWith("-jms.xml") || file.getName().endsWith("-jdbc.xml")) {
            if (JavaEEProjectUtilities.isEARProject((IProject)project) && this.isPackagedJMSModule(file)) {
                if (this.server.getServerState() == 2) {
                    if (!this.isNeedsRestart) {
                        if (this.getWeblogicServer().isRemote()) {
                            String msgJsmRestart = CorePlugin.getString("jmsChangeRequresRestartRemote", new Object[0]);
                            CorePlugin.getLevelLog().logInfo(CorePlugin.createWarnStatus(msgJsmRestart));
                        } else {
                            String msgJsmRestart = CorePlugin.getString("jmsChangeRequresRestart", new Object[0]);
                            CorePlugin.getLevelLog().logInfo(CorePlugin.createWarnStatus(msgJsmRestart));
                        }
                    }
                    return true;
                }
            } else {
                IWorkspaceModel wsmodel = WorkspaceModelFactory.create();
                for (org.eclipse.wst.server.core.IModule[] mm : this.getAllModules()) {
                    org.eclipse.wst.server.core.IModule root = mm[mm.length - 1];
                    IProject j2eeProj = root.getProject();
                    IModule wsmodule = wsmodel.getModule(j2eeProj.getName());
                    if (wsmodule == null) {
                        return false;
                    }
                    ElementList<IModuleDependency> dependecies = wsmodule.getDependencies();
                    for (IModuleDependency dep : dependecies) {
                        String filePath;
                        if (dep instanceof IWebLogicJmsConfigRef) {
                            IWebLogicJmsConfigRef jmsConfig = (IWebLogicJmsConfigRef)dep;
                            String jmsDepPath = jmsConfig.getLocation().text();
                            if (!jmsDepPath.startsWith("/")) {
                                jmsDepPath = String.valueOf('/') + jmsDepPath;
                            }
                            if ((filePath = ((File)file).getFullPath().toString()).equals(jmsDepPath)) {
                                if (delta.getKind() == 2) {
                                    if (this.server.getServerState() == 2 && !this.getWeblogicServer().isRemote()) {
                                        JMSSystemModulePublishTask.undeployJMSSystemModule(this.getWeblogicServer(), j2eeProj, file);
                                        return false;
                                    }
                                    String msgJsmRestart = CorePlugin.getString("jmsSysModuleRemoved", new Object[0]);
                                    CorePlugin.getLevelLog().logInfo(CorePlugin.createWarnStatus(msgJsmRestart));
                                }
                                this.setModulePublishState(mm, 3);
                                return false;
                            }
                        }
                        if (!(dep instanceof IWebLogicJdbcConfigRef)) continue;
                        IWebLogicJdbcConfigRef jdbcCfg = (IWebLogicJdbcConfigRef)dep;
                        String depPath = jdbcCfg.getLocation().text();
                        if (!depPath.startsWith("/")) {
                            depPath = String.valueOf('/') + depPath;
                        }
                        if (!(filePath = ((File)file).getFullPath().toString()).equals(depPath)) continue;
                        if (delta.getKind() == 2) {
                            if (this.server.getServerState() == 2 && !this.getWeblogicServer().isRemote()) {
                                JDBCSystemModulePublishTask.undeployJDBCSystemModule(this.getWeblogicServer(), j2eeProj, file);
                                return false;
                            }
                            String msgJsmRestart = CorePlugin.getString("jdbcSysModuleRemoved", new Object[0]);
                            CorePlugin.getLevelLog().logInfo(CorePlugin.createWarnStatus(msgJsmRestart));
                        }
                        this.setModulePublishState(mm, 3);
                        return false;
                    }
                }
                wsmodel.dispose();
            }
        }
        if (file.getName().endsWith("oracle.eclipse.tools.weblogic.dependencies.xml")) {
            Iterator iterator = this.getAllModules().iterator();
            while (iterator.hasNext()) {
                org.eclipse.wst.server.core.IModule[] mm;
                org.eclipse.wst.server.core.IModule[] iModuleArray = mm = (org.eclipse.wst.server.core.IModule[])iterator.next();
                int n = mm.length;
                int n2 = 0;
                while (n2 < n) {
                    org.eclipse.wst.server.core.IModule m = iModuleArray[n2];
                    IProject p = m.getProject();
                    if (p.equals((Object)project)) {
                        this.setModulePublishState(mm, 3);
                        return false;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    private boolean isPackagedJMSModule(IFile file) {
        IWebLogicAppDescriptor appDesc = WebLogicDescriptorFactory.getAppDescriptor(file.getProject());
        for (IModuleDefinition m : appDesc.getModules()) {
            String filePath;
            String path = "EarContent/" + m.getPath().text();
            if (!path.equals(filePath = file.getProjectRelativePath().toPortableString())) continue;
            appDesc.dispose();
            return true;
        }
        appDesc.dispose();
        return false;
    }

    boolean checkDeployPlan(IFile file) {
        Server server = (Server)this.getServer();
        List options = server.getAttribute("module_deploy_options", new ArrayList());
        org.eclipse.wst.server.core.IModule[] iModuleArray = server.getModules();
        int n = iModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            org.eclipse.wst.server.core.IModule module = iModuleArray[n2];
            String moduleName = module.getName();
            for (String option : options) {
                String[] kvp;
                if (option.indexOf("name=" + moduleName + ",") < 0) continue;
                String[] stringArray = kvp = option.split(",");
                int n3 = kvp.length;
                int n4 = 0;
                while (n4 < n3) {
                    String changedFilePath;
                    String planPath;
                    String planName;
                    java.io.File f;
                    String s = stringArray[n4];
                    String[] kv = s.split("=");
                    if (kv.length == 2 && kv[0].equals("deployplan") && (f = new java.io.File(planName = kv[1])).exists() && f.isFile() && (planPath = f.getAbsolutePath()).equals(changedFilePath = file.getLocation().toFile().getAbsolutePath())) {
                        server.setModulePublishState(new org.eclipse.wst.server.core.IModule[]{module}, 2);
                        return true;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return false;
    }

    public TreeMap<Integer, String> getPublishWarnings() {
        return this.publishWarnings;
    }

    public void addPublishWarnings(Integer warningId, String description) {
        if (this.publishWarnings.get(warningId) == null) {
            this.publishWarnings.put(warningId, description);
            CorePlugin.getLevelLog().logInfo(CorePlugin.createWarnStatus(description));
        }
    }

    public void resetServerWatcher() {
        if (this.watcher != null) {
            this.watcher.reset();
        }
    }

    private static interface Condition {
        public boolean isMet() throws CoreException;
    }

    private static final class Resources
    extends NLS {
        public static String warningDlgTitle;
        public static String warnModuleExistingOnServer1;
        public static String warnModuleExistingOnServer2;
        public static String wlsInProductionMode;

        static {
            Resources.initializeMessages((String)WeblogicServerBehaviour.class.getName(), Resources.class);
        }

        private Resources() {
        }

        public static final String bind(String msg, String ... args) {
            return NLS.bind((String)msg, (Object[])args);
        }
    }

    private class ShutdownJob
    extends Job {
        private ShutdownJob() {
            super(CorePlugin.getString("msgJobServerShutdown", new Object[0]));
        }

        protected IStatus run(IProgressMonitor monitor) {
            return WeblogicServerBehaviour.this.stop(monitor);
        }
    }

    private static class SpawnProcess
    extends RuntimeProcess {
        SpawnProcess(ILaunch launch, Process process, String name, Map attributes) {
            super(launch, process, name, attributes);
        }

        public boolean canTerminate() {
            return false;
        }
    }

    private class StateUpdateJob
    extends Job {
        private StateUpdateJob() {
            super(CorePlugin.getString("msgJobServerViewUpdate", new Object[0]));
        }

        protected IStatus run(IProgressMonitor monitor) {
            WeblogicServerBehaviour.this.updateState();
            return CorePlugin.STATUS_OK;
        }
    }
}

